/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.recovery.process.ICreateSnapshotHandler;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class CreateSnapshotSubProcessor
extends BaseRecoveryProcessor
implements ICreateSnapshotHandler {
    private static final long serialVersionUID = -7921173469153533993L;
    private static final Log logger = LogFactory.getInstance(CreateSnapshotSubProcessor.class);
    private String replicationId;
    private String srcDeviceId;
    private String srcLunId;
    private Integer relationType;
    private String deviceId;
    private String lunId;
    private String lunName;
    private String snapshotId = null;
    private String snapshotWWN = null;
    private String snapshotName = null;
    private String hostOrGroupIds;

    @Override
    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    @Override
    public String getLunId() {
        return this.lunId;
    }

    public void setLunId(String lunId) {
        this.lunId = lunId;
    }

    public String getLunName() {
        return this.lunName;
    }

    public void setLunName(String lunName) {
        this.lunName = lunName;
    }

    @Override
    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public void setSnapshotWWN(String snapshotWWN) {
        this.snapshotWWN = snapshotWWN;
    }

    @Override
    public String getSnapshotWWN() {
        return this.snapshotWWN;
    }

    public String getSnapshotName() {
        return this.snapshotName;
    }

    public void setSnapshotName(String snapshotName) {
        this.snapshotName = snapshotName;
    }

    public String getReplicationId() {
        return this.replicationId;
    }

    public void setReplicationId(String replicationId) {
        this.replicationId = replicationId;
    }

    public String getSrcDeviceId() {
        return this.srcDeviceId;
    }

    public void setSrcDeviceId(String srcDeviceId) {
        this.srcDeviceId = srcDeviceId;
    }

    public void setSrcLunId(String srcLunId) {
        this.srcLunId = srcLunId;
    }

    public String getSrcLunId() {
        return this.srcLunId;
    }

    public Integer getRelationType() {
        return this.relationType;
    }

    public void setRelationType(Integer relationType) {
        this.relationType = relationType;
    }

    public void setHostOrGroupIds(String hostOrGroupIds) {
        this.hostOrGroupIds = hostOrGroupIds;
    }

    public String getHostOrGroupIds() {
        return this.hostOrGroupIds;
    }

    public boolean execute(RecoveryProcessorContext context) {
        RecoveryProcessResult processResult = context.getProcessResult();
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        Lun lun = recoveryService.getTargetLunById(this.getDeviceId(), this.getLunId());
        if (null == lun) {
            this.setLunNotExist();
            return true;
        }
        this.setLunName(lun.getName());
        if (null == this.getSnapshotName()) {
            this.setSnapshotName(this.generateSnapshotName());
        }
        this.updateProcessNameParams(new String[]{this.getLunName(), this.getSnapshotName()});
        String dataConsistencyCheckingKey = RecoveryProcessResult.getDataConsistencyCheckingResultKey((String)this.deviceId, (String)this.lunId);
        Boolean dataConsistencyCheckingResult = processResult.getProcessResult(dataConsistencyCheckingKey);
        if (null == dataConsistencyCheckingResult || !dataConsistencyCheckingResult.booleanValue()) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948710", new String[0]);
            return true;
        }
        StorageSnapshotManagerProxy storageManagerProxy = StorageSnapshotManagerProxy.getInstance();
        String deviceType = recoveryService.getStorageType(this.getDeviceId());
        IStorageSnapshotManager proxy = storageManagerProxy.getStorageSnapshotMgrByDevType(deviceType);
        Snapshot paramSnapshot = new Snapshot();
        if (!VerifyUtil.isEmpty((String)this.getSnapshotId())) {
            paramSnapshot.setId(this.getSnapshotId());
        }
        paramSnapshot.setSnapshotName(this.getSnapshotName());
        if (VerifyUtil.isEmpty((String)this.getSnapshotId()) || !proxy.isSnapshotExist(this.getDeviceId(), paramSnapshot)) {
            try {
                this.createSnapshot(context, lun, proxy, paramSnapshot);
            }
            catch (LegoCheckedException e) {
                this.updateProcessDetail(e.getErrorMessageKey(), new String[]{this.getSnapshotName()});
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
                return true;
            }
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        return true;
    }

    private void setLunNotExist() {
        this.updateProcessName("ism.drm.recovery.create.snapshot.failed");
        String[] errorParams = new String[]{this.getLunId(), this.getDeviceId()};
        this.updateProcessDetail("lego.err.1073948685", errorParams);
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
    }

    private void createSnapshot(RecoveryProcessorContext context, Lun lun, IStorageSnapshotManager proxy, Snapshot paramSnapshot) {
        ArrayList<String> srcLunIds = new ArrayList<String>();
        srcLunIds.add(lun.getLunId());
        long startTime = System.currentTimeMillis();
        Snapshot newSnapshot = proxy.createSnapshot(this.getDeviceId(), srcLunIds, paramSnapshot);
        logger.debug((Object)("createSnapshot cost time:" + (System.currentTimeMillis() - startTime)));
        if (null == newSnapshot) {
            logger.error((Object)("Creating snapshot failed. DevSN:" + this.getDeviceId() + ",Name:" + this.getSnapshotName() + ",LunId:" + lun.getLunId()), 90160758784001L);
            throw new LegoCheckedException(1073948680L);
        }
        this.setSnapshotId(String.valueOf(newSnapshot.getSnapshotId()));
        this.setSnapshotWWN(newSnapshot.getWwn());
        this.putEuiToIscsiMap(context, newSnapshot);
    }

    private void putEuiToIscsiMap(RecoveryProcessorContext context, Snapshot newSnapshot) {
        Map euiToIscsiMap = (Map)context.getAttribute("snapShotNguid");
        if (VerifyUtil.isEmpty((Map)euiToIscsiMap)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put(newSnapshot.getNguid(), newSnapshot.getWwn());
            context.setAttribute("snapShotNguid", map);
        } else {
            euiToIscsiMap.put(newSnapshot.getNguid(), newSnapshot.getWwn());
        }
    }

    public String generateResultKey() {
        return RecoveryProcessResult.getCreateSnapshotProcResultKey((String)this.getDeviceId(), (String)this.getLunId());
    }

    public String getName() {
        return this.getClass().getName();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    private String generateSnapshotName() {
        StringBuilder builder = new StringBuilder();
        builder.append("DRdata_");
        builder.append(this.getLunId());
        builder.append("_");
        SimpleDateFormat df = new SimpleDateFormat("yyMMddHHmmss");
        String time = df.format(new Date());
        builder.append(time);
        builder.append(UUID.randomUUID().toString(), 0, 2);
        builder.append("_BAK");
        return builder.toString();
    }
}

