/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.CreateNasSnapshotProcessor;
import com.huawei.ism.drm.storage.recovery.process.DeleteNasSnapshotSubProcessor;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class DeleteNasSnapshotProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -4828577496312973643L;
    private static final Log logger = LogFactory.getInstance(DeleteNasSnapshotProcessor.class);
    private static final String SNAPSHOT_ID = "SnapshotId";
    private static final String RESOURCE_ID = "ResourceId";
    private static final String RESOURCE_NAME = "ResourceName";
    private static final String DEVICE_ID = "DeviceId";
    private static final String SNAPSHOT_NAME = "SnapshotName";

    public boolean execute(RecoveryProcessorContext context) {
        this.setIsResultProcessor(false);
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        List recoveryProcesses = this.getRecoveryProcessors(recoveryPlan, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING, CreateNasSnapshotProcessor.class);
        if (null == recoveryProcesses) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        Iterator iterator = recoveryProcesses.iterator();
        if (!iterator.hasNext()) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        CreateNasSnapshotProcessor backupProcessor = (CreateNasSnapshotProcessor)((Object)iterator.next());
        String snapShotInfos = backupProcessor.getSnapShotInfos();
        if (VerifyUtil.isEmpty((String)snapShotInfos)) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        HashSet<RecoveryProcessor> subProcessor = new HashSet<RecoveryProcessor>();
        try {
            this.updateSubProcessors(snapShotInfos, subProcessor);
            RecoveryProcessConcurrentExecutor recoveryTemplate = RecoveryProcessConcurrentExecutor.createExecutor(new ArrayList<RecoveryProcessor>(subProcessor));
            if (VerifyUtil.isEmpty((Object)recoveryTemplate)) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
                return true;
            }
            recoveryTemplate.process(context);
        }
        catch (Exception e) {
            logger.error((Object)("deleteFailedSnapShot failed." + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758784001L);
        }
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E procStatus = this.calcProcStatusBySubProc(subProcessor);
        this.setProcStatus(procStatus.getValue());
        return true;
    }

    private boolean updateSubProcessors(String snapShotInfos, Set<RecoveryProcessor> subProcessor) {
        JSONArray resultArray = JSONArray.fromObject((Object)snapShotInfos);
        for (Object eachSnap : resultArray) {
            String snapshotId;
            JSONObject snapInfo = JSONObject.fromObject(eachSnap);
            if (!snapInfo.containsKey((Object)SNAPSHOT_ID) || null == (snapshotId = snapInfo.getString(SNAPSHOT_ID)) || snapshotId.isEmpty()) continue;
            DeleteNasSnapshotSubProcessor processor = new DeleteNasSnapshotSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setResourceId(snapInfo.getString(RESOURCE_ID));
            processor.setResourceName(snapInfo.getString(RESOURCE_NAME));
            processor.setDeviceId(snapInfo.getString(DEVICE_ID));
            processor.setSnapshotId(snapshotId);
            processor.setSnapshotName(snapInfo.getString(SNAPSHOT_NAME));
            processor.setIsNeedSave(false);
            processor.setIsNeedCreateDetail(false);
            subProcessor.add((RecoveryProcessor)processor);
        }
        return true;
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }
}

