/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefine;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.NumberUtil;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.recovery.framework.checker.HyperMetroRecoveryProcessChecker;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.recovery.process.DisableHyperMetroSubProcessor;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DisableHyperMetroProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 422183033752891271L;
    private static final Log logger = LogFactory.getInstance(DisableHyperMetroProcessor.class);
    private static final List<Integer> AVAILABLE_RUNNING_STATUS = new ArrayList<Integer>();
    private String deviceId;

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    protected String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public void resetEnableStatus(ProtectGroup pg, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType) {
        DrmEnumDefine.APP_TYPE appType = DrmEnumDefine.APP_TYPE.getType((int)pg.getPoType());
        int templateType = pg.getTemplate().getType();
        if (appType == null) {
            return;
        }
        logger.info((Object)("resetEnableStatus APP_TYPE:" + appType.toString()));
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.equals((Object)procType) || DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SNAPSHOT_ROLLBACK.equals((Object)procType)) {
            if (HyperMetroRecoveryProcessChecker.isHyperMetroReplicationMode((int)templateType)) {
                this.setIsEnabled(true);
                this.setIsEditable(false);
            } else if (HyperMetroRecoveryProcessChecker.isReplicationHyperMetroMode((int)templateType)) {
                this.setIsEnabled(false);
                this.setIsEditable(false);
            } else if (PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(templateType)) {
                if (ProtectionJobUtil.isHyperMetroInFirstSite((ProtectGroup)pg)) {
                    this.setIsEnabled(true);
                    this.setIsEditable(false);
                } else {
                    this.setIsEnabled(false);
                    this.setIsEditable(false);
                }
            }
        }
    }

    protected boolean execute(RecoveryProcessorContext context) {
        this.setDeviceId(context.getAttribute("hyperMetroDeviceSn").toString());
        List wwnList = (List)context.getAttribute("wwnList");
        List<RecoveryProcessor> subProcessors = this.createSubProcessors(context);
        if (VerifyUtil.isEmpty(subProcessors)) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
            return true;
        }
        this.setHasChildProc(true);
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor(subProcessors, (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E)type);
        recoveryTemplate.process(context);
        boolean result = this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            result = false;
        }
        Object vstoreHyperMetroPair = context.getAttribute("vstoreHyperMetroPair");
        boolean isFileSystem = false;
        if (null != vstoreHyperMetroPair && vstoreHyperMetroPair instanceof VstoreHyperMetroPair) {
            isFileSystem = true;
        }
        if (!this.isPairAvailable(wwnList, isFileSystem)) {
            this.updateProcessDetail("lego.err.1073948754", new String[0]);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        return result;
    }

    private List<HyperMetroPair> queryHyperMetroPairList(List<String> wwnList, boolean isFileSystem) {
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(this.getDeviceId());
        if (null == drResource) {
            logger.error((Object)("DrResource is null, sn=" + this.getDeviceId()));
            throw new LegoCheckedException(2117645L);
        }
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(drResource.getSiteId());
        if (null == site) {
            logger.error((Object)("Site is null, siteId=" + drResource.getSiteId()));
            throw new LegoCheckedException(2117645L);
        }
        List pairList = isFileSystem ? StorageResourceServiceRouter.getInstance().getHyperMetroPairsByFileSystemIds(site.getServerUuid(), this.getDeviceId(), wwnList, null, true) : StorageResourceServiceRouter.getInstance().getHyperMetroPairsByWwns(site.getServerUuid(), wwnList, Boolean.valueOf(true), true);
        if (VerifyUtil.isEmpty((Collection)pairList)) {
            logger.error((Object)("HyperMetroPair List is emtpty." + wwnList));
            throw new LegoCheckedException(2117645L);
        }
        return pairList;
    }

    private boolean isPairAvailable(List<String> wwnList, boolean isFileSystem) {
        List<HyperMetroPair> pairList;
        try {
            pairList = this.queryHyperMetroPairList(wwnList, isFileSystem);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("RealTime to query hyperMetro pair error! , all wwns:" + wwnList + ",deviceId:" + this.getDeviceId()), (Throwable)e);
            return false;
        }
        for (HyperMetroPair pair : pairList) {
            Integer status;
            String runningStatus = pair.getRunningState();
            try {
                status = Integer.parseInt(runningStatus);
            }
            catch (NumberFormatException e) {
                logger.error((Object)("The pair running status is not ok! pair running status[" + runningStatus + "]."), 1073948223L);
                return false;
            }
            if (AVAILABLE_RUNNING_STATUS.contains(status)) continue;
            logger.error((Object)("The pair running status is not ok! pair running status[" + status + "]."), 1073948754L);
            return false;
        }
        return true;
    }

    private List<RecoveryProcessor> createSubProcessors(RecoveryProcessorContext context) {
        ArrayList<RecoveryProcessor> subProcessors;
        block8: {
            boolean isConsistentGroup;
            boolean isPrimary;
            String objectId;
            String runningState;
            String vstoreId;
            List hyperMetroPairList;
            block6: {
                Object consistentGroupObj;
                block7: {
                    subProcessors = new ArrayList<RecoveryProcessor>();
                    consistentGroupObj = context.getAttribute("hyperMetroConsistentGroup");
                    Object pairList = context.getAttribute("pairListInVstorePair");
                    Object pairObj = context.getAttribute("hyperMetroPairs");
                    if (null == consistentGroupObj && null == pairList && null == pairObj) {
                        logger.error((Object)("the param is null: " + this.getDeviceId()), 1073947393L);
                        throw new LegoCheckedException(1073947393L);
                    }
                    hyperMetroPairList = null;
                    if (null == consistentGroupObj && null == pairList && null != pairObj) {
                        hyperMetroPairList = new ArrayList();
                        hyperMetroPairList.addAll((List)pairObj);
                    } else if (null == consistentGroupObj && null != pairList && null == pairObj) {
                        hyperMetroPairList = (List)pairList;
                    }
                    vstoreId = (String)context.getAttribute("hyperMetroVstoreId");
                    runningState = "";
                    objectId = "";
                    isPrimary = false;
                    isConsistentGroup = false;
                    if (null == consistentGroupObj) break block6;
                    if (!(consistentGroupObj instanceof HyperMetroConsistentGroup)) break block7;
                    this.createSubProcessors(subProcessors, vstoreId, (HyperMetroConsistentGroup)consistentGroupObj);
                    break block8;
                }
                if (!(consistentGroupObj instanceof Collection)) break block8;
                this.createSubProcessors(subProcessors, vstoreId, (Collection)consistentGroupObj);
                break block8;
            }
            if (null != hyperMetroPairList) {
                for (HyperMetroPair pair : hyperMetroPairList) {
                    runningState = pair.getRunningState();
                    objectId = pair.getId();
                    isPrimary = pair.getIsPrimary();
                    isConsistentGroup = false;
                    if (XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue() != NumberUtil.convertToInteger((Object)runningState).intValue()) continue;
                    DisableHyperMetroSubProcessor disableProcessor = this.generateDisableHyperMetroSubProcessor(objectId, NumberUtil.convertToInteger((Object)runningState), isPrimary, isConsistentGroup, vstoreId);
                    subProcessors.add((RecoveryProcessor)disableProcessor);
                }
            }
        }
        return subProcessors;
    }

    private void createSubProcessors(List<RecoveryProcessor> subProcessors, String vstoreId, Collection<?> groups) {
        for (Object group : groups) {
            if (!(group instanceof HyperMetroConsistentGroup)) continue;
            this.createSubProcessors(subProcessors, vstoreId, (HyperMetroConsistentGroup)group);
        }
    }

    private void createSubProcessors(List<RecoveryProcessor> subProcessors, String vstoreId, HyperMetroConsistentGroup group) {
        boolean isPrimary;
        String objectId = group.getId();
        boolean isConsistentGroup = true;
        String runningState = group.getRunningState();
        boolean bl = isPrimary = XveEnumDefine.PRIORITY_STATION_TYPE_E.LOCAL.getValue() == group.getPriorityStationType();
        if (XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue() == NumberUtil.convertToInteger((Object)runningState).intValue()) {
            DisableHyperMetroSubProcessor disableProcessor = this.generateDisableHyperMetroSubProcessor(objectId, NumberUtil.convertToInteger((Object)runningState), isPrimary, isConsistentGroup, vstoreId);
            subProcessors.add((RecoveryProcessor)disableProcessor);
        }
    }

    private DisableHyperMetroSubProcessor generateDisableHyperMetroSubProcessor(String pairId, Integer runningState, boolean isPrimary, boolean isConsistentGroup, String vstoreId) {
        DisableHyperMetroSubProcessor processor = new DisableHyperMetroSubProcessor();
        processor.setProcName(processor.getName());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setDeviceId(this.getDeviceId());
        processor.setPairId(pairId);
        processor.setIsConsistentGroup(isConsistentGroup);
        processor.setRunningState(runningState);
        processor.setIsNeedSave(true);
        processor.setIsNeedCreateDetail(true);
        processor.setIsPrimary(isPrimary);
        processor.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
        processor.setVstoreId(vstoreId);
        return processor;
    }

    public void updateDescription() {
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.SNAPSHOT_ROLLBACK.getValue() == this.getProcType()) {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.DisableHyperMetroProcessor.sr.des");
        } else {
            this.setDescription("com.huawei.ism.drm.storage.recovery.process.DisableHyperMetroProcessor.pm.des");
        }
    }

    static {
        AVAILABLE_RUNNING_STATUS.add(XveEuumDefineParent.RUNNING_STATUS_E.PAUSE.getValue());
    }
}

