/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessSerialExecutor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.DisableTargetResourceSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.SwapReplicationSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class DisableTargetResourceProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 250833538991251159L;

    public boolean execute(RecoveryProcessorContext context) {
        List<RecoveryProcessor> allSwapReplicationProcessors = this.querySwapReplicationProcessors(context);
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            this.updateSubProcessors(allSwapReplicationProcessors);
            this.checkIfHasSubProcessor();
        }
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E type = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)this.getProcType());
        RecoveryProcessSerialExecutor recoveryTemplate = RecoveryProcessSerialExecutor.createRecoveryProcessExecutor((Set)this.getChildProc(), (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E)type);
        recoveryTemplate.process(context);
        boolean executeResult = this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            executeResult = false;
        }
        return executeResult;
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    private boolean updateSubProcessors(List<RecoveryProcessor> allSwapReplicationProcessors) {
        if (null == allSwapReplicationProcessors || allSwapReplicationProcessors.isEmpty()) {
            return true;
        }
        Set<RecoveryProcessor> subProcessors = this.createDisableTargetResourceSubProcessors(allSwapReplicationProcessors);
        if (null == this.getChildProc() || this.getChildProc().isEmpty()) {
            this.setChildProc(subProcessors);
        }
        IRecoveryProcessService recoveryProcService = (IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class);
        boolean result = recoveryProcService.updateRecoveryProcessor((RecoveryProcessor)this);
        return result;
    }

    private List<RecoveryProcessor> querySwapReplicationProcessors(RecoveryProcessorContext context) {
        DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E lastRunType = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING;
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.CLEAN_DRILLING.getValue() == this.getProcType()) {
            lastRunType = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING;
        }
        return this.getRecoveryProcessors(context.getRecoveryPlan(), lastRunType, SwapReplicationSubProcessor.class);
    }

    protected Set<RecoveryProcessor> createDisableTargetResourceSubProcessors(List<RecoveryProcessor> allSwapReplicationProcessors) {
        HashSet<RecoveryProcessor> disableTargetResourceProcessors = new HashSet<RecoveryProcessor>();
        for (RecoveryProcessor swapReplicationProcessor : allSwapReplicationProcessors) {
            SwapReplicationSubProcessor swapRepSubProcessor = (SwapReplicationSubProcessor)swapReplicationProcessor;
            DisableTargetResourceSubProcessor processor = new DisableTargetResourceSubProcessor();
            processor.setProcName(processor.getName());
            processor.setProcType(this.getProcType());
            processor.setPlanId(this.getPlanId());
            processor.setProcessId(this.getProcessId());
            processor.setParentProc((RecoveryProcessor)this);
            processor.setReplicationId(swapRepSubProcessor.getReplicationId());
            processor.setSrcDeviceId(swapRepSubProcessor.getSrcDeviceId());
            processor.setTgtDeviceId(swapRepSubProcessor.getTgtDeviceId());
            processor.setRelationType(swapRepSubProcessor.getRelationType());
            processor.setReplicationName(swapRepSubProcessor.getReplicationName());
            processor.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
            disableTargetResourceProcessors.add((RecoveryProcessor)processor);
        }
        return disableTargetResourceProcessors;
    }
}

