/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.ICreateSnapshotHandler;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Set;

public interface ICreateSnapshotController {
    public static final Log logger = LogFactory.getInstance(ICreateSnapshotController.class);

    default public void saveSnapshot(RecoveryProcessorContext context, Set<RecoveryProcessor> subProcessorSet) {
        ArrayList<StorageResource> storageResources = new ArrayList<StorageResource>();
        if (null != subProcessorSet && !subProcessorSet.isEmpty()) {
            context.removeAttribute("Target_Storage");
            for (RecoveryProcessor processor : subProcessorSet) {
                if (!(processor instanceof ICreateSnapshotHandler)) continue;
                ICreateSnapshotHandler handler = (ICreateSnapshotHandler)processor;
                String snapshotId = handler.getSnapshotId();
                String snapshotWWN = handler.getSnapshotWWN();
                if (VerifyUtil.isEmpty((String)snapshotId) || VerifyUtil.isEmpty((String)snapshotWWN)) {
                    logger.error((Object)"Snapshot's id[%s] or wwn[%s] is empty.", new Object[]{snapshotId, snapshotWWN});
                    continue;
                }
                StorageResource storageResource = new StorageResource(handler.getDeviceId(), snapshotId, snapshotWWN);
                storageResource.setParentResourceId(handler.getLunId());
                storageResources.add(storageResource);
            }
        }
        context.setAttribute("Target_Storage", storageResources);
    }
}

