/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.backup.BackupManagerProxy;
import com.huawei.ism.drm.backup.IBackupManager;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.RestoreNativeReplicaSubProcessor;
import com.huawei.ism.drm.storage.sdk.model.BackupImage;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Collection;
import java.util.HashSet;

public class RestoreNativeReplicaProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 7090425948168988665L;
    private static Log logger = LogFactory.getInstance(RestoreNativeReplicaProcessor.class);

    public boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"execute RestoreNativeReplicaProcessor");
        if (VerifyUtil.isEmpty((Object)context)) {
            logger.error((Object)"RestoreNativeReplicaProcessor: context is null.", 90160758784001L);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        if (!this.generateSubProcessor(context)) {
            logger.error((Object)"RestoreNativeReplicaProcessor: generate sub processor failed.", 90160758784001L);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        return this.executeSubProcessor(context);
    }

    private boolean generateSubProcessor(RecoveryProcessorContext context) {
        if (!VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            return true;
        }
        ProtectGroupReplica pgReplica = context.getProtectGroupReplica();
        String imageId = pgReplica.getProperty("IMAGE_ID");
        if (VerifyUtil.isEmpty((String)imageId)) {
            logger.error((Object)"RestoreNativeReplicaProcessor: IMAGE_ID is null.");
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        IBackupManager manager = BackupManagerProxy.getInstance().getBackupService("NativeBackupEngine");
        BackupImage image = manager.queryImage(pgReplica.getStorageDeviceId(), imageId);
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Object)image)) {
            logger.error((Object)("RestoreNativeReplicaProcessor: image " + imageId + " from " + pgReplica.getStorageDeviceId() + " is not exists."));
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        HashSet<RestoreNativeReplicaSubProcessor> restoreLunProcessors = new HashSet<RestoreNativeReplicaSubProcessor>();
        RestoreNativeReplicaSubProcessor subProcessor = new RestoreNativeReplicaSubProcessor();
        subProcessor.setProcName("com.huawei.ism.drm.storage.recovery.process.RestoreNativeReplicaSubProcessor");
        subProcessor.setProcType(this.getProcType());
        subProcessor.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
        subProcessor.setParentProc((RecoveryProcessor)this);
        subProcessor.setProcessId(this.getProcessId());
        subProcessor.setImageId(imageId);
        subProcessor.setImagePath(image.getBackupPath().getBricksPath());
        restoreLunProcessors.add(subProcessor);
        this.setChildProc(restoreLunProcessors);
        ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
        return true;
    }
}

