/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.service.IReplicaService;
import com.huawei.ism.drm.recovery.framework.process.AbstractRecoveryTaskInterceptor;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import org.springframework.util.Assert;

public class RollBackPreparer
extends AbstractRecoveryTaskInterceptor {
    private static final Log logger = LogFactory.getInstance(RollBackPreparer.class);

    public RollBackPreparer(BaseRecoveryProcessor interceptTask) {
        super(interceptTask);
    }

    public boolean before() {
        Assert.notNull((Object)this.getInterceptTask(), (String)"Intercept task is null");
        logger.debug((Object)"After processor execute method is called. processor is %s", new Object[]{this.getInterceptTask().getClass()});
        Assert.notNull((Object)this.getInterceptTask().getContextRef(), (String)"Recovery context of intercept task is null");
        RecoveryProcessorContext context = this.getInterceptTask().getContextRef();
        String replicaId = (String)context.getRecoveryPlan().getGlobalSettings().get("REMOTE_REPLICA_ID");
        ProtectGroupReplica replica = RecoveryProcessUtil.getProtectGroupReplicaByReplicaId((ProtectGroup)context.getProtectGroup(), (String)replicaId);
        if (VerifyUtil.isEmpty((Object)replica)) {
            logger.error((Object)"replica is null: replicaId=%s", new Object[]{replicaId});
            throw new LegoCheckedException(2117645L);
        }
        IReplicaService replicaService = (IReplicaService)ServiceLocator.getInstance().getService(IReplicaService.class);
        replica = replicaService.queryProtectGroupReplicaById(replica.getId());
        context.setAttribute("Recovery_PgReplica", (Object)replica);
        Collection tasks = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler().getLocalRecoveryTasks(context);
        context.setAttribute("recoveryTasks", (Object)tasks);
        return true;
    }

    public boolean after() {
        Assert.notNull((Object)this.getInterceptTask(), (String)"Intercept task is null");
        logger.debug((Object)"After processor execute method is called. processor is %s", new Object[]{this.getInterceptTask().getClass()});
        Assert.notNull((Object)this.getInterceptTask().getContextRef(), (String)"Recovery context of intercept task is null");
        RecoveryProcessorContext context = this.getInterceptTask().getContextRef();
        ProtectGroupReplica replica = context.getProtectGroup().getAnyoneReplicationReplica();
        context.setAttribute("Recovery_PgReplica", (Object)replica);
        Collection tasks = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler().getRecoveryTasks(context.getRecoveryPlan());
        context.setAttribute("recoveryTasks", (Object)tasks);
        return true;
    }
}

