/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.recovery.process.BaseSwapReplicationSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.SanHyperVaultSwapReplicationSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.SwapReplicationProcessor;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.Collection;
import java.util.Set;

public class SanHyperVaultSwapReplicationProcessor
extends SwapReplicationProcessor {
    private static final long serialVersionUID = 250866538991251169L;
    private boolean onlySplit = false;
    private boolean revertRep = false;

    public SanHyperVaultSwapReplicationProcessor() {
    }

    public SanHyperVaultSwapReplicationProcessor(boolean onlySplit, boolean revertRep) {
        this.setIsNeedSave(false);
        this.onlySplit = onlySplit;
        this.revertRep = revertRep;
    }

    @Override
    protected boolean updateSubProcessors(RecoveryProcessorContext context) {
        String disasterSiteId = context.getDisasterSiteId();
        ProtectGroupReplica replica = context.getProtectGroupReplica();
        if (null == replica) {
            throw new LegoCheckedException(1073947393L);
        }
        if (replica.isLocalStorageSnapshotReplica()) {
            Collection recoveryTasks = (Collection)context.getAttribute(this.getRecoveryTasksKey());
            context.setDisasterSiteId(((RecoveryTask)CommonUtil.getFirstElement((Collection)recoveryTasks)).getDisasterSite().getSiteId());
        }
        boolean result = super.updateSubProcessors(context);
        context.setDisasterSiteId(disasterSiteId);
        Set swapReplicationSubProcessors = this.getChildProc();
        if (!VerifyUtil.isEmpty((Collection)swapReplicationSubProcessors)) {
            for (RecoveryProcessor recoveryProcessor : swapReplicationSubProcessors) {
                if (!(recoveryProcessor instanceof BaseSwapReplicationSubProcessor)) continue;
                this.revertReplicationSubProcessor((BaseSwapReplicationSubProcessor)recoveryProcessor);
            }
        }
        return result;
    }

    @Override
    public BaseSwapReplicationSubProcessor getSubProcessorInstance() {
        SanHyperVaultSwapReplicationSubProcessor swapReplicationSubProcessor = new SanHyperVaultSwapReplicationSubProcessor();
        swapReplicationSubProcessor.setOnlySplit(this.onlySplit);
        return swapReplicationSubProcessor;
    }

    private void revertReplicationSubProcessor(BaseSwapReplicationSubProcessor baseSwapReplicationSubProcessor) {
        if (!this.revertRep) {
            return;
        }
        String srcDeviceId = baseSwapReplicationSubProcessor.getSrcDeviceId();
        baseSwapReplicationSubProcessor.setSrcDeviceId(baseSwapReplicationSubProcessor.getTgtDeviceId());
        baseSwapReplicationSubProcessor.setTgtDeviceId(srcDeviceId);
    }
}

