/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.HyperMetroConsistentGroup;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.sdk.service.IStorageResourceService;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SuspendHyperMetroProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -2222297489979485901L;
    private static final Log logger = LogFactory.getInstance(SuspendHyperMetroProcessor.class);
    private static final String ID = "id";
    private static final String RUNNING_STATUS = "runningStatus";
    private static final String DEV_SN = "devSn";

    protected boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"Enter into SuspendHyperMetroCgProcessor");
        RecoveryPlan recoveryPlan = context.getRecoveryPlan();
        Set pgs = recoveryPlan.getProtectGroups();
        ProtectGroup pg = (ProtectGroup)CommonUtil.getFirstElement((Collection)pgs);
        HashMap<String, String> hyperMetroInfo = new HashMap<String, String>();
        boolean isCg = true;
        try {
            isCg = SuspendHyperMetroProcessor.isHyperMetroCg(pg, hyperMetroInfo);
        }
        catch (LegoCheckedException e) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073947393", null);
            return false;
        }
        String runningStatus = (String)hyperMetroInfo.get(RUNNING_STATUS);
        Integer status = null;
        try {
            status = Integer.valueOf(runningStatus);
        }
        catch (NumberFormatException e) {
            logger.error((Object)("The consistent group running status is not ok! running status[" + runningStatus + "]."), 1073948223L);
            this.updateProcessDetail("lego.err.1073948223", null);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        if (XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue() != status.intValue()) {
            logger.error((Object)("The consistent group running status is not ok! running status[" + status + "]."), 1073948754L);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948754", null);
            return false;
        }
        String priorityStationType = (String)recoveryPlan.getGlobalSettings().get("priorityStationType");
        try {
            int value = Integer.parseInt(priorityStationType);
            DrmEnumDefine.ROLE_TYPE role = DrmEnumDefine.ROLE_TYPE.getType((int)value);
            ((IStorageResourceService)ServiceLocator.getInstance().getService(IStorageResourceService.class)).disable((String)hyperMetroInfo.get(DEV_SN), (String)hyperMetroInfo.get(ID), role, isCg, null);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("SuspendHyperMetroCg failed: " + (Object)((Object)e)));
            String[] param = new String[]{(String)hyperMetroInfo.get(ID)};
            this.updateProcessDetail("lego.err.1073948755", param);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        return true;
    }

    static boolean isHyperMetroCg(ProtectGroup pg, Map<String, String> hyperMetroInfo) {
        ProtectObjectStorageInfo posi = SuspendHyperMetroProcessor.getAnyProtectObjectStorageInfo(pg);
        String lunWWN = posi.getLunWWN();
        if (VerifyUtil.isEmpty((String)lunWWN)) {
            logger.error((Object)("lunWWN is empty. protectName:" + pg.getName()));
            throw new LegoCheckedException(1073947393L);
        }
        List<StorageResource> storageResources = SuspendHyperMetroProcessor.queryStorageResource(lunWWN);
        ArrayList<String> wwns = new ArrayList<String>();
        wwns.add(lunWWN);
        String devSn = storageResources.get(0).getDevSn();
        List pairList = StorageResourceServiceRouter.getInstance().getHyperMetroPairsByWwns(null, wwns, null, devSn, true);
        if (VerifyUtil.isEmpty((Collection)pairList)) {
            logger.error((Object)("HyperMetroPair List is emtpty." + wwns));
            throw new LegoCheckedException(1073947393L);
        }
        HyperMetroPair pair = (HyperMetroPair)CommonUtil.getFirstElement((Collection)pairList);
        String cgId = pair.getCgId();
        String id = pair.getId();
        boolean isCg = false;
        String runningStatus = pair.getRunningState();
        if (!VerifyUtil.isEmpty((String)cgId) && !"--".equals(cgId)) {
            HyperMetroConsistentGroup group = StorageResourceServiceRouter.getInstance().getHyperMetroConsistentGroup(devSn, cgId, true);
            runningStatus = group.getRunningState();
            id = cgId;
            isCg = true;
        }
        hyperMetroInfo.put(DEV_SN, devSn);
        hyperMetroInfo.put(ID, id);
        hyperMetroInfo.put(RUNNING_STATUS, runningStatus);
        return isCg;
    }

    private static ProtectObjectStorageInfo getAnyProtectObjectStorageInfo(ProtectGroup protectGroup) {
        return Optional.ofNullable(protectGroup).map(ProtectGroup::getAnyProtectObjectStorageInfo).orElseThrow(() -> new LegoCheckedException(1073947393L));
    }

    private static List<StorageResource> queryStorageResource(String lunWWN) {
        List resources = ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).getStorageResourceByWwn(new String[]{lunWWN});
        if (VerifyUtil.isEmpty((Collection)resources) || resources.size() != 2) {
            logger.error((Object)("method[getSrcDeviceSN()]. Resources is empty or the size is not two! resources size:" + resources), 90160758786897L);
            throw new LegoCheckedException(1073947393L);
        }
        return resources;
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public void updateProcessName() {
        this.setProcName("com.huawei.ism.drm.storage.recovery.process.DisableHyperMetroProcessor");
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.SuspendHyperMetroProcessor.des");
    }
}

