/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.array.sdk.model.HyperMetroDomain;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperMetroManager;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import java.util.Collection;
import java.util.List;

public class SwapVstoreHyperMetroPairProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = 197441839696664279L;
    private static final Log logger = LogFactory.getInstance(SwapVstoreHyperMetroPairProcessor.class);
    private static final long[] STATUS_QUERY_SLEEP_QUEUE = new long[]{3000L, 5000L, 8000L, 12000L, 17000L, 17000L, 12000L, 8000L, 5000L, 3000L};

    protected boolean execute(RecoveryProcessorContext context) {
        logger.info((Object)"Enter into SwapVstoreHyperMetroPairProcessor");
        VstoreHyperMetroPair vstoreHyperMetroPair = this.getVstorePairInfo(context);
        if (!this.isNeedSwitch(context, vstoreHyperMetroPair)) {
            if (this.checkHyperMetroPairStatusWithTimeOut(context)) {
                logger.info((Object)"no need swap vstorepair!");
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
                return true;
            }
            this.updateProcessDetail("lego.err.1073948756", null);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        Integer runningStatus = null;
        Integer configStatus = null;
        try {
            runningStatus = Integer.valueOf(vstoreHyperMetroPair.getRunningStatus());
            configStatus = Integer.valueOf(vstoreHyperMetroPair.getConfigStatus());
        }
        catch (NumberFormatException e) {
            logger.error((Object)("VstoreHyperMetroPair runningStatus or configStatus is not ok! runningStatus[" + vstoreHyperMetroPair.getRunningStatus() + "],configStatus[" + vstoreHyperMetroPair.getConfigStatus() + "]."), 1073948223L);
            this.updateProcessDetail("lego.err.1073948223", null);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        if (XveEuumDefineParent.RUNNING_STATUS_E.NORMAL.getValue() != runningStatus.intValue() || 0 != configStatus) {
            logger.error((Object)("VstoreHyperMetroPair runningStatus or configStatus is not ok! runningStatus[" + runningStatus + "],configStatus[" + configStatus + "]."), 1073948754L);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            this.updateProcessDetail("lego.err.1073948754", null);
            return false;
        }
        try {
            String srcDevSn = this.getDeviceSN(context);
            StorageResourceServiceRouter.getInstance().switchVstoreHyperMetroPair(srcDevSn, vstoreHyperMetroPair.getVstorePairId());
        }
        catch (LegoCheckedException e) {
            logger.error((Object)("SwapVstoreHyperMetroPairProcessor failed: " + (Object)((Object)e)));
            this.updateProcessDetail(e.getErrorMessageKey(), null);
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return false;
        }
        VstoreHyperMetroPair pair = null;
        for (long sleepTime : STATUS_QUERY_SLEEP_QUEUE) {
            CommonUtil.sleep((long)sleepTime);
            pair = this.getVstorePairInfo(context);
            if (this.isSwitched(pair) && this.checkHyperMetroPairStatus(context)) {
                this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
                return true;
            }
            CommonUtil.sleep((long)sleepTime);
        }
        logger.error((Object)"SwapVstoreHyperMetroPairProcessor failed: ");
        this.updateProcessDetail("lego.err.1073948756", null);
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
        return false;
    }

    protected VstoreHyperMetroPair getVstorePairInfo(RecoveryProcessorContext context) {
        String vStorePairId = this.getVstorePairId(context);
        if (VerifyUtil.isEmpty((String)vStorePairId)) {
            logger.error((Object)"vStoreId is null");
            throw new LegoCheckedException(1073947393L);
        }
        Collection recoveryTasks = (Collection)context.getAttribute("recoveryTasks");
        String deviceSn = ((RecoveryTask)recoveryTasks.iterator().next()).getSrcDeviceId();
        if (VerifyUtil.isEmpty((String)deviceSn)) {
            logger.error((Object)"The device SNs does not exist.");
            throw new LegoCheckedException(1073947393L);
        }
        VstoreHyperMetroPair vstoreHyperMetroPair = StorageResourceServiceRouter.getInstance().getVstoreHyperMetroPairByVstorePairId(deviceSn, vStorePairId);
        if (VerifyUtil.isEmpty((Object)vstoreHyperMetroPair)) {
            logger.error((Object)"The vstoreHyperMetroPair does not exist.");
            throw new LegoCheckedException(1073947393L);
        }
        return vstoreHyperMetroPair;
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    public void updateProcessName() {
        this.setProcName("com.huawei.ism.drm.storage.recovery.process.SwapNasWorkSiteProcessor");
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.SwapNasWorkSiteProcessor.des");
    }

    public void resetEnableStatus(ProtectGroup pg, DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E procType) {
        DrmEnumDefine.APP_TYPE appType = DrmEnumDefine.APP_TYPE.getType((int)pg.getPoType());
        int templateType = pg.getTemplate().getType();
        if (appType == null) {
            return;
        }
        logger.info((Object)("resetEnableStatus APP_TYPE:" + appType.toString()));
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.equals((Object)procType)) {
            if (this.isProtectGroupUseNasFileSystem(pg) && 18 == templateType) {
                this.setIsEnabled(true);
                this.setIsEditable(false);
            } else {
                this.setIsEnabled(false);
                this.setIsEditable(false);
            }
        }
    }

    protected String getDeviceSN(RecoveryProcessorContext context) {
        return (String)context.getAttribute("hyperMetroDeviceSn");
    }

    protected boolean isProtectGroupUseNasFileSystem(ProtectGroup pg) {
        boolean isNas = false;
        ProtectObjectStorageInfo storageInfo = (ProtectObjectStorageInfo)((ProtectObject)pg.getPolist().iterator().next()).getUsedStorageResourceSet().iterator().next();
        if (DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue() == storageInfo.getResourceType().intValue()) {
            isNas = true;
        }
        return isNas;
    }

    protected String getVstorePairId(RecoveryProcessorContext context) {
        Object ob;
        int templateType;
        ProtectGroup pg = context.getProtectGroup();
        if (pg != null && pg.getTemplate() != null && 18 == (templateType = pg.getTemplate().getType()) && (ob = context.getAttribute("vstoreHyperMetroPair")) instanceof VstoreHyperMetroPair) {
            VstoreHyperMetroPair vstorePair = (VstoreHyperMetroPair)ob;
            return vstorePair.getVstorePairId();
        }
        return null;
    }

    protected boolean isNeedSwitch(RecoveryProcessorContext context, VstoreHyperMetroPair vstoreHyperMetroPair) {
        if (context.getProtectGroup() == null || context.getProtectGroup().getTemplate() == null) {
            return false;
        }
        int templateType = context.getProtectGroup().getTemplate().getType();
        return 18 != templateType || !this.isSwitched(vstoreHyperMetroPair);
    }

    private boolean isSwitched(VstoreHyperMetroPair vstoreHyperMetroPair) {
        String active = vstoreHyperMetroPair.getActiveOrPassive();
        if (VerifyUtil.isEmpty((String)active)) {
            IStorageHyperMetroManager hyperMetroManager = (IStorageHyperMetroManager)ServiceLocator.getInstance().getService(IStorageHyperMetroManager.class);
            HyperMetroDomain domain = hyperMetroManager.queryHyperMetroDomainById(this.getDeviceSN(this.getContextRef()), vstoreHyperMetroPair.getDomainId());
            active = domain.getServiceStatus();
        }
        Integer activeOrPassive = Integer.valueOf(active);
        return XveEuumDefineParent.VSTOREPAIR_ACTIVATION_STATUS_E.ACTIVE.getValue() == activeOrPassive.intValue();
    }

    private boolean checkHyperMetroPairStatusWithTimeOut(RecoveryProcessorContext context) {
        for (long sleepTime : STATUS_QUERY_SLEEP_QUEUE) {
            CommonUtil.sleep((long)sleepTime);
            if (!this.checkHyperMetroPairStatus(context)) continue;
            return true;
        }
        return false;
    }

    protected boolean checkHyperMetroPairStatus(RecoveryProcessorContext context) {
        List wwnList = (List)context.getAttribute("wwnList");
        Collection recoveryTasks = (Collection)context.getAttribute("recoveryTasks");
        String deviceSn = ((RecoveryTask)CommonUtil.getFirstElement((Collection)recoveryTasks)).getSrcDeviceId();
        if (VerifyUtil.isEmpty((String)deviceSn)) {
            logger.error((Object)"The device SNs does not exist.");
            throw new LegoCheckedException(1073947393L);
        }
        DrResource drResource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(deviceSn);
        if (null == drResource) {
            logger.error((Object)("DrResource is null, sn=" + deviceSn));
            throw new LegoCheckedException(2117645L);
        }
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteById(drResource.getSiteId());
        if (null == site) {
            logger.error((Object)("Site is null, siteId=" + drResource.getSiteId()));
            throw new LegoCheckedException(2117645L);
        }
        List pairList = StorageResourceServiceRouter.getInstance().getHyperMetroPairsByFileSystemIds(site.getServerUuid(), deviceSn, wwnList, null, true);
        if (VerifyUtil.isEmpty((Collection)pairList)) {
            logger.error((Object)("HyperMetroPair List is emtpty." + wwnList));
            throw new LegoCheckedException(2117645L);
        }
        for (HyperMetroPair pair : pairList) {
            Integer runningStatus = Integer.valueOf(pair.getRunningState());
            if (XveEuumDefineParent.RUNNING_STATUS_E.SYNCHRONIZING.getValue() != runningStatus.intValue()) continue;
            return false;
        }
        return true;
    }
}

