/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AirGapLinkPortUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryProcessService;
import com.huawei.ism.drm.drp.util.RecoveryServiceUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.recovery.framework.process.BaseRecoveryProcessor;
import com.huawei.ism.drm.recovery.framework.process.ProtectGroupExecuteStatusChecker;
import com.huawei.ism.drm.recovery.framework.task.RecoveryProcessConcurrentExecutor;
import com.huawei.ism.drm.recovery.framework.util.RecoveryProcessUtil;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.recovery.task.RecoveryTask;
import com.huawei.ism.drm.storage.recovery.process.SyncReplicationSubProcessor;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.MessageFormatUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public class SynchronizeReplicationProcessor
extends BaseRecoveryProcessor {
    private static final long serialVersionUID = -7425949818118813246L;
    private static final Log logger = LogFactory.getInstance(SynchronizeReplicationProcessor.class);
    private int policyTemplate = -1;
    private boolean hasReversed;

    public String getName() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public boolean execute(RecoveryProcessorContext context) {
        this.initAttribute(context);
        boolean result = this.getExecResult(context);
        if (!result) {
            Optional opt = context.getProtectPortTask();
            AirGapLinkPortUtil portUtil = AirGapLinkPortUtil.getInstance();
            opt.ifPresent(task -> portUtil.consumeFailedAirGapTask(task, DrmEnumDefine.ExecTypeEnum.MANUAL.getType()));
        }
        return result;
    }

    private void initAttribute(RecoveryProcessorContext context) {
        this.policyTemplate = this.getPolicyTemplate(context);
        this.hasReversed = context.getHasReversedReplication();
    }

    private boolean getExecResult(RecoveryProcessorContext context) {
        boolean isVasaPlanedMotion;
        boolean bl = isVasaPlanedMotion = DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue() == this.getProcType() && LegoConfig.getInstance().getBoolean("VASA", Boolean.valueOf(false)) != false;
        if (isVasaPlanedMotion) {
            logger.info((Object)"it is vasa planed motion, return true.");
            return true;
        }
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DRILLING.getValue() == this.getProcType()) {
            ProtectGroup protectGroup = this.getProtectGroup(context);
            ProtectGroupReplica replica = protectGroup.getReplicationReplicaByRecoverySiteId(context.getDisasterSiteId());
            if (null == replica) {
                String errorMsg = MessageFormatUtil.format((String)"Test operate failed, cannot find replica related to recoverySite (siteId:{0}) from protectGroup (pgName:{1},pgId:{2}).", (Object[])new Object[]{context.getDisasterSiteId(), protectGroup.getName(), protectGroup.getUuid()});
                logger.error((Object)errorMsg, 1073947393L);
                throw new LegoCheckedException(1073947393L);
            }
            int templateType = protectGroup.getTemplate().getType();
            if (1 != replica.getType() || PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(templateType)) {
                ProtectGroupExecuteStatusChecker checker = new ProtectGroupExecuteStatusChecker(protectGroup, (BaseRecoveryProcessor)this, context.getDisasterSiteId());
                return checker.startProcess();
            }
        }
        Collection recoveryTasks = RecoveryProcessUtil.filterRecoveryTask((RecoveryProcessorContext)context, (String)this.getRecoveryTasksKey());
        if (context.getProtectGroupReplica().isLocalStorageSnapshotReplica()) {
            this.updateSubProcessors(RecoveryTaskUtil.getRootRecoveryTasks((Collection)recoveryTasks), ((RecoveryTask)CommonUtil.getFirstElement((Collection)recoveryTasks)).getDisasterSite().getSiteId());
        } else {
            this.updateSubProcessors(RecoveryTaskUtil.getRootRecoveryTasks((Collection)recoveryTasks), context.getDisasterSiteId());
        }
        List processors = RecoveryServiceUtil.sortAndUpdateProcessorRation((Set)this.getChildProc());
        RecoveryProcessConcurrentExecutor concurrentExecutor = RecoveryProcessConcurrentExecutor.createExecutor((List)processors);
        concurrentExecutor.process(context);
        return this.checkExecuteResult();
    }

    private boolean checkExecuteResult() {
        boolean executeResult = this.calcProcessResultBySubProc();
        if (DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.PART_SUCCESS.getValue() == this.getProcStatus()) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            executeResult = false;
        }
        return executeResult;
    }

    private ProtectGroup getProtectGroup(RecoveryProcessorContext context) {
        if (null == context.getRecoveryPlan() || null == context.getRecoveryPlan().getProtectGroups()) {
            logger.error((Object)"recoveryPlan or protectGroups of recoveryPlan is null .");
            throw new LegoCheckedException(1073947393L);
        }
        Iterator iterator = context.getRecoveryPlan().getProtectGroups().iterator();
        if (!iterator.hasNext()) {
            logger.error((Object)"protectGroups of recoveryPlan is empty .");
            throw new LegoCheckedException(1073947393L);
        }
        return (ProtectGroup)iterator.next();
    }

    public String generateResultKey() {
        throw new LegoUnsupportedOperationException("The operation is not supported.");
    }

    protected boolean isSameProcessor(RecoveryProcessor oldProcess, RecoveryProcessor newProcess) {
        if (null == oldProcess || null == newProcess) {
            return false;
        }
        SyncReplicationSubProcessor preProcessor = (SyncReplicationSubProcessor)oldProcess;
        SyncReplicationSubProcessor newProcessor = (SyncReplicationSubProcessor)newProcess;
        return preProcessor.getReplicationId().equals(newProcessor.getReplicationId()) && preProcessor.getSrcDeviceId().equals(newProcessor.getSrcDeviceId()) && preProcessor.getTgtDeviceId().equals(newProcessor.getTgtDeviceId()) && preProcessor.getRelationType().equals(newProcessor.getRelationType());
    }

    private boolean updateSubProcessors(Collection<RecoveryTask> recoveryTasks, String disasterSiteId) {
        HashSet<RecoveryProcessor> syncReplicationSubProcessors = new HashSet<RecoveryProcessor>();
        for (RecoveryTask recoveryTask : recoveryTasks) {
            RecoveryProcessor processor = this.createSubProcessorsByRecoveryTask(recoveryTask, disasterSiteId);
            if (null == processor) continue;
            syncReplicationSubProcessors.add(processor);
        }
        if (VerifyUtil.isEmpty((Collection)this.getChildProc())) {
            this.setChildProc(syncReplicationSubProcessors);
        } else {
            this.updateSubProcessors(syncReplicationSubProcessors);
        }
        return ((IRecoveryProcessService)ServiceLocator.getInstance().getService(IRecoveryProcessService.class)).updateRecoveryProcessor((RecoveryProcessor)this);
    }

    private RecoveryProcessor createSubProcessorsByRecoveryTask(RecoveryTask recoveryTask, String disasterSiteId) {
        if (null == recoveryTask) {
            return null;
        }
        if (recoveryTask.getDisasterSite().getSiteId().equals(disasterSiteId)) {
            Map params = recoveryTask.getParams();
            if (null == params || Boolean.FALSE.equals(params.get("standby"))) {
                SyncReplicationSubProcessor syncReplicationSubProcessors = this.createSyncReplicationSubProcessor(recoveryTask);
                return syncReplicationSubProcessors;
            }
            logger.debug((Object)"standby task do not process,task id: %s, productionSite:%s, disasterSite:%s. ", new Object[]{recoveryTask.getTaskId(), recoveryTask.getProductionSite(), recoveryTask.getDisasterSite()});
            return null;
        }
        if (!VerifyUtil.isEmpty((Collection)recoveryTask.getCascadeTasks())) {
            for (RecoveryTask cascadeTask : recoveryTask.getCascadeTasks()) {
                logger.debug((Object)"cascadeTask: %s, productionSite:%s, disasterSite:%s. ", new Object[]{cascadeTask.getTaskId(), cascadeTask.getProductionSite(), cascadeTask.getDisasterSite()});
                RecoveryProcessor cascadeProcessor = this.createSubProcessorsByRecoveryTask(cascadeTask, disasterSiteId);
                if (VerifyUtil.isEmpty((Object)cascadeProcessor)) continue;
                SyncReplicationSubProcessor processor = this.createSyncReplicationSubProcessor(recoveryTask);
                processor.setNextCascadeProcessor(cascadeProcessor);
                return processor;
            }
        }
        if (!VerifyUtil.isEmpty((Collection)recoveryTask.getParallelTasks())) {
            for (RecoveryTask parallelTask : recoveryTask.getParallelTasks()) {
                logger.debug((Object)"parallelTask: %s, productionSite:%s, disasterSite:%s. ", new Object[]{parallelTask.getTaskId(), parallelTask.getProductionSite(), parallelTask.getDisasterSite()});
                RecoveryProcessor parallelProcessor = this.createSubProcessorsByRecoveryTask(parallelTask, disasterSiteId);
                if (VerifyUtil.isEmpty((Object)parallelProcessor)) continue;
                return parallelProcessor;
            }
        }
        return null;
    }

    private RecoveryProcessor buildProcessorCascadeRelation(RecoveryTask task, RecoveryProcessor processor, String disasterSiteId) {
        if (null == task.getCascadeTasks()) {
            return processor;
        }
        Iterator iterator = task.getCascadeTasks().iterator();
        if (!iterator.hasNext()) {
            return processor;
        }
        RecoveryTask recoveryTask = (RecoveryTask)iterator.next();
        if (!this.isSuitalbeTask(recoveryTask, task.getCascadeTasks(), disasterSiteId)) {
            return processor;
        }
        SyncReplicationSubProcessor cascadeSyncProcessor = this.createSyncReplicationSubProcessor(recoveryTask);
        processor.setNextCascadeProcessor((RecoveryProcessor)cascadeSyncProcessor);
        if (!VerifyUtil.isEmpty((Collection)recoveryTask.getCascadeTasks())) {
            this.buildProcessorCascadeRelation(recoveryTask, (RecoveryProcessor)cascadeSyncProcessor, disasterSiteId);
        }
        return processor;
    }

    private boolean isSuitalbeTask(RecoveryTask task, Set<RecoveryTask> cascadeTasks, String disasterSiteId) {
        if (task.getDisasterSite().getSiteId().equals(disasterSiteId)) {
            return true;
        }
        for (RecoveryTask tempTask : cascadeTasks) {
            if (!tempTask.getDisasterSite().getSiteId().equals(disasterSiteId)) continue;
            return true;
        }
        return false;
    }

    private SyncReplicationSubProcessor createSyncReplicationSubProcessor(RecoveryTask recoveryTask) {
        SyncReplicationSubProcessor processor = new SyncReplicationSubProcessor();
        processor.setProcName(processor.getName());
        processor.setProcType(this.getProcType());
        processor.setPlanId(this.getPlanId());
        processor.setProcessId(this.getProcessId());
        processor.setParentProc((RecoveryProcessor)this);
        processor.setReplicationId(recoveryTask.getProtectId());
        String currentSrcDeviceSN = this.hasReversed ? recoveryTask.getTgtDevcieId() : recoveryTask.getSrcDeviceId();
        String currentTargetDeviceSN = this.hasReversed ? recoveryTask.getSrcDeviceId() : recoveryTask.getTgtDevcieId();
        processor.setCurrentSrcDeviceSN(currentSrcDeviceSN);
        processor.setCurrentTgtDeviceSN(currentTargetDeviceSN);
        processor.setSrcDeviceId(recoveryTask.getSrcDeviceId());
        processor.setTgtDeviceId(recoveryTask.getTgtDevcieId());
        processor.setRelationType(recoveryTask.getProtectType());
        processor.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.OTHER.getValue());
        return processor;
    }

    public void updateDescription() {
        this.setDescription("com.huawei.ism.drm.storage.recovery.process.SynchronizeReplicationProcessor.des");
    }

    public int getPolicyTemplate(RecoveryProcessorContext context) {
        return Optional.ofNullable(context.getProtectGroup()).map(ProtectGroup::getTemplate).map(PolicyTemplate::getType).orElse(-1);
    }

    public String getRecoveryTasksKey() {
        if (this.policyTemplate == 45) {
            return "remoteRecoveryTasks";
        }
        return super.getRecoveryTasksKey();
    }
}

