/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process.replication;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryPlan;
import com.huawei.ism.drm.recovery.framework.process.RecoveryProcessorMgr;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.recovery.process.replication.ReplicationOperateSubProcessor;
import com.huawei.ism.drm.storage.recovery.process.replication.ReplicationProcessor;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;

public class SplitReplicationProcessor
extends ReplicationProcessor {
    private static final Log LOG = LogFactory.getInstance(SplitReplicationProcessor.class);
    private static final long serialVersionUID = -2022691332830293330L;

    public SplitReplicationProcessor() {
        super(ReplicationOperateSubProcessor::createReplicationGroupSplitProcessor, ReplicationOperateSubProcessor::createReplicationPairSplitProcessor);
    }

    @Override
    protected boolean execute(RecoveryProcessorContext context) {
        boolean executeResult = super.execute(context);
        if (!executeResult) {
            return false;
        }
        if (this.getProcType() == DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue() || this.getProcType() == DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.PLANED_MOTION.getValue()) {
            Site productionSite = (Site)context.getObject("productionSite", Site.class);
            RecoveryPlan recoveryPlan = context.getRecoveryPlan();
            boolean setPPInvalidResult = RecoveryProcessorMgr.getInstance().getRecoveryProcessHandler().setProtectGroupsInvalid(productionSite, recoveryPlan.getProtectGroups(), DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.getType((int)this.getProcType()));
            if (!setPPInvalidResult) {
                LOG.error((Object)"Setting remote protect policy invalid failed.");
            }
        }
        return true;
    }
}

