/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process.snapshot;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.base.sdk.model.AbstractEntity;
import com.huawei.ism.cbb.base.dao.impl.MoDao;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.model.RecoveryProcessor;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.recovery.process.common.CommonRecoveryProcessor;
import com.huawei.ism.drm.storage.recovery.process.snapshot.CreateSnapshotBackupCopySubProcessor;
import com.huawei.ism.drm.storage.recovery.process.util.RecoveryProcessorContextUtil;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class CreateSnapshotBackupCopyProcessor
extends CommonRecoveryProcessor {
    private static final long serialVersionUID = -8302465737493557916L;

    @Override
    protected Set<RecoveryProcessor> createProcessors(RecoveryProcessorContext context) {
        HashSet<RecoveryProcessor> mapping = new HashSet<RecoveryProcessor>();
        List<String> wwnList = RecoveryProcessorContextUtil.getStorageWwn(context);
        if (this.getProcType() != DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue()) {
            mapping.addAll(this.buildCreateSnapshotSubProcessorFromHyperMetroPair(wwnList));
        }
        mapping.addAll(this.buildCreateSnapshotSubProcessorFromReplication(wwnList));
        return mapping;
    }

    private Set<CreateSnapshotBackupCopySubProcessor> buildCreateSnapshotSubProcessorFromHyperMetroPair(List<String> wwnList) {
        if (wwnList.isEmpty() || this.getProcType() == DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue()) {
            return Collections.emptySet();
        }
        HashMap<String, String[]> conditions = new HashMap<String, String[]>();
        conditions.put("resourceWwn", wwnList.toArray(new String[0]));
        List hyperMetroPairList = ((MoDao)ServiceLocator.getInstance().getService(MoDao.class)).findMoBy(HyperMetroPair.class, conditions);
        Map<String, List<HyperMetroPair>> hyperMetroPairMapping = hyperMetroPairList.stream().collect(Collectors.groupingBy(AbstractEntity::getDevSn));
        return hyperMetroPairMapping.entrySet().stream().flatMap(entry -> this.getHyperMetroPairLunWwn((Map.Entry<String, List<HyperMetroPair>>)entry).stream()).collect(Collectors.toSet());
    }

    private List<CreateSnapshotBackupCopySubProcessor> getHyperMetroPairLunWwn(Map.Entry<String, List<HyperMetroPair>> entry) {
        String devSn = entry.getKey();
        List<HyperMetroPair> hyperMetroPairs = entry.getValue();
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        Set wwnList = hyperMetroPairs.stream().map(HyperMetroPair::getResourceWwn).collect(Collectors.toSet());
        return storageService.getLunByWwn(devSn, wwnList).stream().filter(lun -> Objects.equals(lun.getDevSn(), devSn)).map(lun -> new CreateSnapshotBackupCopySubProcessor(devSn, lun.getLunId(), lun.getName())).collect(Collectors.toList());
    }

    private Set<CreateSnapshotBackupCopySubProcessor> buildCreateSnapshotSubProcessorFromReplication(List<String> wwnList) {
        if (wwnList.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<CreateSnapshotBackupCopySubProcessor> devSnAndLunMapping = new HashSet<CreateSnapshotBackupCopySubProcessor>();
        IStorageService storageService = (IStorageService)ServiceLocator.getInstance().getService(IStorageService.class);
        List pairs = storageService.queryReplicationPairsByMasterLunWWN(wwnList, true);
        if (this.getProcType() != DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.DISASTER_RECOVERY.getValue()) {
            devSnAndLunMapping.addAll(this.loadDevSnAndLunIdMappingFromSourceLocation(pairs));
        }
        devSnAndLunMapping.addAll(this.loadDevSnAndLunIdMappingFromTargetLocation(pairs));
        return devSnAndLunMapping;
    }

    private Set<CreateSnapshotBackupCopySubProcessor> loadDevSnAndLunMapping(List<ReplicationPair> pairs, Function<ReplicationPair, String> devSn, Function<ReplicationPair, String> lunId, Function<ReplicationPair, String> lunName) {
        Map<String, List<ReplicationPair>> replicationMapping = pairs.stream().collect(Collectors.groupingBy(devSn));
        return replicationMapping.entrySet().stream().flatMap(entry -> this.getReplicationLunWwn((String)entry.getKey(), (List)entry.getValue(), lunId, lunName).stream()).collect(Collectors.toSet());
    }

    private Set<CreateSnapshotBackupCopySubProcessor> loadDevSnAndLunIdMappingFromSourceLocation(List<ReplicationPair> pairs) {
        return this.loadDevSnAndLunMapping(pairs, ReplicationRelation::getSrcDevSN, ReplicationPair::getSrcLunId, ReplicationPair::getSrcLunName);
    }

    private Set<CreateSnapshotBackupCopySubProcessor> loadDevSnAndLunIdMappingFromTargetLocation(List<ReplicationPair> pairs) {
        return this.loadDevSnAndLunMapping(pairs, ReplicationPair::getTgtDevSN, ReplicationPair::getTgtLunId, pair -> ((ReplicationTargetLun)pair.getRepTgtLuns().get(0)).getTgtLunName());
    }

    private List<CreateSnapshotBackupCopySubProcessor> getReplicationLunWwn(String devSn, List<ReplicationPair> replicationPairs, Function<ReplicationPair, String> lunId, Function<ReplicationPair, String> lunName) {
        return replicationPairs.stream().map(pair -> new CreateSnapshotBackupCopySubProcessor(devSn, (String)lunId.apply((ReplicationPair)pair), (String)lunName.apply((ReplicationPair)pair))).collect(Collectors.toList());
    }
}

