/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.recovery.process.snapshot;

import com.huawei.ism.drm.base.util.DrmStorageUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.process.RecoveryProcessorContext;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotManager;
import com.huawei.ism.drm.storage.recovery.process.common.CommonRecoveryProcessor;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

public class CreateSnapshotBackupCopySubProcessor
extends CommonRecoveryProcessor {
    private static final long serialVersionUID = -3340053699095706084L;
    private static final Log LOG = LogFactory.getInstance(CreateSnapshotBackupCopySubProcessor.class);
    private String devSn;
    private String lunId;
    private String lunName;

    public CreateSnapshotBackupCopySubProcessor() {
    }

    public CreateSnapshotBackupCopySubProcessor(String devSn, String lunId, String lunName) {
        this.devSn = devSn;
        this.lunId = lunId;
        this.lunName = lunName;
    }

    public String getDevSn() {
        return this.devSn;
    }

    public void setDevSn(String devSn) {
        this.devSn = devSn;
    }

    public String getLunId() {
        return this.lunId;
    }

    public void setLunId(String lunId) {
        this.lunId = lunId;
    }

    public String getLunName() {
        return this.lunName;
    }

    public void setLunName(String lunName) {
        this.lunName = lunName;
    }

    protected String generateResultKey() {
        return String.format(Locale.ENGLISH, "step=snapshot-backup-copy,dev-sn=%s,lun-id=%s", this.devSn, this.lunId);
    }

    @Override
    protected void executeSubProcessors(RecoveryProcessorContext context) {
        this.updateProcessNameParams(new String[]{this.devSn, this.lunId, this.lunName});
        String snapshotName = DrmStorageUtil.generateRecoverySnapshotName((String)this.lunId);
        Snapshot snapshot = this.createSnapshot(snapshotName);
        if (snapshot == null) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return;
        }
        String snapshotId = snapshot.getSnapshotId();
        if (snapshotId == null) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
            return;
        }
        this.updateProcessDetail("ism.drm.recovery.process.snapshot.success", new String[]{snapshotId, snapshotName});
        this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        this.activeSnapshot(snapshotId);
    }

    private void activeSnapshot(String snapshotId) {
        StorageSnapshotManagerProxy storageManagerProxy = StorageSnapshotManagerProxy.getInstance();
        IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
        String deviceType = recoveryService.getStorageType(this.getDevSn());
        IStorageSnapshotManager proxy = storageManagerProxy.getStorageSnapshotMgrByDevType(deviceType);
        long startTime = System.currentTimeMillis();
        OperationResult operationResult = proxy.activeSnapshotAfterStop(this.getDevSn(), Collections.singletonList(snapshotId));
        LOG.info((Object)"ActiveSnapshotAfterStop cost time: devSn=%s, snapshotId=%s, costTime=%s", new Object[]{this.getDevSn(), snapshotId, System.currentTimeMillis() - startTime});
        if (operationResult != null && !operationResult.isSuccess()) {
            this.updateProcessDetail("lego.err." + operationResult.getErrorCode(), operationResult.getArgs());
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.FAILED.getValue());
        } else if (operationResult != null) {
            this.setProcStatus(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_RESULT_E.SUCCESS.getValue());
        } else {
            LOG.info((Object)"Result for ActiveSnapshot is null. snapshotId=%s", new Object[]{snapshotId});
        }
    }

    private Snapshot createSnapshot(String snapshotName) {
        Snapshot snapshot = new Snapshot();
        snapshot.setSnapshotName(snapshotName);
        snapshot.setDescription("Created by OceanStor BCManager");
        IStorageSnapshotManager storageSnapshotMgr = StorageSnapshotManagerProxy.getInstance().getStorageSnapshotMgrByDevId(this.devSn);
        List<String> lunIds = Collections.singletonList(this.lunId);
        return storageSnapshotMgr.createSnapshot(this.devSn, lunIds, snapshot);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        CreateSnapshotBackupCopySubProcessor that = (CreateSnapshotBackupCopySubProcessor)((Object)obj);
        return Arrays.equals(this.identifiers(), that.identifiers());
    }

    private Object[] identifiers() {
        return new Object[]{this.getPlanId(), this.devSn, this.lunId};
    }

    public int hashCode() {
        return Objects.hash(this.identifiers());
    }
}

