/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.replication.builder;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DiskProtectStatusEnum;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.framework.service.group.ProtectGroupServiceImpl;
import com.huawei.ism.drm.protection.group.sdk.model.DiskInfo;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.model.StoragePair;
import com.huawei.ism.drm.storage.manager.sdk.service.IReplicationGroupBuilder;
import com.huawei.ism.drm.storage.replication.builder.CreateReplicationPairTask;
import com.huawei.ism.drm.storage.replication.builder.DeleteReplicationPairTask;
import com.huawei.ism.drm.storage.replication.builder.ReplicationGroupBuilderManager;
import com.huawei.ism.drm.storage.replication.builder.ReplicationGroupRollbackItem;
import com.huawei.ism.drm.storage.replication.builder.ReplicationPairConfiguration;
import com.huawei.ism.drm.storage.replication.builder.ReplicationPairRollbackItem;
import com.huawei.ism.drm.storage.replication.builder.ReplicationRollbackTask;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.lego.cbb.resource.rollback.IRollbackItem;
import com.huawei.lego.core.base.thread.ExecutionService;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.LegoConfig;
import com.huawei.lego.core.sdk.util.MessageFormatUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;

public class StorageReplicationGroupFactory {
    private static Log logger = LogFactory.getInstance(StorageReplicationGroupFactory.class);
    private boolean failed = false;
    private ReplicationRollbackTask rollback = new ReplicationRollbackTask();
    private ProtectGroup protectGroupInDb;
    private List<DiskInfo> diskInfoList;

    private StorageReplicationGroupFactory() {
    }

    public static StorageReplicationGroupFactory newFactory() {
        return new StorageReplicationGroupFactory();
    }

    public boolean deleteReplicationGroup(ProtectGroup protectGroup) {
        if (null == protectGroup) {
            String errorMsg = "Protect Group is null";
            logger.error((Object)"Protect Group is null.", 90160758787071L);
            throw new LegoCheckedException(1073947393L, errorMsg);
        }
        ArrayList<ProtectObjectStorageInfo> protectObjectStorageInfoSet = new ArrayList<ProtectObjectStorageInfo>();
        IProtectGroupService groupService = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        this.diskInfoList = groupService.queryDiskInfo(protectGroup);
        ProtectGroupServiceImpl.logDiskInfo((String)protectGroup.getName(), this.diskInfoList);
        for (DiskInfo diskInfo : this.diskInfoList) {
            if (DiskProtectStatusEnum.UNPROTECTED.getStatus().equals(diskInfo.getStatus())) continue;
            ProtectObjectStorageInfo protectObjectStorageInfo = new ProtectObjectStorageInfo();
            protectObjectStorageInfo.setResourceProviderSN(diskInfo.getDevSn());
            protectObjectStorageInfo.setResourceId(diskInfo.getResourceId());
            protectObjectStorageInfoSet.add(protectObjectStorageInfo);
        }
        Stack<List<ReplicationPair>> pairStack = this.retrieveAllReplicationPair(protectObjectStorageInfoSet);
        LinkedList<Object> rollbackItemQueue = new LinkedList<Object>();
        while (!pairStack.isEmpty()) {
            List<ReplicationPair> oneList = pairStack.pop();
            Map<String, List<ReplicationPair>> pairMap = this.groupReplicationPair(oneList);
            if (pairMap.isEmpty()) {
                rollbackItemQueue.add(new ReplicationPairRollbackItem(oneList));
                continue;
            }
            for (Map.Entry<String, List<ReplicationPair>> entry : pairMap.entrySet()) {
                if (null == entry) continue;
                String cgId = entry.getKey();
                List<ReplicationPair> pairList = entry.getValue();
                ReplicationPair tmpPair = pairList.iterator().next();
                String srcDevSN = tmpPair.getSrcDevSN();
                String tgtDevSN = tmpPair.getTgtDevSN();
                ReplicationGroup group = this.getReplicationGroup(srcDevSN, tgtDevSN, cgId);
                rollbackItemQueue.add(new ReplicationPairRollbackItem(pairList));
                rollbackItemQueue.add(new ReplicationGroupRollbackItem(group));
            }
        }
        ReplicationRollbackTask rollbackTask = new ReplicationRollbackTask();
        while (!rollbackItemQueue.isEmpty()) {
            rollbackTask.addItem((IRollbackItem)rollbackItemQueue.poll());
        }
        return rollbackTask.execute(protectGroup);
    }

    public List<ReplicationGroup> buildReplicationGroup(ProtectGroup protectGroup) {
        block4: {
            if (null == protectGroup) {
                String errorMsg = "Protect Group is null";
                logger.error((Object)"Protect Group is null.", 90160758787071L);
                throw new LegoCheckedException(1073947393L, errorMsg);
            }
            String protectGroupId = protectGroup.getUuid();
            try {
                IProtectGroupService groupServcie = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
                this.protectGroupInDb = groupServcie.getProtectGroupByID(protectGroupId, false);
            }
            catch (LegoCheckedException e) {
                if (e.getErrorCode() != 1073947394L) break block4;
                this.handleException(protectGroup);
                String msg = "Protect Group does't exists in db. begin to create replication for protect group";
                logger.info((Object)msg);
                return this.createReplicationGroup(protectGroup);
            }
        }
        if (null == this.protectGroupInDb) {
            logger.error((Object)"Protect group does not exists in db");
            throw new LegoCheckedException(1073947394L);
        }
        return this.updateReplicationGroup(protectGroup);
    }

    private void handleException(ProtectGroup protectGroup) {
        Map<String, List<String>> deviceStorageMap = this.getReplicaMap();
        List allStorageInfoList = protectGroup.distinctStorageInfo();
        for (Map.Entry<String, List<String>> entry : deviceStorageMap.entrySet()) {
            for (ProtectObjectStorageInfo addedStorageInfo : allStorageInfoList) {
                String[] entryKey = entry.getKey().split("@");
                if (!entryKey[1].equals(addedStorageInfo.getResourceProviderSN()) || !entry.getValue().contains(addedStorageInfo.getResourceId())) continue;
                String errorMsg = "Delete replication pairs failed, pair info is: + " + addedStorageInfo.getDeviceName();
                logger.error((Object)errorMsg, 90160758787071L);
                throw new LegoCheckedException(1073947693L, new String[]{entryKey[0]});
            }
        }
    }

    private List<ReplicationGroup> createReplicationGroup(ProtectGroup protectGroup) {
        IProtectGroupService groupServcie = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        this.diskInfoList = groupServcie.queryDiskInfo(protectGroup);
        ReplicationGroupBuilderManager manager = ReplicationGroupBuilderManager.getInstance();
        IReplicationGroupBuilder builder = manager.getBuilder(protectGroup.getPoType());
        List groups = builder.buildReplicationGroup(protectGroup);
        String replicationCfg = (String)protectGroup.getProps().get("storagePoolMapping");
        ReplicationPairConfiguration config = new ReplicationPairConfiguration(replicationCfg);
        List<ReplicationGroup> results = null;
        try {
            results = this.createReplicationGroup(protectGroup, groups, config);
        }
        catch (Exception e) {
            logger.error((Object)"An exception occurred while creating a consistency group", 90160758787071L);
            if (!this.isReProtectProcess(protectGroup)) {
                this.rollback.execute(protectGroup);
            }
            throw e;
        }
        return results;
    }

    private Set<ProtectObjectReplica> getReplicas(String poReplicaMateData) {
        HashSet<ProtectObjectReplica> replicas = new HashSet<ProtectObjectReplica>();
        if (!VerifyUtil.isEmpty((String)poReplicaMateData)) {
            JSONArray poReplicaJsonArray = JSONArray.fromObject((Object)poReplicaMateData);
            for (int i = 0; i < poReplicaJsonArray.size(); ++i) {
                JSONObject json = JSONObject.fromObject((Object)poReplicaJsonArray.get(i));
                ProtectObjectReplica poReplica = ProtectObjectReplica.toBean((JSONObject)json);
                replicas.add(poReplica);
            }
        }
        return replicas;
    }

    public Map<String, List<ReplicationPair>> groupReplicationPair(List<ReplicationPair> pairList) {
        HashMap<String, List<ReplicationPair>> result = new HashMap<String, List<ReplicationPair>>();
        for (ReplicationPair onePair : pairList) {
            String consistentGroupId = onePair.getConsistentGroupId();
            if (null == consistentGroupId) continue;
            if (!result.containsKey(consistentGroupId)) {
                ArrayList groupedPairList = new ArrayList();
                result.put(consistentGroupId, groupedPairList);
            }
            ((List)result.get(consistentGroupId)).add(onePair);
        }
        return result;
    }

    public Map<String, List<String>> getReplicaMap() {
        List poReplicaMateData = CommonDAOLocator.getBaseDao().getHibernateTemplate().find("select name , poReplicaMateData from ProtectGroupReplica where REPLICATYPE = 2", new Object[0]);
        HashMap<String, Set<ProtectObjectReplica>> poReplicaMap = new HashMap<String, Set<ProtectObjectReplica>>();
        for (Object[] str : poReplicaMateData) {
            String replicaName = str[0].toString();
            int start = replicaName.indexOf("-");
            int end = replicaName.lastIndexOf("-");
            if (start < 0 || end < 0 || start == end) {
                logger.error((Object)"replicaName is invalid.");
                throw new LegoCheckedException(-1L);
            }
            poReplicaMap.put(replicaName.substring(start + 1, end), this.getReplicas(str[1].toString()));
        }
        HashMap<String, List<String>> deviceStorageMap = new HashMap<String, List<String>>();
        for (Map.Entry params : poReplicaMap.entrySet()) {
            for (ProtectObjectReplica poReplica : (Set)params.getValue()) {
                for (RelicaStorageInfo replica : poReplica.getStorageInfos()) {
                    String srcStorageIdAndName = CommUtil.combineStringBySign((String[])new String[]{(String)params.getKey(), replica.getSrcStorageProviderSN()});
                    CommUtil.addToMap(deviceStorageMap, (String)srcStorageIdAndName, (Object)replica.getSrcStorageId());
                }
            }
        }
        return deviceStorageMap;
    }

    private List<ReplicationGroup> updateReplicationGroup(ProtectGroup protectGroup) {
        String recoveryPlanStatus;
        IProtectGroupService groupServcie = (IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class);
        this.diskInfoList = groupServcie.queryDiskInfo(protectGroup);
        ProtectGroupServiceImpl.logDiskInfo((String)protectGroup.getName(), this.diskInfoList);
        Collection<Object> addedStorageInfoSet = new ArrayList();
        ArrayList<ProtectObjectStorageInfo> deletedStorageInfoSet = new ArrayList();
        Map<String, List<String>> deviceStorageMap = this.getReplicaMap();
        for (DiskInfo diskInfo : this.diskInfoList) {
            String diskStatus = diskInfo.getStatus();
            ProtectObjectStorageInfo protectObjectStorageInfo = new ProtectObjectStorageInfo();
            protectObjectStorageInfo.setResourceProviderSN(diskInfo.getDevSn());
            protectObjectStorageInfo.setResourceId(diskInfo.getResourceId());
            if (DiskProtectStatusEnum.UNPROTECTED.getStatus().equals(diskStatus)) {
                addedStorageInfoSet.add(protectObjectStorageInfo);
                continue;
            }
            if (!DiskProtectStatusEnum.REMOVED.getStatus().equals(diskStatus)) continue;
            deletedStorageInfoSet.add(protectObjectStorageInfo);
        }
        if (this.isReProtectProcess(protectGroup)) {
            logger.info((Object)"This is a reprotect processor. PG=%s", new Object[]{protectGroup.getName()});
            addedStorageInfoSet = Collections.emptySet();
            deletedStorageInfoSet = Collections.emptySet();
        }
        if (!addedStorageInfoSet.isEmpty()) {
            for (Map.Entry entry : deviceStorageMap.entrySet()) {
                for (ProtectObjectStorageInfo protectObjectStorageInfo : addedStorageInfoSet) {
                    String[] entryKey = ((String)entry.getKey()).split("@");
                    if (!entryKey[1].equals(protectObjectStorageInfo.getResourceProviderSN()) || !((List)entry.getValue()).contains(protectObjectStorageInfo.getResourceId())) continue;
                    String errorMsg = "Delete replication pairs failed, pair info is: + " + protectObjectStorageInfo.getDeviceName();
                    logger.error((Object)errorMsg, 90160758787071L);
                    throw new LegoCheckedException(1073947693L, new String[]{entryKey[0]});
                }
            }
            this.createReplicationGroup(protectGroup);
        }
        if (VerifyUtil.isEmpty((String)(recoveryPlanStatus = (String)protectGroup.getProps().get("last_recovery_plan_execute_type")))) {
            recoveryPlanStatus = String.valueOf(DrmEnumDefine.RECOVERY_PLAN_STATUS_E.READY.getValue());
        }
        if (!deletedStorageInfoSet.isEmpty()) {
            this.deleteReplicationPair(deletedStorageInfoSet, NumberUtil.convertToInteger((Object)recoveryPlanStatus));
        }
        List list = protectGroup.distinctStorageInfo();
        return this.getReplicationGroup(list);
    }

    private List<ReplicationGroup> getReplicationGroup(Collection<ProtectObjectStorageInfo> storageInfoCollection) {
        Stack<List<ReplicationPair>> allFinalPairStack = this.retrieveAllReplicationPair(storageInfoCollection);
        HashMap<String, List<ReplicationPair>> pairMap = new HashMap<String, List<ReplicationPair>>();
        while (!allFinalPairStack.isEmpty()) {
            List<ReplicationPair> oneList = allFinalPairStack.pop();
            Map<String, List<ReplicationPair>> consPairMap = this.groupReplicationPair(oneList);
            for (Map.Entry<String, List<ReplicationPair>> entry : consPairMap.entrySet()) {
                String consistentGroupId = entry.getKey();
                List<ReplicationPair> pairList = entry.getValue();
                if (pairMap.containsKey(consistentGroupId)) {
                    ((List)pairMap.get(consistentGroupId)).addAll(pairList);
                    continue;
                }
                pairMap.put(consistentGroupId, pairList);
            }
        }
        ArrayList<ReplicationGroup> results = new ArrayList<ReplicationGroup>();
        for (Map.Entry entry : pairMap.entrySet()) {
            String tgtDevSN;
            if (null == entry) continue;
            String consistentGroupId = (String)entry.getKey();
            List pairList = (List)entry.getValue();
            ReplicationPair anyPair = (ReplicationPair)pairList.iterator().next();
            String srcDevSN = anyPair.getSrcDevSN();
            ReplicationGroup group = this.getReplicationGroup(srcDevSN, tgtDevSN = anyPair.getTgtDevSN(), consistentGroupId);
            if (group == null) {
                logger.error((Object)"create replication group failed");
                throw new LegoCheckedException(-1L);
            }
            group.setReplicationPairs(pairList);
            results.add(group);
        }
        return results;
    }

    private ReplicationGroup getReplicationGroup(String srcDevSN, String tgtDevSN, String groupId) {
        StorageReplicationManagerProxy sraProxy = StorageReplicationManagerProxy.getInstance();
        ReplicationGroup group = sraProxy.getReplicationGroup(srcDevSN, groupId);
        return group;
    }

    private void deleteReplicationPair(Collection<ProtectObjectStorageInfo> deletedStorageInfoSet, Integer recoveryPlanStatus) {
        Stack<List<ReplicationPair>> allDeletedPairStack = this.retrieveAllReplicationPair(deletedStorageInfoSet);
        while (!allDeletedPairStack.isEmpty()) {
            ReplicationPairRollbackItem rb;
            boolean result;
            boolean pairInConsistentGroup;
            List<ReplicationPair> pairList = allDeletedPairStack.pop();
            Map<String, List<ReplicationPair>> pairMap = this.groupReplicationPair(pairList);
            boolean bl = pairInConsistentGroup = !pairMap.isEmpty();
            if (pairInConsistentGroup) {
                StorageReplicationManagerProxy sraProxy = StorageReplicationManagerProxy.getInstance();
                for (Map.Entry<String, List<ReplicationPair>> entry : pairMap.entrySet()) {
                    if (null == entry) continue;
                    String cgId = entry.getKey();
                    List<ReplicationPair> onePairList = entry.getValue();
                    ReplicationPair tmpPair = onePairList.iterator().next();
                    String string = tmpPair.getSrcDevSN();
                    String tgtDevSN = tmpPair.getTgtDevSN();
                    sraProxy.splitReplication(string, tgtDevSN, cgId, true);
                    ReplicationGroup group = new ReplicationGroup();
                    group.setSrcDevSN(string);
                    group.setTgtDevSN(tgtDevSN);
                    group.setReplicationId(cgId);
                    sraProxy.removeReplicationPair(group, onePairList);
                }
            }
            if (!(result = (rb = new ReplicationPairRollbackItem(pairList, recoveryPlanStatus)).execute())) {
                List pairInfo = pairList.stream().map(onePair -> onePair.getReplicationId() + "@" + onePair.getDevSn()).collect(Collectors.toList());
                String errorMsg = "Delete replication pairs failed, pair info is: + " + pairInfo.toString();
                logger.error((Object)errorMsg, 90160758787071L);
                List<Callable<Boolean>> resultTasks = rb.getTaskList();
                for (Callable callable : resultTasks) {
                    DeleteReplicationPairTask res = (DeleteReplicationPairTask)callable;
                    if (res.getException() == null) continue;
                    throw res.getException();
                }
                throw new LegoCheckedException(-1L);
            }
            if (!pairInConsistentGroup) continue;
            StorageReplicationManagerProxy sraProxy = StorageReplicationManagerProxy.getInstance();
            for (Map.Entry<String, List<ReplicationPair>> entry : pairMap.entrySet()) {
                if (null == entry) continue;
                String cgId = entry.getKey();
                List<ReplicationPair> list = entry.getValue();
                ReplicationPair tmpPair = list.iterator().next();
                String srcDevSN = tmpPair.getSrcDevSN();
                String tgtDevSN = tmpPair.getTgtDevSN();
                sraProxy.syncOnce(srcDevSN, tgtDevSN, cgId, true);
            }
        }
    }

    public void retrieveAllReplicationPair(Stack<List<ReplicationPair>> allPairStack, String srcDevSN, List<String> srcLunIdList, Integer resourceType) {
        List<List<ReplicationPair>> allPairList = this.getReplicationPair(srcDevSN, srcLunIdList, resourceType);
        if (null == allPairList || allPairList.isEmpty()) {
            return;
        }
        for (List<ReplicationPair> onePairList : allPairList) {
            allPairStack.push(onePairList);
            ArrayList<String> tgtLunIdList = new ArrayList<String>();
            String tgtDevSN = onePairList.iterator().next().getTgtDevSN();
            if (VerifyUtil.isEmpty((String)tgtDevSN)) {
                logger.error((Object)"tgtDevSN is null.");
                throw new LegoCheckedException(33561618L);
            }
            for (ReplicationPair onePair : onePairList) {
                tgtLunIdList.add(onePair.getTgtLunId());
            }
            this.retrieveAllReplicationPair(allPairStack, tgtDevSN, tgtLunIdList, resourceType);
        }
    }

    private List<List<ReplicationPair>> getReplicationPair(String srcDevSN, List<String> srcLunIdList, Integer resourceType) {
        ArrayList<List<ReplicationPair>> results = new ArrayList<List<ReplicationPair>>();
        for (String lunId : srcLunIdList) {
            StorageReplicationManagerProxy sraProxy = StorageReplicationManagerProxy.getInstance();
            List pairList = sraProxy.queryReplications(srcDevSN, lunId, resourceType);
            if ((pairList = pairList.stream().filter(ReplicationRelation::getIsPrimary).collect(Collectors.toList())).isEmpty()) continue;
            results.add(pairList);
        }
        return results;
    }

    private Stack<List<ReplicationPair>> retrieveAllReplicationPair(Collection<ProtectObjectStorageInfo> storageInfoSet) {
        if (VerifyUtil.isEmpty(storageInfoSet)) {
            return new Stack<List<ReplicationPair>>();
        }
        String srcDevSN = storageInfoSet.iterator().next().getResourceProviderSN();
        ArrayList<Callable<Lun>> taskList = new ArrayList<Callable<Lun>>();
        ArrayList<String> idList = new ArrayList<String>();
        for (ProtectObjectStorageInfo storageInfo : storageInfoSet) {
            String srcLunId = storageInfo.getResourceId();
            idList.add(srcLunId);
            taskList.add(this.createQueryLunTask(srcDevSN, srcLunId));
        }
        List results = ExecutionService.batchSubmit(taskList, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)180, (int)30);
        if (null != results && results.size() != storageInfoSet.size()) {
            List resultLunIdList = results.stream().map(lun -> lun.getLunId()).collect(Collectors.toList());
            String errorMsg = "Retrieve LUN by id {0} from storage device failed. result Lun Id {1}";
            errorMsg = MessageFormatUtil.format((String)errorMsg, (Object[])new Object[]{((Object)idList).toString(), resultLunIdList.toString()});
            logger.error((Object)errorMsg, 90160758787071L);
        }
        if (null == results) {
            logger.error((Object)"results is null");
            throw new LegoCheckedException(0x300001L);
        }
        List<String> lunIdList = results.stream().map(lun -> lun.getLunId()).collect(Collectors.toList());
        Stack<List<ReplicationPair>> allPairStack = new Stack<List<ReplicationPair>>();
        this.retrieveAllReplicationPair(allPairStack, srcDevSN, lunIdList, DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue());
        return allPairStack;
    }

    private Callable<Lun> createQueryLunTask(final String devSN, final String lunId) {
        Callable<Lun> queryLunTask = new Callable<Lun>(){

            @Override
            public Lun call() {
                StorageLunManagerProxy lunManagerProxy = StorageLunManagerProxy.getInstance();
                Lun lun = lunManagerProxy.getLunById(devSN, lunId);
                if (null == lun) {
                    throw new LegoCheckedException(1073947394L);
                }
                return lun;
            }
        };
        return queryLunTask;
    }

    private List<ReplicationGroup> createReplicationGroup(ProtectGroup protectGroup, List<ReplicationGroup> groupList, ReplicationPairConfiguration config) {
        ArrayList<ReplicationGroup> cmdGroupList = new ArrayList<ReplicationGroup>();
        for (ReplicationGroup tempGroup : groupList) {
            List tempPairList = tempGroup.getReplicationPairs();
            if (null == tempPairList || tempPairList.isEmpty()) continue;
            for (StoragePair storagePair : config.findStoragePair(tempGroup.getSrcDevSN())) {
                ArrayList<ReplicationPair> pairList = new ArrayList<ReplicationPair>();
                for (ReplicationPair tempPair : tempPairList) {
                    if (!tempPair.getSrcDevSN().equals(storagePair.getSrcDevSN())) continue;
                    ReplicationPair pair = (ReplicationPair)tempPair.clone();
                    ArrayList<ReplicationTargetLun> targetLunList = new ArrayList<ReplicationTargetLun>();
                    ReplicationTargetLun targetLun = new ReplicationTargetLun();
                    targetLunList.add(targetLun);
                    targetLun.setTgtDevSN(storagePair.getTgtDevSN());
                    pair.setRepTgtLuns(targetLunList);
                    pairList.add(pair);
                }
                ReplicationGroup group = new ReplicationGroup();
                group.setReplicationPairs(pairList);
                cmdGroupList.add(group);
            }
        }
        return this.batchCreateReplicationGroup(protectGroup, cmdGroupList, config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<ReplicationGroup> batchCreateReplicationGroup(ProtectGroup protectGroup, List<ReplicationGroup> groupList, ReplicationPairConfiguration config) {
        ArrayList<ReplicationGroup> results = new ArrayList<ReplicationGroup>();
        try {
            this.batchCreateReplicationGroupImp(groupList, config, results);
        }
        finally {
            try {
                HashSet allStorageResourceSet = new HashSet();
                protectGroup.getPolist().stream().forEach(po -> po.getUsedStorageResourceSet().stream().forEach(storageResource -> allStorageResourceSet.add(storageResource)));
                if (allStorageResourceSet.size() > 0) {
                    String devSn = ((ProtectObjectStorageInfo)allStorageResourceSet.stream().findFirst().get()).getResourceProviderSN();
                    ArrayList<String> lunIds = new ArrayList<String>();
                    ArrayList<String> nasIds = new ArrayList<String>();
                    for (ProtectObjectStorageInfo posi : allStorageResourceSet) {
                        if (DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue() == posi.getResourceType().intValue()) {
                            nasIds.add(posi.getResourceId());
                            continue;
                        }
                        lunIds.add(posi.getResourceId());
                    }
                    ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).queryReplicationPairsByMasterLunId(devSn, lunIds, true, Integer.valueOf(DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue()));
                    ((IStorageService)ServiceLocator.getInstance().getService(IStorageService.class)).queryReplicationPairsByMasterLunId(devSn, nasIds, true, Integer.valueOf(DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue()));
                }
            }
            catch (Exception e) {
                logger.error((Object)"something wrong during queryReplicationPairsByMasterLunId:", (Throwable)e);
            }
            if (!this.failed) {
                List<ReplicationGroup> cascadeGroupList = this.createCascadeReplicationGroup(protectGroup, results, config);
                if (null != cascadeGroupList && !cascadeGroupList.isEmpty()) {
                    results.addAll(cascadeGroupList);
                }
            } else if (!this.isReProtectProcess(protectGroup)) {
                this.rollback(protectGroup);
            }
        }
        return results;
    }

    private void batchCreateReplicationGroupImp(List<ReplicationGroup> groupList, ReplicationPairConfiguration config, List<ReplicationGroup> results) {
        HashMap diskStatusMap = new HashMap();
        if (!VerifyUtil.isEmpty(this.diskInfoList)) {
            this.diskInfoList.forEach(disk -> diskStatusMap.put(CommUtil.combineString((String[])new String[]{disk.getDevSn(), disk.getResourceId()}), disk.getStatus()));
        }
        long timeout = LegoConfig.getInstance().getNumber("fsb_create_pair_timeout", 200L);
        long count = LegoConfig.getInstance().getNumber("fsb_create_pair_count", 30L);
        logger.info((Object)"fsb create pair timeout: %s, count: %s", new Object[]{timeout, count});
        for (ReplicationGroup group : groupList) {
            ArrayList<CreateReplicationPairTask> taskList = new ArrayList<CreateReplicationPairTask>();
            for (ReplicationPair pair2 : group.getReplicationPairs()) {
                CreateReplicationPairTask task = new CreateReplicationPairTask(pair2, config);
                taskList.add(task);
            }
            List result = ExecutionService.batchSubmit(taskList, (ExecutionService.ExecuteType)ExecutionService.ExecuteType.FAILED_ABORT, (int)((int)timeout), (int)((int)count));
            List result1 = result.stream().filter(line -> line != null).collect(Collectors.toList());
            List<ReplicationPair> rollbackPairList = group.getReplicationPairs().stream().filter(pair -> {
                String diskStatus = (String)diskStatusMap.get(CommUtil.combineString((String[])new String[]{pair.getSrcDevSN(), pair.getSrcLunId()}));
                return DiskProtectStatusEnum.UNPROTECTED.getStatus().equals(diskStatus);
            }).collect(Collectors.toList());
            if (result1.size() == taskList.size()) {
                this.rollback.addItem(new ReplicationPairRollbackItem(rollbackPairList));
                ReplicationGroup createdGroup = this.createConsistentGroup(result);
                if (null == this.protectGroupInDb) {
                    this.rollback.addItem(new ReplicationGroupRollbackItem(createdGroup));
                }
                try {
                    this.addReplicationPairToCG(createdGroup, result);
                }
                catch (Exception e) {
                    logger.error((Object)"Error occurs in createConsistentGroup:", (Throwable)e);
                    this.failed = true;
                    throw e;
                }
                results.add(createdGroup);
                continue;
            }
            this.failed = true;
            String errorMsg = "Create Replication pair failed";
            logger.error((Object)errorMsg, 90160758787071L);
            this.rollback.addItem(new ReplicationPairRollbackItem(rollbackPairList));
            for (Callable callable : taskList) {
                CreateReplicationPairTask createReplicationPairTask = (CreateReplicationPairTask)callable;
                if (createReplicationPairTask.getException() == null) continue;
                logger.error((Object)("Create Replication pair failed. LUN ID is : " + createReplicationPairTask.getPair().getSrcLunId()));
                throw createReplicationPairTask.getException();
            }
            throw new LegoCheckedException(-1L);
        }
    }

    private ReplicationGroup createConsistentGroup(List<ReplicationPair> pairList) {
        ReplicationGroup group;
        Set cgIdSet = pairList.stream().filter(pair1 -> pair1.getConsistentGroupId() != null).map(pair -> pair.getConsistentGroupId()).collect(Collectors.toSet());
        if (cgIdSet.size() > 1) {
            logger.error((Object)"cgId size not one:%s", new Object[]{cgIdSet});
            throw new LegoCheckedException(-1L);
        }
        ReplicationPair pairWithGroup = pairList.stream().filter(pair1 -> pair1.getConsistentGroupId() != null).findAny().orElse(null);
        StorageReplicationManagerProxy sraProxy = StorageReplicationManagerProxy.getInstance();
        if (null != pairWithGroup) {
            String srcDevSN = pairWithGroup.getSrcDevSN();
            String tgtDevSN = pairWithGroup.getTgtDevSN();
            String consistentGroupId = pairWithGroup.getConsistentGroupId();
            sraProxy.splitReplication(srcDevSN, tgtDevSN, consistentGroupId, true);
            group = sraProxy.getReplicationGroup(srcDevSN, consistentGroupId);
        } else {
            ReplicationPair pair2 = (ReplicationPair)pairList.stream().findFirst().get();
            group = new ReplicationGroup();
            group.setReplicationName("RD_CG_" + System.currentTimeMillis());
            group.setName(group.getReplicationName());
            group.setSrcDevSN(pair2.getSrcDevSN());
            group.setReplicationMode(pair2.getReplicationMode());
            group.setTgtDevSN(pair2.getTgtDevSN());
            group.setIsPrimary(Boolean.valueOf(true));
            group = sraProxy.createReplicationGroup(group);
        }
        if (group == null) {
            logger.error((Object)"create replication group failed");
            throw new LegoCheckedException(-1L);
        }
        return group;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addReplicationPairToCG(ReplicationGroup group, List<ReplicationPair> pairList) {
        StorageReplicationManagerProxy sraProxy = StorageReplicationManagerProxy.getInstance();
        try {
            sraProxy.addReplicationPair(group, pairList);
        }
        finally {
            sraProxy.getStorageReplicationAdapter(group.getSrcDevSN()).syncOnce(group.getSrcDevSN(), group.getTgtDevSN(), group.getReplicationId(), true);
        }
    }

    private void rollback(ProtectGroup protectGroup) {
        logger.info((Object)"Create Replication failed, begin to rollback!");
        this.rollback.execute(protectGroup);
    }

    private List<ReplicationGroup> createCascadeReplicationGroup(ProtectGroup protectGroup, List<ReplicationGroup> groupList, ReplicationPairConfiguration config) {
        ArrayList<ReplicationGroup> cmdGroupList = new ArrayList<ReplicationGroup>();
        for (ReplicationGroup group : groupList) {
            List<StoragePair> storagePairs = config.findStoragePair(group.getTgtDevSN());
            if (null == storagePairs || storagePairs.isEmpty()) continue;
            StoragePair storagePair = storagePairs.get(0);
            ArrayList<ReplicationPair> cmdPairList = new ArrayList<ReplicationPair>();
            for (ReplicationPair pair : group.getReplicationPairs()) {
                ReplicationPair newPair = new ReplicationPair();
                newPair.setSrcDevSN(group.getTgtDevSN());
                newPair.setSrcLunId(pair.getTgtLunId());
                ArrayList<ReplicationTargetLun> targetLunList = new ArrayList<ReplicationTargetLun>();
                ReplicationTargetLun targetLun = new ReplicationTargetLun();
                targetLunList.add(targetLun);
                targetLun.setTgtDevSN(storagePair.getTgtDevSN());
                newPair.setRepTgtLuns(targetLunList);
                cmdPairList.add(newPair);
            }
            ReplicationGroup cmdGroup = new ReplicationGroup();
            cmdGroup.setSrcDevSN(group.getTgtDevSN());
            cmdGroup.setTgtDevSN(storagePair.getTgtDevSN());
            group.setReplicationPairs(cmdPairList);
            cmdGroupList.add(group);
        }
        if (!cmdGroupList.isEmpty()) {
            return this.batchCreateReplicationGroup(protectGroup, cmdGroupList, config);
        }
        return null;
    }

    private boolean isReProtectProcess(ProtectGroup protectGroup) {
        String recoveryPlanExecuteType = (String)protectGroup.getProps().get("FS_last_recovery_plan_execute_type");
        if (!VerifyUtil.isEmpty((String)recoveryPlanExecuteType)) {
            return String.valueOf(DrmEnumDefine.RECOVERY_PLAN_EXECUTE_TYPE_E.REPROTECT.getValue()).equals(recoveryPlanExecuteType);
        }
        return false;
    }
}

