/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.resource.service;

import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class ReprotectReplicationReverseService {
    private static final Log logger = LogFactory.getInstance(ReprotectReplicationReverseService.class);

    public OperationResult reverseReplication(String srcDeviceId, String targetDeviceId, String replicationId, boolean isConsistentGroup) {
        logger.info((Object)("Begin reverse replication, srcDevSn:" + srcDeviceId + ",tgtDevSn:" + targetDeviceId + ",RpId;" + replicationId + ",isCG:" + isConsistentGroup), 90160758784000L);
        StorageReplicationManagerProxy srmProxy = StorageReplicationManagerProxy.getInstance();
        OperationResult operationResult = srmProxy.reverseReplication(srcDeviceId, targetDeviceId, replicationId, isConsistentGroup);
        if (null == operationResult || !operationResult.isSuccess()) {
            return operationResult;
        }
        operationResult = this.setSecondaryLunWriteProtection(srcDeviceId, targetDeviceId, replicationId, isConsistentGroup);
        logger.info((Object)("End reverse replication, srcDevSn:" + srcDeviceId + ",tgtDevSn:" + targetDeviceId + ",RpId;" + replicationId + ",isCG:" + isConsistentGroup), 90160758784000L);
        return operationResult;
    }

    public OperationResult setSecondaryLunWriteProtection(String srcDeviceId, String targetDeviceId, String replicationId, boolean isConsistentGroup) {
        StorageReplicationManagerProxy srmProxy = StorageReplicationManagerProxy.getInstance();
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", targetDeviceId);
        List storageUnits = CommonDAOLocator.getMoDao().findMoBy(StorageUnit.class, props);
        if (!VerifyUtil.isEmpty((Collection)storageUnits)) {
            OperationResult operationResult = srmProxy.setLunWriteProtection(targetDeviceId, replicationId, isConsistentGroup, 2);
            return operationResult;
        }
        OperationResult operationResult = srmProxy.setLunWriteProtection(srcDeviceId, replicationId, isConsistentGroup, 2);
        return operationResult;
    }
}

