/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.topology;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.SiteUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.rest.client.RestClient;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.site.sdk.service.ISiteService;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.drm.storage.topology.ArrayReplicationTopoBuilder;
import com.huawei.ism.drm.storage.topology.ArrayTopoBuilder;
import com.huawei.ism.drm.storage.topology.HyperMetroLunLinkSkin;
import com.huawei.ism.drm.topo.element.LunElement;
import com.huawei.ism.drm.topo.element.NasFileSystemElement;
import com.huawei.ism.drm.topo.element.StorageElement;
import com.huawei.ism.drm.topo.sdk.context.TopoContext;
import com.huawei.ism.drm.topo.sdk.twaver.Skin;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.ism.unistor.sdk.model.VstoreHyperMetroPair;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import twaver.IData;
import twaver.Node;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:PolicyTemplate-20##PolicyTemplate-24##PolicyTemplate-32")
public class ArrayReplicationHyperMetroTopoBuilder
extends ArrayTopoBuilder {
    @Override
    public void buildTopo(TopoContext context) {
        ArrayReplicationTopoBuilder replicationBuilder = new ArrayReplicationTopoBuilder();
        replicationBuilder.buildTopo(context);
        Object obj = context.find((Object)"lunNodeToTrgLun");
        if (null == obj) {
            logger.error((Object)("the lunNodeToTrgLun is null, pgName: " + context.getProtectGroup().getName()));
            return;
        }
        Map lunNodeToTrgLun = (Map)obj;
        ProtectGroup pg = context.getProtectGroup();
        if (this.getStorageResourceType(pg) == DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue()) {
            this.buildNasHyperMetroTopo(context, lunNodeToTrgLun);
        } else {
            this.buildLunHyperMetroTopo(context, lunNodeToTrgLun);
        }
        this.hidenArrayReplicationSite(context);
    }

    private void buildNasHyperMetroTopo(TopoContext context, Map<Node, StorageResource> lunNodeToTrgLun) {
        ProtectGroup pg = context.getProtectGroup();
        String targetDevSn = "";
        ArrayList<String> resourceIds = new ArrayList<String>();
        for (Map.Entry<Node, StorageResource> entry : lunNodeToTrgLun.entrySet()) {
            StorageResource resource = entry.getValue();
            resourceIds.add(resource.getResourceId());
            targetDevSn = resource.getDevSn();
        }
        List pairList = this.getHyperMetroPairList(targetDevSn, resourceIds);
        HashSet<String> remoteResourceIds = new HashSet<String>();
        for (HyperMetroPair pair : pairList) {
            remoteResourceIds.add(pair.getRemoteObjId());
        }
        StorageResourceServiceRouter router = StorageResourceServiceRouter.getInstance();
        VstoreHyperMetroPair vstoreHyperMetroPair = router.getVstoreHyperMetroPairByVstorePairId(targetDevSn, (String)pg.getProps().get("PROP_KEY_VSTORE_PAIR_ID"));
        String remoteDevSN = this.getRemoteDevSn(vstoreHyperMetroPair, targetDevSn);
        if (remoteDevSN == null) {
            logger.error((Object)"can not getRemoteDevSn");
            return;
        }
        List remoteList = router.getStorageResourcesByIds(remoteDevSN, new ArrayList(remoteResourceIds), NasFileSystem.class);
        this.addNasNode(context, lunNodeToTrgLun, pairList, remoteList, targetDevSn, remoteDevSN);
    }

    private void buildLunHyperMetroTopo(TopoContext context, Map<Node, StorageResource> lunNodeToTrgLun) {
        HashSet<String> wwnSet = new HashSet<String>();
        String targetDevSn = "";
        for (Map.Entry<Node, StorageResource> entry : lunNodeToTrgLun.entrySet()) {
            if (!(entry.getValue() instanceof Lun)) continue;
            Lun lun = (Lun)entry.getValue();
            wwnSet.add(lun.getWwn());
            targetDevSn = lun.getDevSn();
        }
        DrStorage trgDrStorage = (DrStorage)this.getDrResource(targetDevSn);
        List lunList = null;
        String targetArraySiteId = trgDrStorage.getSiteId();
        Site targetArraySite = context.getSiteService().getSiteById(targetArraySiteId);
        lunList = 0 == targetArraySite.getSiteType() ? context.getStorageService().getStorageResourceByWwn(wwnSet.toArray(new String[wwnSet.size()])) : context.getStorageService().getResourceByWwnFromRemote(targetArraySite, new ArrayList(wwnSet));
        if (VerifyUtil.isEmpty((Collection)lunList)) {
            return;
        }
        HashMap<String, Lun> hyperMetroTargetLunMap = new HashMap<String, Lun>();
        String hyperMetroTargetArraySn = "";
        for (StorageResource resource : lunList) {
            Lun lun;
            if (!(resource instanceof Lun) || (lun = (Lun)resource).getDevSn().equals(targetDevSn)) continue;
            hyperMetroTargetLunMap.put(lun.getWwn(), lun);
            hyperMetroTargetArraySn = lun.getDevSn();
        }
        DrStorage hyperMetrolTargetArray = (DrStorage)this.getDrResource(hyperMetroTargetArraySn);
        Site hyperMetroTargetSite = context.getSiteService().getSiteById(hyperMetrolTargetArray.getSiteId());
        context.getSiteMaps().put(hyperMetroTargetSite.getSiteId(), hyperMetroTargetSite);
        Node srcStorageNode = this.addStorageNode(context, hyperMetrolTargetArray, hyperMetroTargetSite);
        this.addHyperMetroTargetLun(context, lunNodeToTrgLun, hyperMetroTargetLunMap, hyperMetrolTargetArray, srcStorageNode);
    }

    private void hidenArrayReplicationSite(TopoContext context) {
        Map siteMap = context.getSiteMaps();
        for (Map.Entry entry : siteMap.entrySet()) {
            Node siteNode = (Node)context.getElementBox().getDataByID(entry.getKey());
            if (null == siteNode) continue;
            siteNode.setName("");
            siteNode.setStyle("vector.outline.color", (Object)"0xFAFAFA");
            siteNode.setStyle("vector.fill.color", (Object)"0xFAFAFA");
            siteNode.setStyle("vector.outline.alpha", 0.0);
            siteNode.setStyle("vector.fill", false);
        }
    }

    private void addHyperMetroTargetLun(TopoContext context, Map<Node, StorageResource> lunNodeToTrgLun, Map<String, Lun> hyperMetroTargetLunMap, DrStorage hyperMetroTargetArray, Node srcStorageNode) {
        Object objTargetLunList = context.find((Object)"tergetLunNodeList");
        if (null == objTargetLunList) {
            return;
        }
        String hyperMetroTargetArraySn = hyperMetroTargetArray.getDeviceSn();
        List targetLunList = (List)objTargetLunList;
        LunElement element = null;
        ArrayList<String> hyperMetroLunWwnList = new ArrayList<String>();
        for (String wwn : hyperMetroTargetLunMap.keySet()) {
            hyperMetroLunWwnList.add(wwn);
        }
        Map<String, HyperMetroPair> wwnToPair = this.getHyperMetroPairMapBy(context, hyperMetroLunWwnList, hyperMetroTargetArray);
        for (Node repTrgLunNode : targetLunList) {
            Lun targetLun = (Lun)lunNodeToTrgLun.get(repTrgLunNode);
            HyperMetroPair pair = null;
            if (null == targetLun) {
                element = new LunElement((Object)(hyperMetroTargetArraySn + repTrgLunNode.getID()), null);
            } else {
                Lun hyperMetralOtherLun = hyperMetroTargetLunMap.get(targetLun.getWwn());
                element = hyperMetralOtherLun != null ? new LunElement((Object)(hyperMetroTargetArraySn + hyperMetralOtherLun.getLunId()), hyperMetralOtherLun) : new LunElement((Object)(hyperMetroTargetArraySn + targetLun.getLunId()), targetLun, targetLun.getLunId());
                pair = wwnToPair.get(targetLun.getWwn());
            }
            if (repTrgLunNode.getID().equals(element.getID())) continue;
            LunElement existLun = (LunElement)context.addChild((IData)srcStorageNode, (IData)element);
            if (existLun != null) {
                element = existLun;
            }
            context.linkTo(repTrgLunNode, (Node)element, new Skin[]{new HyperMetroLunLinkSkin(pair)});
        }
    }

    private Map<String, HyperMetroPair> getHyperMetroPairMapBy(TopoContext context, List<String> hyperMetroLunWwnList, DrStorage hyperMetroTargetArray) {
        HashMap<String, HyperMetroPair> wwnToPair = new HashMap<String, HyperMetroPair>();
        Site site = (Site)context.getSiteMaps().get(hyperMetroTargetArray.getSiteId());
        if (null == site) {
            logger.error((Object)("The site is null: " + hyperMetroTargetArray.getSiteId()));
            return wwnToPair;
        }
        List hyperMetroPair = null;
        StringBuffer strResourceWwns = new StringBuffer();
        for (String wwn : hyperMetroLunWwnList) {
            strResourceWwns.append(wwn).append(';');
        }
        String srcResourceIdStr = strResourceWwns.toString();
        hyperMetroPair = 0 == site.getSiteType() ? context.getStorageResourceService().getHyperMetroPairByWwn(hyperMetroLunWwnList, null) : this.getHyperMetroPairByWwnFromRemote(site, srcResourceIdStr);
        if (VerifyUtil.isEmpty((Collection)hyperMetroPair)) {
            logger.error((Object)("he hyperMetroPair is null: " + srcResourceIdStr), 1L);
            return wwnToPair;
        }
        for (HyperMetroPair one : hyperMetroPair) {
            if (wwnToPair.containsKey(one.getResourceWwn())) continue;
            wwnToPair.put(one.getResourceWwn(), one);
        }
        return wwnToPair;
    }

    private List<HyperMetroPair> getHyperMetroPairByWwnFromRemote(Site srcSite, String srcResourceIdStr) {
        HashMap<String, Object> srcUriVariabels = new HashMap<String, Object>();
        srcUriVariabels.put("wwns", srcResourceIdStr.substring(0, srcResourceIdStr.length() - 1));
        srcUriVariabels.put("roleType", 3);
        srcUriVariabels.put("isRealTime", false);
        ArrayList<HyperMetroPair> pairList = new ArrayList<HyperMetroPair>();
        try {
            RestClient srcClient = SiteUtil.initClient((Site)srcSite);
            String reqUrl = "/ws/storages/hyperMetroPair?wwns={wwns}&roleType={roleType}&devSn={devSn}&isRealTime={isRealTime}";
            String sResults = srcClient.get(reqUrl, srcUriVariabels);
            JSONArray jsonArray = JSONArray.fromObject((Object)sResults);
            if (null != jsonArray && jsonArray.size() > 0) {
                this.buildHyperMetroPairInfo(pairList, jsonArray);
            }
        }
        catch (Exception e) {
            logger.error((Object)("getResourceFromRemote failed" + ExceptionUtil.getErrorMessage((Throwable)e)), 90160758786962L);
        }
        return pairList;
    }

    private void buildHyperMetroPairInfo(List<HyperMetroPair> pairList, JSONArray jsonArray) {
        Iterator it = jsonArray.iterator();
        while (it.hasNext()) {
            JSONObject jsonObject = JSONObject.fromObject(it.next());
            HyperMetroPair pair = new HyperMetroPair();
            pair.setResourceWwn(jsonObject.getString("resourceWwn"));
            pair.setRunningState(jsonObject.getString("runningState"));
            pair.setHealthState(jsonObject.getString("healthState"));
            pair.setDevSn(jsonObject.getString("devSn"));
            pairList.add(pair);
        }
    }

    private Node addStorageNode(TopoContext context, DrStorage drStorage, Site siteInfo) {
        Node root = context.getRootNode();
        String siteStyleNodeId = siteInfo.getSiteId() + "---" + "Style:unvisible";
        Node siteStyleNode = (Node)context.getElementBox().getDataByID((Object)siteStyleNodeId);
        if (siteStyleNode == null) {
            siteStyleNode = this.createUnVisibleStyleNode(context, siteInfo.getSiteId() + "---" + "Style");
            context.addChild((IData)root, (IData)siteStyleNode);
        }
        String snid = drStorage.getDeviceSn() + ":storage";
        Node storage = (Node)context.getElementBox().getDataByID((Object)snid);
        if (null == storage) {
            storage = (Node)context.addChild((IData)siteStyleNode, (IData)new StorageElement(drStorage));
        }
        return storage;
    }

    private Node createUnVisibleStyleNode(TopoContext context, String styleNodeId) {
        Node group = TopoServiceUtil.createUnVisibleStyleNode((TopoContext)context, (String)styleNodeId);
        group.setStyle("vector.outline.alpha", 0.0);
        group.setStyle("icons.position", (Object)"right.right");
        group.setClient("iconHeight", 48.0);
        group.setClient("iconWidth", 48.0);
        group.setClient("ISSNAPPO", (Object)"FALSE");
        return group;
    }

    private String getRemoteDevSn(VstoreHyperMetroPair vstoreHyperMetroPair, String localDevSn) {
        String remoteDevSN = null;
        List vstoreHyperMetroPairs = StorageResourceServiceRouter.getInstance().getVstoreHyperPair(this.getServerUUidBySn(localDevSn), vstoreHyperMetroPair);
        for (VstoreHyperMetroPair pair : vstoreHyperMetroPairs) {
            ManagedObject managedObject = pair.getParentMo();
            if (!(managedObject instanceof HvsUnit) || localDevSn.equals(((HvsUnit)managedObject).getDevSn())) continue;
            remoteDevSN = ((HvsUnit)managedObject).getDevSn();
            break;
        }
        return remoteDevSN;
    }

    private String getServerUUidBySn(String devSn) {
        Site site = ((ISiteService)ServiceLocator.getInstance().getService(ISiteService.class)).getSiteByDeviceSn(devSn);
        return site.getServerUuid();
    }

    private void addNasNode(TopoContext context, Map<Node, StorageResource> lunNodeToTrgLun, List<HyperMetroPair> pairList, List<NasFileSystem> remoteList, String localDevsn, String remoteDevSN) {
        HashMap<String, String> nasIdMap = new HashMap<String, String>();
        HashMap srcToRemoteMap = new HashMap();
        HashMap<String, String> pairIdMap = new HashMap<String, String>();
        HashMap<String, HyperMetroPair> pairMap = new HashMap<String, HyperMetroPair>();
        for (HyperMetroPair pair : pairList) {
            nasIdMap.put(remoteDevSN + ":" + pair.getRemoteObjId(), localDevsn + ":" + pair.getLocalObjId());
            pairIdMap.put(remoteDevSN + ":" + pair.getRemoteObjId(), pair.getId());
            pairIdMap.put(localDevsn + ":" + pair.getLocalObjId(), pair.getId());
            pairMap.put(pair.getId(), pair);
        }
        for (NasFileSystem remote : remoteList) {
            String key = remote.getDevSn() + ":" + remote.getResourceId();
            srcToRemoteMap.put(nasIdMap.get(key), remote);
        }
        for (Map.Entry<Node, StorageResource> entry : lunNodeToTrgLun.entrySet()) {
            NasFileSystemElement element;
            Node repTrgLunNode = entry.getKey();
            NasFileSystem salveHyperMetroNas = (NasFileSystem)entry.getValue();
            HyperMetroPair pair = null;
            if (null == salveHyperMetroNas) {
                element = new NasFileSystemElement((Object)(remoteDevSN + repTrgLunNode.getID()), null);
            } else {
                String srcNasKey = salveHyperMetroNas.getDevSn() + ":" + salveHyperMetroNas.getResourceId();
                NasFileSystem masterHyperMetroNas = (NasFileSystem)srcToRemoteMap.get(srcNasKey);
                if (masterHyperMetroNas != null) {
                    String remoteNaskey = masterHyperMetroNas.getDevSn() + ":" + masterHyperMetroNas.getResourceId();
                    element = new NasFileSystemElement((Object)(remoteDevSN + (String)pairIdMap.get(remoteNaskey)), masterHyperMetroNas);
                    pair = (HyperMetroPair)pairMap.get(pairIdMap.get(remoteNaskey));
                } else {
                    element = new NasFileSystemElement((Object)(remoteDevSN + (String)pairIdMap.get(srcNasKey)), salveHyperMetroNas);
                    pair = (HyperMetroPair)pairMap.get(pairIdMap.get(srcNasKey));
                }
            }
            DrResource drResource = this.getDrResource(remoteDevSN);
            if (null == drResource) {
                logger.error((Object)"getDrResource error!");
                return;
            }
            DrStorage hyperMetrolTargetArray = (DrStorage)drResource;
            Site hyperMetroTargetSite = context.getSiteService().getSiteById(hyperMetrolTargetArray.getSiteId());
            context.getSiteMaps().put(hyperMetroTargetSite.getSiteId(), hyperMetroTargetSite);
            Node srcStorageNode = this.addStorageNode(context, hyperMetrolTargetArray, hyperMetroTargetSite);
            context.addChild((IData)srcStorageNode, (IData)element);
            context.linkTo(repTrgLunNode, (Node)element, new Skin[]{new HyperMetroLunLinkSkin(pair)});
        }
    }
}

