/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.topology;

import com.huawei.ism.array.sdk.model.HyperMetroPair;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.base.sdk.model.StorageResource;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.protection.framework.engine.util.ProtectionJobUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.protection.template.sdk.model.PolicyTemplate;
import com.huawei.ism.drm.protection.template.sdk.model.SiteInfo;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.Site;
import com.huawei.ism.drm.storage.sdk.model.DrStorage;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.storage.sdk.model.ResourceTimeWindow;
import com.huawei.ism.drm.storage.service.router.StorageResourceServiceRouter;
import com.huawei.ism.drm.storage.topology.ArrayTopoBuilder;
import com.huawei.ism.drm.storage.topology.HyperMetroLunLinkSkin;
import com.huawei.ism.drm.storage.topology.ReplicaRelation;
import com.huawei.ism.drm.storage.topology.ReplicationLinkSkin;
import com.huawei.ism.drm.topo.element.LunElement;
import com.huawei.ism.drm.topo.element.NasFileSystemElement;
import com.huawei.ism.drm.topo.element.SiteElement;
import com.huawei.ism.drm.topo.element.StorageElement;
import com.huawei.ism.drm.topo.element.VPanelElement;
import com.huawei.ism.drm.topo.sdk.context.TopoContext;
import com.huawei.ism.drm.topo.sdk.twaver.Skin;
import com.huawei.ism.drm.topo.twaver.TopoElement;
import com.huawei.ism.drm.topo.utils.TooltipUtil;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.ism.unistor.sdk.model.NasFileSystem;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.JSONArray;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Sets;
import twaver.IData;
import twaver.Node;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:PolicyTemplate-0##PolicyTemplate-1##PolicyTemplate-4##PolicyTemplate-6##PolicyTemplate-30##PolicyTemplate-33##PolicyTemplate-35##PolicyTemplate-36##PolicyTemplate-38##PolicyTemplate-39##PolicyTemplate-40##PolicyTemplate-41##PolicyTemplate-42##PolicyTemplate-43##PolicyTemplate-44##PolicyTemplate-45")
public class ArrayReplicationTopoBuilder
extends ArrayTopoBuilder {
    public static final Log logger = LogFactory.getInstance(ArrayReplicationTopoBuilder.class);
    public static final int PARALLEL_AA_3DC = 5;
    public static final int PARALLEL_AS_3DC = 6;
    protected static final String WRAP_NODE_ID_1 = "Replication-Data-Center-Group-1";
    protected static final String WRAP_NODE_ID_2 = "Replication-Data-Center-Group-2";
    private static final Set<Integer> NO_VPANEL_PO_TYPE = new HashSet<Integer>(Arrays.asList(11, 14));

    @Override
    public void buildTopo(TopoContext context) {
        this.checkRootNode(context);
        ProtectGroup pg = context.getProtectGroup();
        Set pgReplicas = pg.getReplicaList();
        this.sortRelation(pg);
        List<ReplicaRelation> relations = this.transform(pg, pgReplicas);
        boolean parallel = this.isParallel(context.getProtectGroup());
        StringBuilder lunIdList = new StringBuilder();
        Map<String, String> wrapMap = this.initWrapMap(pg);
        if (pg.getTemplate().getType() == 44 || pg.getTemplate().getType() == 45) {
            this.handleAirGapRelation(relations, wrapMap, context, parallel, lunIdList);
        } else {
            this.dealWithReplicaRelation(relations, wrapMap, context, parallel, lunIdList);
        }
        context.setLinkIdList(lunIdList.toString());
        if (PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(pg.getTemplate().getType())) {
            this.sortNode(context);
        }
    }

    private void handleAirGapRelation(List<ReplicaRelation> relations, Map<String, String> wrapMap, TopoContext context, boolean parallel, StringBuilder lunIdList) {
        ProtectGroup pg = context.getProtectGroup();
        Set schedules = pg.getTemplate().getSchedules();
        for (ReplicaRelation relation : relations) {
            String srcSN = relation.getSourceSN();
            String tgtSN = relation.getTargetSN();
            DrStorage tgtDrStorage = (DrStorage)this.getDrResource(tgtSN);
            if (VerifyUtil.isEmpty((Object)tgtDrStorage)) continue;
            Site trgSite = this.setSite(context, relation.getRecoverySite());
            Node srcStorageNode = this.addAirGapSrcNode(context, relation, srcSN, tgtSN);
            this.setWrapMap(wrapMap, parallel, trgSite);
            Node tgtStorageNode = this.addSiteNode(context, tgtDrStorage, trgSite, wrapMap);
            List<String> srResourceIdList = relation.getSourceLuns();
            List sources = this.getResourceListFromDB(srcSN, srResourceIdList);
            List tgtLuns = this.getResourceListFromDB(trgSite, tgtSN, relation.getTargetLuns());
            List targets = this.getTrgLunListFromDB(tgtSN, tgtSN, relation.getTargetLuns());
            Schedule schedule = TopoServiceUtil.getSchedule((int)relation.getProtectLocation(), (Set)schedules, (ProtectGroup)pg);
            String scheduleInfo = TooltipUtil.getScheduleInfo((Schedule)schedule);
            Map<String, StorageResource> srcResourceIDMap = this.getResourceIDMap(sources);
            Map<String, StorageResource> tgtResourceIDMap = this.getResourceIDMap(tgtLuns);
            Map<String, ReplicationTargetLun> repLunIDMap = this.getReplicationLunIDMap(targets);
            HashMap<String, ReplicationRelation> consistencyIdToGroup = new HashMap<String, ReplicationRelation>();
            for (String srcResourceId : srResourceIdList) {
                StorageResource srcResource = this.getStorageResource(relation, srcResourceIDMap, srcResourceId);
                TopoElement srcNode = this.createTopoElementByResource(srcSN, srcResourceId, srcResource, srcResource, pg);
                String targetResourceId = relation.getTargetLunBySource(srcResourceId);
                if (VerifyUtil.isEmpty((String)targetResourceId)) continue;
                StorageResource targetResource = tgtResourceIDMap.get(this.getAirGapResourceId(targetResourceId, pg));
                TopoElement targetNode = this.createTopoElementByResource(tgtSN, targetResourceId, targetResource, srcResource, pg);
                srcNode = (Node)context.addChild((IData)srcStorageNode, (IData)srcNode);
                targetNode = (Node)context.addChild((IData)tgtStorageNode, (IData)targetNode);
                ReplicationTargetLun repLunInfo = repLunIDMap.get(targetResourceId);
                String linkId = srcSN + ":" + srcResourceId + ":" + tgtSN + ":" + targetResourceId;
                Optional<ReplicationRelation> opt = this.getRepGroupByTarget(repLunInfo, relation, consistencyIdToGroup, targetResourceId);
                ReplicationRelation replicationRelation = opt.orElse(null);
                this.addLinkIdInfo(lunIdList, repLunInfo, linkId);
                context.linkTos((Node)srcNode, (Node)targetNode, linkId, new Skin[]{new ReplicationLinkSkin(replicationRelation, this.getDeviceType(srcSN), repLunInfo, scheduleInfo)});
            }
        }
    }

    private TopoElement createTopoElementByResource(String deviceSn, String id, StorageResource resource, StorageResource bakResource, ProtectGroup protectGroup) {
        if (VerifyUtil.isEmpty((Object)resource)) {
            if (bakResource instanceof Lun) {
                return new LunElement((Object)(deviceSn + id), (Lun)bakResource, id);
            }
            if (bakResource instanceof NasFileSystem) {
                return new NasFileSystemElement((Object)(deviceSn + id), (NasFileSystem)bakResource, id);
            }
            return this.createDefaultTopoElement(deviceSn + id, protectGroup);
        }
        if (resource instanceof Lun) {
            return new LunElement((Object)(deviceSn + id), (Lun)resource);
        }
        if (resource instanceof NasFileSystem) {
            return new NasFileSystemElement((Object)(deviceSn + id), (NasFileSystem)resource);
        }
        return this.createDefaultTopoElement(deviceSn + id, protectGroup);
    }

    private TopoElement createDefaultTopoElement(String id, ProtectGroup protectGroup) {
        int type = Optional.ofNullable(protectGroup).map(ProtectGroup::getTemplate).map(PolicyTemplate::getType).orElse(-1);
        if (type == 45) {
            return new NasFileSystemElement((Object)id, null);
        }
        if (type == 44) {
            return new LunElement((Object)id, null);
        }
        return new TopoElement();
    }

    private String getAirGapResourceId(String id, ProtectGroup protectGroup) {
        int type = Optional.ofNullable(protectGroup).map(ProtectGroup::getTemplate).map(PolicyTemplate::getType).orElse(-1);
        if (type == 45) {
            return DrmEnumDefine.RESOURCE_TYPE_E.NAS.name() + id;
        }
        if (type == 44) {
            return DrmEnumDefine.RESOURCE_TYPE_E.LUN.name() + id;
        }
        return id;
    }

    private String getDeviceType(String srcSN) {
        return ((IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class)).getStorageType(srcSN);
    }

    private StorageResource getStorageResource(ReplicaRelation relation, Map<String, StorageResource> srcResourceIDMap, String srcResourceId) {
        StorageResource source = null;
        int resType = relation.getStorageTypeBySource(srcResourceId);
        if (resType == DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue()) {
            source = srcResourceIDMap.get(DrmEnumDefine.RESOURCE_TYPE_E.LUN.name() + srcResourceId);
        }
        if (resType == DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue()) {
            source = srcResourceIDMap.get(DrmEnumDefine.RESOURCE_TYPE_E.NAS.name() + srcResourceId);
        }
        return this.buildStorageRes(relation, srcResourceId, source);
    }

    private void dealWithReplicaRelation(List<ReplicaRelation> relations, Map<String, String> wrapMap, TopoContext context, boolean parallel, StringBuilder lunIdList) {
        HashSet<String> buildWwnSet = new HashSet<String>();
        ProtectGroup pg = context.getProtectGroup();
        Set schedules = pg.getTemplate().getSchedules();
        LinkedList<Node> tergetLunNodeList = new LinkedList<Node>();
        HashMap<Node, StorageResource> lunNodeToTrgLun = new HashMap<Node, StorageResource>();
        for (ReplicaRelation relation : relations) {
            DrStorage trgDrStorage;
            String srcSN = relation.getSourceSN();
            String trgSN = relation.getTargetSN();
            DrStorage drStorage = (DrStorage)this.getDrResource(srcSN);
            if (this.checkDrStorage(drStorage, trgDrStorage = (DrStorage)this.getDrResource(trgSN))) continue;
            Site srcSite = this.setSite(context, drStorage.getSiteId());
            Site trgSite = this.setSite(context, relation.getRecoverySite());
            Node srcStorageNode = this.addSiteNode(context, drStorage, srcSite, wrapMap);
            this.setWrapMap(wrapMap, parallel, trgSite);
            Node trgStorageNode = this.addSiteNode(context, trgDrStorage, trgSite, wrapMap);
            List<String> srResourceIdList = relation.getSourceLuns();
            List sources = this.getResourceListFromDB(srcSite, srcSN, srResourceIdList);
            List trgLuns = this.getResourceListFromDB(trgSite, trgSN, relation.getTargetLuns());
            List<ReplicationTargetLun> targets = this.getTrgLunListFromDB(srcSite, srcSN, trgSN, relation.getTargetLuns());
            String deviceType = ((IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class)).getStorageType(srcSN);
            Map<String, StorageResource> srcResourceIDMap = this.getResourceIDMap(sources);
            Map<String, StorageResource> trgResourceIDMap = this.getResourceIDMap(trgLuns);
            Map<String, ReplicationTargetLun> repLunIDMap = this.getReplicationLunIDMap(targets);
            Schedule schedule = TopoServiceUtil.getSchedule((int)relation.getProtectLocation(), (Set)schedules, (ProtectGroup)pg);
            String scheduleInfo = TooltipUtil.getScheduleInfo((Schedule)schedule);
            ArrayList<NasFileSystem> nasFileSystemList = new ArrayList<NasFileSystem>();
            HashMap<Node, StorageResource> lunNodeToSrcLun = new HashMap<Node, StorageResource>();
            HashMap<Node, StorageResource> currentLunNodeToTrgLun = new HashMap<Node, StorageResource>();
            HashMap<String, ReplicationRelation> coninstanceIdToGroup = new HashMap<String, ReplicationRelation>();
            for (String srcResourceId : srResourceIdList) {
                StorageResource source = null;
                int resType = relation.getStorageTypeBySource(srcResourceId);
                if (resType == DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue()) {
                    source = srcResourceIDMap.get(DrmEnumDefine.RESOURCE_TYPE_E.LUN.name() + srcResourceId);
                } else if (resType == DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue()) {
                    source = srcResourceIDMap.get(DrmEnumDefine.RESOURCE_TYPE_E.NAS.name() + srcResourceId);
                }
                source = this.buildStorageRes(relation, srcResourceId, source);
                if (this.checkSource(nasFileSystemList, source)) continue;
                LunElement srcLunNode = new LunElement((Object)(srcSN + srcResourceId), (Lun)source);
                String trgLunID = relation.getTargetLunBySource(srcResourceId);
                if (trgLunID == null) continue;
                Lun trgLun = (Lun)trgResourceIDMap.get(DrmEnumDefine.RESOURCE_TYPE_E.LUN.name() + trgLunID);
                LunElement trgLunNode = trgLun != null ? new LunElement((Object)(trgSN + trgLunID), trgLun) : new LunElement((Object)(trgSN + trgLunID), (Lun)source, trgLunID);
                srcLunNode = (Node)context.addChild((IData)srcStorageNode, (IData)srcLunNode);
                trgLunNode = (Node)context.addChild((IData)trgStorageNode, (IData)trgLunNode);
                ReplicationTargetLun repLunInfo = repLunIDMap.get(trgLunID);
                String linkId = srcSN + ":" + srcResourceId + ":" + trgSN + ":" + trgLunID;
                ReplicationRelation repliationRelation = this.getReplicationGroup(repLunInfo, relation, coninstanceIdToGroup, srcSite, trgLunID);
                this.addLinkIdInfo(lunIdList, repLunInfo, linkId);
                context.linkTos((Node)srcLunNode, (Node)trgLunNode, linkId, new Skin[]{new ReplicationLinkSkin(repliationRelation, deviceType, repLunInfo, scheduleInfo)});
                if (!this.isReplicationHyperMetroMode(pg.getTemplate().getType())) continue;
                lunNodeToTrgLun.put((Node)trgLunNode, (StorageResource)trgLun);
                currentLunNodeToTrgLun.put((Node)trgLunNode, (StorageResource)trgLun);
                tergetLunNodeList.add((Node)trgLunNode);
                lunNodeToSrcLun.put((Node)srcLunNode, source);
            }
            this.contextBind(context, tergetLunNodeList, lunNodeToTrgLun);
            for (NasFileSystem srcFileSystem : nasFileSystemList) {
                String srcFileSystemId = srcFileSystem.getResourceId();
                NasFileSystemElement srcNasNode = new NasFileSystemElement((Object)(srcSN + srcFileSystemId), srcFileSystem);
                srcNasNode = (Node)context.addChild((IData)srcStorageNode, (IData)srcNasNode);
                String trgNasID = relation.getTargetLunBySource(srcFileSystemId);
                if (trgNasID == null) continue;
                NasFileSystem trgLun = (NasFileSystem)trgResourceIDMap.get(DrmEnumDefine.RESOURCE_TYPE_E.NAS.name() + trgNasID);
                NasFileSystemElement trgNasNode = trgLun != null ? new NasFileSystemElement((Object)(trgSN + trgNasID), trgLun) : new NasFileSystemElement((Object)(trgSN + trgNasID), srcFileSystem, trgNasID);
                trgNasNode = (Node)context.addChild((IData)trgStorageNode, (IData)trgNasNode);
                ReplicationTargetLun repLunInfo = repLunIDMap.get(trgNasID);
                String linkId = srcSN + ":" + srcFileSystemId + ":" + trgSN + ":" + trgNasID;
                this.addLinkIdInfo(lunIdList, repLunInfo, linkId);
                context.linkTos((Node)srcNasNode, (Node)trgNasNode, linkId, new Skin[]{new ReplicationLinkSkin(deviceType, repLunInfo, scheduleInfo)});
                this.setHyperMetroLunNode(pg, lunNodeToTrgLun, currentLunNodeToTrgLun, trgLun, (Node)trgNasNode);
            }
            this.buildNodeFor4DC(context, buildWwnSet, lunNodeToSrcLun, currentLunNodeToTrgLun, wrapMap);
        }
    }

    private void setWrapMap(Map<String, String> wrapMap, boolean parallel, Site trgSite) {
        if (parallel && !wrapMap.containsKey(trgSite.getSiteId())) {
            wrapMap.put(trgSite.getSiteId(), WRAP_NODE_ID_1);
        }
    }

    private void contextBind(TopoContext context, List<Node> tergetLunNodeList, Map<Node, StorageResource> lunNodeToTrgLun) {
        context.bind((Object)"lunNodeToTrgLun", lunNodeToTrgLun);
        context.bind((Object)"tergetLunNodeList", tergetLunNodeList);
    }

    private void setHyperMetroLunNode(ProtectGroup pg, Map<Node, StorageResource> lunNodeToTrgLun, Map<Node, StorageResource> currentLunNodeToTrgLun, NasFileSystem trgLun, Node trgNasNode) {
        if (20 == pg.getTemplate().getType() || 24 == pg.getTemplate().getType()) {
            lunNodeToTrgLun.put(trgNasNode, (StorageResource)trgLun);
            currentLunNodeToTrgLun.put(trgNasNode, (StorageResource)trgLun);
        }
    }

    private Site setSite(TopoContext context, String siteId) {
        String srcSiteId = siteId;
        Site srcSite = context.getSiteService().getSiteById(srcSiteId);
        context.getSiteMaps().put(srcSiteId, srcSite);
        return srcSite;
    }

    private void buildNodeFor4DC(TopoContext context, Set<String> buildWwnSet, Map<Node, StorageResource> lunNodeToSrcLun, Map<Node, StorageResource> currentLunNodeToTrgLun, Map<String, String> wrapMap) {
        ProtectGroup pg = context.getProtectGroup();
        if (PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(pg.getTemplate().getType())) {
            this.buildHyperNodeFor4DC(buildWwnSet, context, lunNodeToSrcLun, wrapMap);
            this.buildHyperNodeFor4DC(buildWwnSet, context, currentLunNodeToTrgLun, wrapMap);
        }
    }

    protected boolean isReplicationHyperMetroMode(int templateType) {
        return Arrays.asList(20, 24, 27, 32, 35, 36, 38, 39, 40, 41, 42, 43).contains(templateType);
    }

    private void sortRelation(ProtectGroup pg) {
        Set pgReplicas = pg.getReplicaList();
        if (35 != pg.getTemplate().getType() && 36 != pg.getTemplate().getType()) {
            return;
        }
        this.sortRelation(pgReplicas);
    }

    protected void sortRelation(Set<ProtectGroupReplica> pgReplicas) {
        pgReplicas.stream().forEach(pgRep -> {
            List sortedPoRelicas = pgRep.getReplicas().stream().sorted((poRep1, poRep2) -> poRep1.getPoId().compareTo(poRep2.getPoId())).collect(Collectors.toList());
            sortedPoRelicas.stream().forEach(poRep -> {
                List sortedInfos = poRep.getStorageInfos().stream().sorted((storage1, storage2) -> storage1.getProtectObjectStorageWwn().compareTo(storage2.getProtectObjectStorageWwn())).collect(Collectors.toList());
                poRep.setStorageInfos(new LinkedHashSet(sortedInfos));
            });
            pgRep.setReplicas(new LinkedHashSet(sortedPoRelicas));
        });
    }

    private StorageResource buildStorageRes(ReplicaRelation relation, String srcResourceId, StorageResource source) {
        if (VerifyUtil.isEmpty((Object)source)) {
            int storageType = relation.getStorageTypeBySource(srcResourceId);
            if (storageType == DrmEnumDefine.RESOURCE_TYPE_E.NAS.getValue()) {
                source = new NasFileSystem();
            } else if (storageType == DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue()) {
                source = new Lun();
            } else {
                return null;
            }
            source.setResourceId(srcResourceId);
            source.setName("--");
            source.setStatus(Integer.valueOf(-2));
            source.setHealthStatus("-1");
        }
        return source;
    }

    private void addLinkIdInfo(StringBuilder lunIdList, ReplicationTargetLun repLunInfo, String linkId) {
        if (null != repLunInfo) {
            int modeNasRep = TopoServiceUtil.getArrayReplicationMode((ReplicationTargetLun)repLunInfo);
            if (modeNasRep == 2) {
                lunIdList.append(linkId);
                lunIdList.append(";");
            }
        } else {
            logger.error((Object)("The repLunInfo is null: " + linkId));
        }
    }

    private boolean checkDrStorage(DrStorage drStorage, DrStorage trgDrStorage) {
        return drStorage == null || trgDrStorage == null;
    }

    private void checkRootNode(TopoContext context) {
        if (null == context) {
            logger.error((Object)"context is null", 1073947393L);
            throw new LegoCheckedException(1073947393L);
        }
        if (context.getRootNode() == null) {
            this.initialize(context);
        }
    }

    protected Map<String, String> initWrapMap(ProtectGroup pg) {
        String siteInfoListStr;
        HashMap<String, String> wrapMap = new HashMap<String, String>();
        if (PolicyTemplateType.REP_4DC_POLICYTEMPLATE.contains(pg.getTemplate().getType()) && !NO_VPANEL_PO_TYPE.contains(pg.getPoType()) && ProtectionJobUtil.isHyperMetroInFirstSite((ProtectGroup)pg) && null != (siteInfoListStr = (String)pg.getProps().get("PROP_KEY_SITE_INFO"))) {
            List siteInfoList = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)siteInfoListStr), SiteInfo.class);
            ((SiteInfo)siteInfoList.stream().findFirst().get()).getSiteIdSet().forEach(siteId -> wrapMap.put((String)siteId, WRAP_NODE_ID_1));
            if (36 == pg.getTemplate().getType()) {
                siteInfoList.stream().forEach(siteInfo -> siteInfo.getSiteIdSet().forEach(siteId -> {
                    if (!wrapMap.containsKey(siteId)) {
                        wrapMap.put((String)siteId, WRAP_NODE_ID_2);
                    }
                }));
            }
        }
        return wrapMap;
    }

    private void buildHyperNodeFor4DC(Set<String> buildWwnSet, TopoContext context, Map<Node, StorageResource> nodeToLunMap, Map<String, String> wrapMap) {
        if (VerifyUtil.isEmpty(nodeToLunMap) || VerifyUtil.isEmpty(nodeToLunMap.values())) {
            return;
        }
        HashSet<String> wwnSet = new HashSet<String>();
        String targetDevSn = "";
        for (Map.Entry<Node, StorageResource> entry : nodeToLunMap.entrySet()) {
            Lun lun;
            if (!(entry.getValue() instanceof Lun) || buildWwnSet.contains((lun = (Lun)entry.getValue()).getWwn())) continue;
            wwnSet.add(lun.getWwn());
            targetDevSn = lun.getDevSn();
        }
        if (VerifyUtil.isEmpty(wwnSet)) {
            return;
        }
        buildWwnSet.addAll(wwnSet);
        DrStorage hyperDrStorage = (DrStorage)this.getDrResource(targetDevSn);
        String hyperArraySiteId = hyperDrStorage.getSiteId();
        Site hyperArraySite = context.getSiteService().getSiteById(hyperArraySiteId);
        List lunList = 0 == hyperArraySite.getSiteType() ? context.getStorageService().getStorageResourceByWwn(wwnSet.toArray(new String[wwnSet.size()])) : context.getStorageService().getResourceByWwnFromRemote(hyperArraySite, new ArrayList(wwnSet));
        if (VerifyUtil.isEmpty((Collection)lunList)) {
            return;
        }
        String devSn = nodeToLunMap.values().stream().findFirst().get().getDevSn();
        HashMap<String, Lun> hyperMetroTargetLunMap = new HashMap<String, Lun>();
        String hyperMetroTargetArraySn = "";
        for (StorageResource resource : lunList) {
            Lun lun;
            if (!(resource instanceof Lun) || (lun = (Lun)resource).getDevSn().equals(devSn)) continue;
            hyperMetroTargetLunMap.put(lun.getWwn(), lun);
            hyperMetroTargetArraySn = lun.getDevSn();
        }
        if (!VerifyUtil.isEmpty(hyperMetroTargetLunMap)) {
            this.buildHyperMetroNode(context, nodeToLunMap, wwnSet, hyperMetroTargetLunMap, hyperMetroTargetArraySn, wrapMap);
        }
    }

    private void buildHyperMetroNode(TopoContext context, Map<Node, StorageResource> nodeToLunMap, Set<String> wwnSet, Map<String, Lun> hyperMetroTargetLunMap, String hyperMetroTargetArraySn, Map<String, String> wrapMap) {
        DrStorage hyperMetrolTargetArray = (DrStorage)this.getDrResource(hyperMetroTargetArraySn);
        Site hyperMetroTargetSite = context.getSiteService().getSiteById(hyperMetrolTargetArray.getSiteId());
        context.getSiteMaps().put(hyperMetroTargetSite.getSiteId(), hyperMetroTargetSite);
        Node hyperMetrolTargetNode = this.addSiteNode(context, hyperMetrolTargetArray, hyperMetroTargetSite, wrapMap);
        List list = StorageResourceServiceRouter.getInstance().getHyperMetroPairsByWwns(hyperMetroTargetSite.getServerUuid(), new ArrayList<String>(wwnSet), null, hyperMetrolTargetArray.getDeviceSn(), false);
        HashMap wwnToPair = new HashMap();
        list.stream().forEach(pair -> wwnToPair.put(pair.getResourceWwn(), pair));
        for (Map.Entry<Node, StorageResource> entry : nodeToLunMap.entrySet()) {
            LunElement element;
            Node repTrgLunNode = entry.getKey();
            Lun targetLun = (Lun)entry.getValue();
            HyperMetroPair pair2 = null;
            if (null == targetLun) {
                element = new LunElement((Object)(hyperMetroTargetArraySn + repTrgLunNode.getID()), null);
            } else {
                Lun hyperMetralOtherLun = hyperMetroTargetLunMap.get(targetLun.getWwn());
                element = hyperMetralOtherLun != null ? new LunElement((Object)(hyperMetroTargetArraySn + hyperMetralOtherLun.getLunId()), hyperMetralOtherLun) : new LunElement((Object)(hyperMetroTargetArraySn + targetLun.getLunId()), targetLun, targetLun.getLunId());
                pair2 = (HyperMetroPair)wwnToPair.get(targetLun.getWwn());
            }
            context.addChild((IData)hyperMetrolTargetNode, (IData)element);
            if (ProtectionJobUtil.isHyperMetroInFirstSite((ProtectGroup)context.getProtectGroup()) && !NO_VPANEL_PO_TYPE.contains(context.getProtectGroup().getPoType())) continue;
            context.linkTo(repTrgLunNode, (Node)element, new Skin[]{new HyperMetroLunLinkSkin(pair2)});
        }
    }

    private void sortNode(TopoContext context) {
        ProtectGroup pg = context.getProtectGroup();
        String siteInfoListStr = (String)pg.getProps().get("PROP_KEY_SITE_INFO");
        if (null == siteInfoListStr) {
            logger.warn((Object)("no siteInfoListStr for:" + pg.getName()));
            return;
        }
        Map<String, String> devSnRepMap = this.getDevSnRepMap(pg);
        HashMap<String, String> siteRepMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : devSnRepMap.entrySet()) {
            String disasterSiteId = this.getDrResource(entry.getKey()).getSiteId();
            String productSiteId = this.getDrResource(entry.getValue()).getSiteId();
            siteRepMap.put(disasterSiteId, productSiteId);
        }
        List siteInfoList = JSONArray.toCollection((JSONArray)JSONArray.fromObject((Object)siteInfoListStr), SiteInfo.class);
        Set hyperSiteIdSet = siteInfoList.stream().filter(siteInfo -> siteInfo.getSiteIdSet().size() >= 2).findFirst().get().getSiteIdSet();
        List<String> siteIdList = this.getSiteIdList(pg, siteRepMap, hyperSiteIdSet);
        Collections.sort(context.getRootNode().getChildren(), (e1, e2) -> {
            Node node1 = (Node)e1;
            Node node2 = (Node)e2;
            Integer index1 = siteIdList.indexOf(String.valueOf(node1.getID()));
            Integer index2 = siteIdList.indexOf(String.valueOf(node2.getID()));
            return index1.compareTo(index2);
        });
        if (pg.getTemplate().getType() == 36 && !NO_VPANEL_PO_TYPE.contains(pg.getPoType())) {
            String prodSiteId = pg.getProductSiteId();
            Collections.sort(context.getRootNode().getChildren(), (e1, e2) -> {
                Node node1 = (Node)e1;
                Node node2 = (Node)e2;
                if (prodSiteId.equals(String.valueOf(node1.getID()))) {
                    return -1;
                }
                if (prodSiteId.equals(String.valueOf(node2.getID()))) {
                    return 1;
                }
                return 0;
            });
        }
    }

    private Map<String, String> getDevSnRepMap(ProtectGroup pg) {
        HashMap<String, String> devSnRepMap = new HashMap<String, String>();
        HashSet pgRemoteReplicas = new HashSet(pg.listAllReplicatonRepica());
        for (ProtectGroupReplica pgReplica : pgRemoteReplicas) {
            for (ProtectObjectReplica poReplica : pgReplica.getReplicas()) {
                poReplica.getStorageInfos().stream().forEach(storageInfo -> devSnRepMap.put(storageInfo.getStorageProviderSN(), storageInfo.getSrcStorageProviderSN()));
            }
        }
        return devSnRepMap;
    }

    private List<String> getSiteIdList(ProtectGroup pg, Map<String, String> siteRepMap, Set<String> hyperSiteIdSet) {
        LinkedList<String> siteIdList = new LinkedList<String>(hyperSiteIdSet);
        this.spandSiteId(true, siteIdList, siteRepMap);
        this.spandSiteId(false, siteIdList, siteRepMap);
        if (!pg.getProductSiteId().contains(siteIdList.get(0)) && !pg.getProductSiteId().contains(siteIdList.get(1))) {
            Collections.reverse(siteIdList);
        }
        return siteIdList;
    }

    private void spandSiteId(boolean isLeft, LinkedList<String> siteIdList, Map<String, String> siteRepMap) {
        boolean find;
        do {
            String siteId = isLeft ? siteIdList.get(0) : siteIdList.get(siteIdList.size() - 1);
            String findSiteId = null;
            if (siteRepMap.containsKey(siteId) && !siteIdList.contains(siteRepMap.get(siteId))) {
                findSiteId = siteRepMap.get(siteId);
            } else {
                for (String key : this.finKeysByValue(siteRepMap, siteId)) {
                    if (siteIdList.contains(key)) continue;
                    findSiteId = key;
                }
            }
            if (null != findSiteId) {
                if (isLeft) {
                    siteIdList.addFirst(findSiteId);
                } else {
                    siteIdList.addLast(findSiteId);
                }
                find = true;
                continue;
            }
            find = false;
        } while (find);
    }

    private Set<String> finKeysByValue(Map<String, String> map, String value) {
        return map.entrySet().stream().filter(entry -> ((String)entry.getValue()).equals(value)).map(entry -> (String)entry.getKey()).collect(Collectors.toSet());
    }

    private boolean isParallel(ProtectGroup protectGroup) {
        PolicyTemplate template = protectGroup.getTemplate();
        int type = template.getType();
        HashSet parallel3Dc = Sets.newHashSet((Object[])new Integer[]{5, 6, 27});
        if (parallel3Dc.contains(type)) {
            return true;
        }
        HashSet parallel4Dc = Sets.newHashSet((Object[])new Integer[]{36, 39, 41, 43});
        return parallel4Dc.contains(type) && !ProtectionJobUtil.isHyperMetroInFirstSite((ProtectGroup)protectGroup) && !NO_VPANEL_PO_TYPE.contains(protectGroup.getPoType());
    }

    protected Node addSiteNode(TopoContext context, DrStorage drStorage, Site siteInfo, Map<String, String> wrapMap) {
        ProtectGroup pg = context.getProtectGroup();
        Node site = (Node)context.getElementBox().getDataByID((Object)siteInfo.getSiteId());
        if (null == site) {
            String wrapId = wrapMap.get(siteInfo.getSiteId());
            boolean wrap = null != wrapId;
            site = this.createSiteNode(context, siteInfo, wrap, wrapId);
        }
        String snid = drStorage.getDeviceSn() + ":storage";
        Node storage = (Node)context.getElementBox().getDataByID((Object)snid);
        if (null == storage) {
            Boolean vertical = (Boolean)context.find((Object)"vertical");
            Node root = site;
            if (vertical != null && vertical.booleanValue()) {
                VPanelElement panel = new VPanelElement((Object)("Site-Inner-Panel-Replica-" + siteInfo.getSiteId()));
                root = (Node)context.addChild((IData)site, (IData)panel);
            }
            storage = PolicyTemplateType.SAN_HYPER_VAULT_POLICYTEMPLATE.contains(pg.getTemplate().getType()) ? (Node)context.addChild((IData)root, (IData)new StorageElement(context, drStorage)) : (Node)context.addChild((IData)root, (IData)new StorageElement(drStorage));
        }
        return storage;
    }

    private Node addAirGapSrcNode(TopoContext context, ReplicaRelation replicaRelation, String srcSN, String tgtSN) {
        IResourceService resourceService = (IResourceService)ServiceLocator.getInstance().getService(IResourceService.class);
        List timeWindows = resourceService.getResourceTimeWindow(tgtSN);
        Optional<ResourceTimeWindow> opt = timeWindows.stream().filter(timeWindow -> Objects.equals(srcSN, timeWindow.getEsn())).findAny();
        String srcNodeName = !opt.isPresent() ? "--" : opt.get().getRemoteName();
        Node root = context.getRootNode();
        DrStorage drStorage = new DrStorage();
        drStorage.setIpAddress("--");
        drStorage.setName(srcNodeName);
        drStorage.setDeviceSn(replicaRelation.getSourceSN());
        drStorage.setProductModel("UNKNOWN");
        drStorage.setStatus("0");
        return (Node)context.addChild((IData)root, (IData)new StorageElement(drStorage));
    }

    protected Node createSiteNode(TopoContext context, Site site, boolean wrap, String wrapId) {
        Node root = context.getRootNode();
        SiteElement node = new SiteElement(site);
        Node old = (Node)context.getElementBox().getElementByID(node.getID());
        if (old != null) {
            return old;
        }
        VPanelElement container = (VPanelElement)context.find((Object)"Replication-Container");
        if (container != null) {
            root = (Node)context.addChild((IData)root, (IData)container);
        }
        if (wrap) {
            VPanelElement vPanelElement = (VPanelElement)context.find((Object)wrapId);
            vPanelElement = null == vPanelElement ? new VPanelElement((Object)wrapId) : vPanelElement;
            root = (Node)context.addChild((IData)root, (IData)vPanelElement);
        }
        node = (Node)context.addChild((IData)root, (IData)node);
        return node;
    }
}

