/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.topology;

import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReplicaRelation
implements Comparable<ReplicaRelation> {
    private static Log logger = LogFactory.getInstance(ReplicaRelation.class);
    private ProtectGroupReplica info;
    private ProtectGroup pg;
    private String sourceSN;
    private String targetSN;
    private List<String> sources = new ArrayList<String>();
    private List<String> targets = new ArrayList<String>();
    private List<Integer> postoragetypes = new ArrayList<Integer>();
    private Map<String, Integer> poStorageTypeMap = new HashMap<String, Integer>();
    private Map<String, String> isTgtLunToConinstance = new HashMap<String, String>();
    private int protectLocation;
    private boolean empty;

    public ReplicaRelation(ProtectGroupReplica info) {
        this.info = info;
        this.protectLocation = info.getProtectLocation();
        for (ProtectObjectReplica replica : this.getReplicas()) {
            for (RelicaStorageInfo storage : replica.getStorageInfos()) {
                if (!this.sources.contains(storage.getSrcStorageId())) {
                    this.sources.add(storage.getSrcStorageId());
                    this.targets.add(storage.getStorageId());
                }
                this.sourceSN = storage.getSrcStorageProviderSN();
                this.targetSN = storage.getStorageProviderSN();
            }
        }
        this.empty = this.targets.isEmpty();
    }

    public ReplicaRelation(ProtectGroup pg, ProtectGroupReplica info) {
        this.pg = pg;
        this.info = info;
        this.protectLocation = info.getProtectLocation();
        this.getTypeMap();
        for (ProtectObjectReplica replica : this.getReplicas()) {
            int poStorageType = DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue();
            String poId = replica.getPoId();
            poStorageType = this.getPoStorageType(poStorageType, poId);
            for (RelicaStorageInfo storage : replica.getStorageInfos()) {
                if (!this.sources.contains(storage.getSrcStorageId())) {
                    this.sources.add(storage.getSrcStorageId());
                    this.targets.add(storage.getStorageId());
                    this.postoragetypes.add(poStorageType);
                }
                this.sourceSN = storage.getSrcStorageProviderSN();
                this.targetSN = storage.getStorageProviderSN();
                if (!(storage instanceof RemoteStorageReplica)) continue;
                logger.debug((Object)("put info: " + this.targetSN + storage.getStorageId() + ",value=" + ((RemoteStorageReplica)storage).getConsistentGroupId()));
                this.isTgtLunToConinstance.put(this.targetSN + storage.getStorageId(), ((RemoteStorageReplica)storage).getConsistentGroupId());
            }
        }
        this.empty = this.targets.isEmpty();
    }

    private int getPoStorageType(int poStorageType, String poId) {
        if (this.poStorageTypeMap.containsKey(poId)) {
            poStorageType = this.poStorageTypeMap.get(poId);
            return poStorageType;
        }
        logger.error((Object)("ResourceType is null. PoId: " + poId), 90160758787071L);
        return poStorageType;
    }

    private void getTypeMap() {
        this.poStorageTypeMap = new HashMap<String, Integer>();
        for (ProtectObject po : this.pg.getPolist()) {
            Iterator iterator;
            int resourceType = DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue();
            if (po.getUsedStorageResourceSet().size() > 0 && (iterator = po.getUsedStorageResourceSet().iterator()).hasNext()) {
                resourceType = ((ProtectObjectStorageInfo)iterator.next()).getResourceType();
            }
            this.poStorageTypeMap.put(po.getUuid(), resourceType);
        }
    }

    public Map<String, String> getIsTgtLunToConinstance() {
        return this.isTgtLunToConinstance;
    }

    public int getProtectLocation() {
        return this.protectLocation;
    }

    public void setProtectLocation(int protectLocation) {
        this.protectLocation = protectLocation;
    }

    public ProtectGroupReplica getProtectGroupReplica() {
        return this.info;
    }

    public int getType() {
        return this.info.getType();
    }

    public Set<ProtectObjectReplica> getReplicas() {
        return this.info.getReplicas();
    }

    public String getRecoverySite() {
        return this.info.getRecoverySite();
    }

    public String getSourceSN() {
        return this.sourceSN;
    }

    public String getTargetSN() {
        return this.targetSN;
    }

    public List<String> getSourceLuns() {
        return Collections.unmodifiableList(this.sources);
    }

    public List<String> getTargetLuns() {
        return Collections.unmodifiableList(this.targets);
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public String getSourceLunByTarget(Integer target) {
        int size = this.targets.size();
        for (int i = 0; i < size; ++i) {
            if (!String.valueOf(target).equals(this.targets.get(i)) || i >= this.sources.size()) continue;
            return this.sources.get(i);
        }
        return null;
    }

    public String getTargetLunBySource(String source) {
        int size = this.sources.size();
        for (int i = 0; i < size; ++i) {
            if (!source.equals(this.sources.get(i)) || i >= this.targets.size()) continue;
            return this.targets.get(i);
        }
        return null;
    }

    public int getStorageTypeBySource(String source) {
        int index = this.sources.indexOf(source);
        if (index >= 0 && index < this.postoragetypes.size()) {
            return this.postoragetypes.get(index);
        }
        return DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue();
    }

    @Override
    public int compareTo(ReplicaRelation that) {
        if (this.empty) {
            return that.empty ? 0 : -1;
        }
        if (that.empty) {
            return 1;
        }
        if (this.targetSN.compareTo(that.sourceSN) == 0) {
            return -1;
        }
        if (that.targetSN.compareTo(this.sourceSN) == 0) {
            return 1;
        }
        return 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.sourceSN == null ? 0 : this.sourceSN.hashCode());
        result = 31 * result + (this.targetSN == null ? 0 : this.targetSN.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReplicaRelation other = (ReplicaRelation)obj;
        if (this.sourceSN == null ? other.sourceSN != null : !this.sourceSN.equals(other.sourceSN)) {
            return false;
        }
        return !(this.targetSN == null ? other.targetSN != null : !this.targetSN.equals(other.targetSN));
    }
}

