/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.topology;

import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationRelation;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.drm.topo.sdk.twaver.Skin;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import twaver.IElement;

public class ReplicationLinkSkin
extends Skin {
    private static final int REPLICATION_ASYN_Y_OFFSET = -25;
    private String type;
    private ReplicationTargetLun replication;
    private String scheduleInfo;
    private ReplicationRelation repliationRelation;

    public ReplicationLinkSkin(String type, ReplicationTargetLun replication) {
        this(type, replication, null);
    }

    public ReplicationLinkSkin(String type, ReplicationTargetLun replication, String scheduleInfo) {
        this.type = type;
        this.replication = replication;
        this.scheduleInfo = scheduleInfo;
    }

    public ReplicationLinkSkin(ReplicationRelation repliationRelation, String type, ReplicationTargetLun replication, String scheduleInfo) {
        this.type = type;
        this.replication = replication;
        this.scheduleInfo = scheduleInfo;
        this.repliationRelation = repliationRelation;
    }

    public void apply(IElement link) {
        link.setStyle("link.width", (Object)1.0);
        link.setClient("linkToXOffset", (Object)10.0);
        link.setStyle("arrow.to", (Object)true);
        this.initReplicationToolTipAndColor(link);
        link.setStyle("link.from.at.edge", (Object)true);
        link.setStyle("link.to.at.edge", (Object)true);
        link.setStyle("arrow.to.width", (Object)7.0);
        link.setStyle("arrow.to.height", (Object)6.0);
        link.setStyle("arrow.to.shape", (Object)"arrow.delta");
        link.setStyle("label.bold", (Object)false);
        link.setStyle("label.font", (Object)this.getTopoResourceManager().getText("ism.drm.topo.label.font"));
        link.setStyle("link.extend", (Object)0);
        link.setStyle("select.alpha", (Object)1.0);
        link.setStyle("select.style", (Object)"none");
    }

    private void initReplicationToolTipAndColor(IElement link) {
        String typeDisplay = this.getTopoResourceManager().getText("ism.drm.topo.policy.replication.type");
        typeDisplay = typeDisplay + " ";
        String linkColor = "0xbbbbbb";
        typeDisplay = this.initReplicationToolTipType(link, this.replication, typeDisplay);
        String statusDisplay = this.getTopoResourceManager().getText("ism.drm.topo.policy.replication.status");
        statusDisplay = statusDisplay + " ";
        if (this.replication == null) {
            statusDisplay = statusDisplay + "--";
            linkColor = "0xbbbbbb";
            String linkToolTip = typeDisplay + "\n" + statusDisplay;
            if (!VerifyUtil.isEmpty((String)this.scheduleInfo)) {
                linkToolTip = linkToolTip + "\n" + this.scheduleInfo;
            }
            link.setToolTip(linkToolTip);
            link.setStyle("link.color", (Object)linkColor);
            link.setStyle("arrow.to.color", (Object)linkColor);
            link.setStyle("arrow.to", (Object)false);
            return;
        }
        int hyperInfoStatus = this.initNewPairStatus(this.replication.getPairStatus());
        if (this.isPairStatusI18nConfigured(hyperInfoStatus)) {
            statusDisplay = statusDisplay + this.getTopoResourceManager().getText("ism.drm.topo.policy.replication.status." + hyperInfoStatus);
            linkColor = this.getTopoResourceManager().getText("ism.drm.topo.policy.replication.color." + hyperInfoStatus);
        } else {
            statusDisplay = statusDisplay + "--";
            linkColor = "0xbbbbbb";
        }
        this.initReplicationToolTip(link, typeDisplay, linkColor, statusDisplay, hyperInfoStatus);
    }

    private boolean isPairStatusI18nConfigured(int pairStatus) {
        boolean normal = pairStatus >= 1 && pairStatus <= 6;
        normal = normal || pairStatus == 110;
        return normal;
    }

    private void initReplicationToolTip(IElement link, String typeDisplay, String linkColor, String statusDisplay, int hyperInfoStatus) {
        int mode;
        String nameDisplay = this.getTopoResourceManager().getText("ism.drm.topo.replication.name");
        nameDisplay = nameDisplay + " ";
        boolean isShowName = false;
        if (this.replication.getParentMo() != null) {
            mode = ((ReplicationPair)this.replication.getParentMo()).getReplicationMode();
            if (!VerifyUtil.isEmpty((String)this.replication.getParentMo().getName())) {
                nameDisplay = nameDisplay + this.replication.getParentMo().getName();
                isShowName = true;
            }
        } else {
            mode = this.replication.getSyncMode();
            if (!VerifyUtil.isEmpty((String)this.replication.getName())) {
                nameDisplay = nameDisplay + this.replication.getName();
                isShowName = true;
            }
        }
        String scheduleToolTip = this.setLinkStyleAndScheduleTip(link, hyperInfoStatus, mode);
        String linkToolTip = this.buildToolTip(typeDisplay, statusDisplay, nameDisplay, isShowName);
        link.setToolTip(linkToolTip + scheduleToolTip);
        link.setStyle("link.color", (Object)linkColor);
        link.setStyle("arrow.to.color", (Object)linkColor);
    }

    protected String setLinkStyleAndScheduleTip(IElement link, int hyperInfoStatus, int mode) {
        String scheduleToolTip = "";
        if (mode == 2) {
            if (hyperInfoStatus == 2 && this.replication.getProgressRatio() != null && this.replication.getProgressRatio() >= 0) {
                link.setName(this.replication.getProgressRatio() + "%");
                link.setStyle("label.yoffset", (Object)-25);
            }
            if (!VerifyUtil.isEmpty((String)this.scheduleInfo)) {
                scheduleToolTip = "\n" + this.scheduleInfo;
            }
        }
        return scheduleToolTip;
    }

    protected String buildToolTip(String typeDisplay, String statusDisplay, String nameDisplay, boolean isShowName) {
        String linkToolTip = "";
        linkToolTip = isShowName ? nameDisplay + "\n" + typeDisplay + "\n" + statusDisplay : typeDisplay + "\n" + statusDisplay;
        String speed = this.getTopoResourceManager().getText("ism.drm.topo.replication.speedlevel." + this.replication.getSpeedLevel());
        if (null != this.repliationRelation && this.repliationRelation instanceof ReplicationGroup) {
            speed = this.getTopoResourceManager().getText("ism.drm.topo.replication.speedlevel." + ((ReplicationGroup)this.repliationRelation).getSpeedLevel());
        }
        linkToolTip = linkToolTip + "\n" + this.getTopoResourceManager().getText("ism.drm.topo.replication.speedlevel") + speed;
        return linkToolTip;
    }

    private int initNewPairStatus(int pairStatus) {
        if (this.type == null || this.type.endsWith("XveUnit") || this.type.endsWith("HvsUnit") || this.type.endsWith("FusionStorageUnit")) {
            pairStatus = TopoServiceUtil.initNewPairStatus((int)pairStatus);
        }
        return pairStatus;
    }

    private String initReplicationToolTipType(IElement link, ReplicationTargetLun trgLunInfo, String typeDisplay) {
        if (trgLunInfo == null) {
            typeDisplay = typeDisplay + "--";
            return typeDisplay;
        }
        int mode = trgLunInfo.getParentMo() != null ? ((ReplicationPair)trgLunInfo.getParentMo()).getReplicationMode().intValue() : trgLunInfo.getSyncMode().intValue();
        if (mode == 2) {
            typeDisplay = typeDisplay + this.getTopoResourceManager().getText("ism.drm.topo.policy.replication.acyn");
            link.setStyle("icons.names", (Object)"/theme/recoverydirector/images/topo/ic_asynchronous.png");
            link.setStyle("icons.position", (Object)"top");
            link.setClient("linkType", (Object)"aysnLink");
        } else {
            typeDisplay = mode == 1 ? typeDisplay + this.getTopoResourceManager().getText("ism.drm.topo.policy.replication.scyn") : typeDisplay + "--";
        }
        return typeDisplay;
    }
}

