/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.discovery.process;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.array.sdk.model.XveStoragePool;
import com.huawei.ism.base.sdk.model.StorageNE;
import com.huawei.ism.base.sdk.model.StoragePool;
import com.huawei.ism.cbb.base.dao.IMoDao;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.discover.framework.AbstractContext;
import com.huawei.ism.cbb.discover.framework.IProcessor;
import com.huawei.ism.drm.base.util.ResourceLockUtil;
import com.huawei.ism.drm.storage.manager.proxy.StorageLunManagerProxy;
import com.huawei.ism.drm.storage.manager.proxy.StorageReplicationManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageLunManager;
import com.huawei.ism.drm.storage.sdk.model.ReplicationGroup;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.lego.cbb.resource.sdk.model.ManagedObject;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import com.huawei.ubase.adaptor.hvs.discovery.process.RetrieveHVSInfoProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class HvsSpecifyResourceInfoRetriver
extends RetrieveHVSInfoProcessor
implements IProcessor {
    private static final Log logger = LogFactory.getInstance(HvsSpecifyResourceInfoRetriver.class);

    public boolean process(AbstractContext context) {
        StorageNE storage = (StorageNE)context.getAttribute("StorageDevice", StorageNE.class);
        if (null == storage) {
            logger.error((Object)"storageDevice is null.");
            throw new LegoCheckedException(1073947393L);
        }
        Integer resourceType = (Integer)context.getAttribute("refreshResourceType", Integer.class);
        String resourceID = (String)context.getAttribute("refreshResourceID", String.class);
        VerifyUtil.checkStrs((String[])new String[]{resourceID});
        logger.info((Object)"begin to retrieve fusionstorage resource, sn:%s, resourceType=%s, resourceID=%s", new Object[]{storage.getSn(), resourceType, resourceID});
        if (VerifyUtil.isEmpty((Object)resourceType) || resourceType != 1) {
            logger.error((Object)"refresh StorageResource failed, resourceType(%s) must be 1", (long)resourceType.intValue());
            throw new LegoCheckedException(1073947393L);
        }
        IMoDao moDao = CommonDAOLocator.getMoDao();
        HvsUnit hvsUnit = (HvsUnit)moDao.getMo(HvsUnit.class, "devSn", (Object)storage.getSn());
        List storagePools = moDao.getMoList(XveStoragePool.class, "topMoUuid", (Object)storage.getUuid());
        if (VerifyUtil.isEmpty((Object)hvsUnit) || VerifyUtil.isEmpty((Collection)storagePools)) {
            logger.error((Object)"get hvsUnit or storagePools failed");
            throw new LegoCheckedException(0x300001L);
        }
        hvsUnit.setChildMos(new HashSet());
        this.updateReplicationCGAndPairAndLunMO(storage, resourceID, hvsUnit, storagePools);
        logger.info((Object)"retrieve fusionstorage specify resource finished, sn:%s, resourceType=%s, resourceID=%s", new Object[]{storage.getSn(), resourceType, resourceID});
        return true;
    }

    private <T extends StoragePool> void updateReplicationCGAndPairAndLunMO(StorageNE storage, String resourceID, HvsUnit hvsUnit, Collection<T> pools) {
        logger.info((Object)"update replicationCGAndPairAndLun begin. SN:%s, replicationCG ID=%s", new Object[]{storage.getSn(), resourceID});
        StorageReplicationManagerProxy proxy = StorageReplicationManagerProxy.getInstance();
        long queryReplicationGroupBeginTime = System.currentTimeMillis();
        ReplicationGroup replicationGroups = proxy.getReplicationGroup(storage.getSn(), resourceID);
        long queryReplicationGroupCustomTime = System.currentTimeMillis() - queryReplicationGroupBeginTime;
        IMoDao moDao = CommonDAOLocator.getMoDao();
        replicationGroups.setParentMo((ManagedObject)hvsUnit);
        replicationGroups.setTopMoUuid(hvsUnit.getTopMoUuid());
        moDao.saveOrUpdateMo((ManagedObject)replicationGroups);
        long queryReplicationPairBeginTime = System.currentTimeMillis();
        List replicationPairList = proxy.queryReplicationPairByCgId(storage.getSn(), resourceID);
        long queryReplicationPairCustomTime = System.currentTimeMillis() - queryReplicationPairBeginTime;
        HashSet lunIds = new HashSet();
        replicationPairList.forEach(tempReplicationPair -> lunIds.add(tempReplicationPair.getIsPrimary() != false ? tempReplicationPair.getSrcLunId() : tempReplicationPair.getTgtLunId()));
        StorageLunManagerProxy proxyStorageLun = StorageLunManagerProxy.getInstance();
        IStorageLunManager manager = proxyStorageLun.getStorageLunMgrByDevId(storage.getSn());
        long queryLunBeginTime = System.currentTimeMillis();
        List luns = manager.queryLuns(storage.getSn(), new ArrayList(lunIds));
        long queryLunCustomTime = System.currentTimeMillis() - queryLunBeginTime;
        HashMap<String, List<ReplicationPair>> existedPairs = new HashMap<String, List<ReplicationPair>>();
        ArrayList<String> existedLuns = new ArrayList<String>();
        this.constructExistedPairMap(storage.getSn(), resourceID, existedPairs, existedLuns);
        long constructEnd = System.currentTimeMillis();
        this.addOrUpdateLuns(storage, pools, moDao, luns, existedLuns);
        long beforeDeleteLuns = System.currentTimeMillis();
        this.deleteLuns(storage.getSn(), existedLuns);
        long afterDeleteLuns = System.currentTimeMillis();
        logger.debug((Object)"end SN:%s, replicationCG ID=%s", new Object[]{storage.getSn(), resourceID});
        this.addOrUpdatePairs(storage, hvsUnit, moDao, replicationPairList, existedPairs);
        long beforeDeletePairs = System.currentTimeMillis();
        this.deletePairs(storage, resourceID, moDao, existedPairs);
        logger.info((Object)"update replicationCGAndPairAndLun end. SN:%s, replicationCG ID=%s, queryReplicationGroupCustomTime:%s(saving end: %s), queryReplicationPairCustomTime:%s, queryLunCustomTime:%s, construct end: %s, before delete Luns: %s, after delete Luns: %s, before delete pairs: %s", new Object[]{storage.getSn(), resourceID, queryReplicationGroupCustomTime, queryReplicationPairBeginTime, queryReplicationPairCustomTime, queryLunCustomTime, constructEnd, beforeDeleteLuns, afterDeleteLuns, beforeDeletePairs});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addOrUpdatePairs(StorageNE storage, HvsUnit hvsUnit, IMoDao moDao, List<ReplicationPair> replicationPairList, Map<String, List<ReplicationPair>> existedPairs) {
        for (ReplicationPair tempReplicationPair : replicationPairList) {
            tempReplicationPair.setParentMo((ManagedObject)hvsUnit);
            tempReplicationPair.setTopMoUuid(hvsUnit.getTopMoUuid());
            String lockId = ResourceLockUtil.lockPair((String)tempReplicationPair.getReplicationId());
            try {
                moDao.saveOrUpdateMo((ManagedObject)tempReplicationPair);
            }
            finally {
                ResourceLockUtil.unlockRes((String)lockId);
            }
            existedPairs.remove(tempReplicationPair.getReplicationId());
            logger.debug((Object)"SN:%s, replication ID=%s", new Object[]{storage.getSn(), tempReplicationPair.getReplicationId()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T extends StoragePool> void addOrUpdateLuns(StorageNE storage, Collection<T> pools, IMoDao moDao, List<Lun> luns, List<String> existedLuns) {
        for (Lun lun : luns) {
            for (StoragePool tempStoragePool : pools) {
                tempStoragePool.setChildMos(new HashSet());
                if (lun.getStoragePoolId() == null || !lun.getStoragePoolId().equals(tempStoragePool.getPoolId())) continue;
                lun.setParentMo((ManagedObject)tempStoragePool);
                lun.setTopMoUuid(tempStoragePool.getTopMoUuid());
                String lockId = ResourceLockUtil.lockLun((String)lun.getWwn());
                try {
                    moDao.saveOrUpdateMo((ManagedObject)lun);
                }
                finally {
                    ResourceLockUtil.unlockRes((String)lockId);
                }
                existedLuns.remove(lun.getLunId());
                logger.debug((Object)"start SN:%s, LUN ID=%s", new Object[]{storage.getSn(), lun.getLunId()});
            }
        }
    }

    private void deletePairs(StorageNE storage, String resourceID, IMoDao moDao, Map<String, List<ReplicationPair>> existedPairsToDelete) {
        if (!VerifyUtil.isEmpty(existedPairsToDelete)) {
            List pairIds = existedPairsToDelete.values().stream().flatMap(Collection::stream).map(pair -> this.deletePairWithLock(storage, resourceID, moDao, (ReplicationPair)pair)).collect(Collectors.toList());
            logger.info((Object)"Deleted pairIds=%s", new Object[]{pairIds});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String deletePairWithLock(StorageNE storage, String resourceId, IMoDao moDao, ReplicationPair pair) {
        String lockId = ResourceLockUtil.lockPair((String)pair.getReplicationId());
        try {
            HashMap<String, Object> props = new HashMap<String, Object>();
            props.put("devSn", storage.getSn());
            props.put("moId", pair.getMoId());
            props.put("consistentGroupId", resourceId);
            List replicationPairs = moDao.findMoBy(ReplicationPair.class, props);
            if (!VerifyUtil.isEmpty((Collection)replicationPairs)) {
                moDao.deleteMo(pair.getMoId());
            }
        }
        finally {
            ResourceLockUtil.unlockRes((String)lockId);
        }
        return pair.getReplicationId();
    }

    private void constructExistedPairMap(String deviceSn, String replicationGroupId, Map<String, List<ReplicationPair>> pairResult, List<String> lunIds) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("devSn", deviceSn);
        props.put("consistentGroupId", replicationGroupId);
        List pairs = CommonDAOLocator.getMoDao().findMoBy(ReplicationPair.class, props);
        if (!VerifyUtil.isEmpty((Collection)pairs)) {
            HashSet<String> lunSet = new HashSet<String>();
            for (ReplicationPair item : pairs) {
                List<ReplicationPair> pairList = pairResult.get(item.getReplicationId());
                if (VerifyUtil.isEmpty(pairList)) {
                    pairList = new ArrayList<ReplicationPair>(2);
                    pairResult.put(item.getReplicationId(), pairList);
                }
                pairList.add(item);
                String lunId = item.getIsPrimary() != false ? item.getSrcLunId() : item.getTgtLunId();
                if (VerifyUtil.isEmpty((String)lunId)) continue;
                lunSet.add(lunId);
            }
            lunIds.addAll(lunSet);
        }
        logger.debug((Object)"constructExistedPairMap from DB pairResult size:%s, lunIds size:%s", new Object[]{String.valueOf(pairResult.size()), String.valueOf(lunIds.size())});
    }

    private void deleteLuns(String deviceSn, List<String> needRemovedLuns) {
        if (VerifyUtil.isEmpty(needRemovedLuns)) {
            return;
        }
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("devSn", deviceSn);
        props.put("lunId", needRemovedLuns.toArray());
        List luns = CommonDAOLocator.getMoDao().findMoBy(Lun.class, props);
        long beforeDeleteMo = System.currentTimeMillis();
        if (!VerifyUtil.isEmpty((Collection)luns)) {
            luns.forEach(lun -> {
                String lockId = ResourceLockUtil.lockLun((String)lun.getWwn());
                try {
                    CommonDAOLocator.getMoDao().deleteMoWithoutMsg(lun.getMoId());
                }
                finally {
                    ResourceLockUtil.unlockRes((String)lockId);
                }
            });
        }
        logger.info((Object)"Deleted lunIds=%s, deleting cost: %s", new Object[]{needRemovedLuns, System.currentTimeMillis() - beforeDeleteMo});
    }

    public void postProcess(AbstractContext context) {
        logger.info((Object)"nothing need to process in this phase.");
    }

    public void clean(AbstractContext context) {
        logger.info((Object)"nothing need to clean.");
    }
}

