/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl;

import com.huawei.ism.cbb.base.sdk.constant.DmEnumDefine;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.drm.storage.handler.IStorageHyperCDPHandler;
import com.huawei.ism.drm.storage.sdk.model.HyperCDP;
import com.huawei.ism.drm.storage.sdk.model.SecureSnapParam;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.NumberUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageHyperCDPHandlerImpl
implements IStorageHyperCDPHandler {
    private static final Log logger = LogFactory.getInstance(StorageHyperCDPHandlerImpl.class);
    private RestConnectionManager connMgr = RestConnectionManager.getInstance();

    protected RestConnection getConnection(String devSn) {
        RestConnection connection = this.connMgr.getConnection(devSn);
        if (null == connection) {
            logger.error((Object)("The connection does not exist. sn=" + devSn));
            throw new LegoCheckedException(1073947649L);
        }
        return connection;
    }

    private HyperCDP transitionHyperCDP(String devSn, Map<String, String> result) {
        HyperCDP cdp = new HyperCDP();
        cdp.setConsistentGroupId(result.get("CONSISTENCYGROUPID"));
        cdp.setScheduledCDP(Boolean.valueOf(result.get("ISSCHEDULEDCDP").equals("1")));
        cdp.setRunningState(result.get("RUNNINGSTATUS"));
        cdp.setRestoreProgress(NumberUtil.convertToInteger((Object)result.get("RESTOREPROGRESS")));
        cdp.setSrcResourceId(NumberUtil.convertToInteger((Object)result.get("PARENTID")));
        cdp.setId(result.get("ID"));
        cdp.setName(result.get("NAME"));
        cdp.setTimeStamp(result.get("TIMESTAMP"));
        cdp.setDevSn(devSn);
        return cdp;
    }

    public HyperCDP query(String devSn, String id) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, id});
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/cdp/" + id;
        try {
            logger.debug((Object)"Start query HyperCDP, url: %s, devsn: %s", new Object[]{url, devSn});
            Map map = connection.get(url, null);
            logger.debug((Object)"End queryHyperCDP, url: %s, devsn: %s, result: %s", new Object[]{url, devSn, map});
            if (!VerifyUtil.isEmpty((Map)map)) {
                return this.transitionHyperCDP(devSn, map);
            }
            return null;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)"Query HyperCDP error, url: %s, devSn: %s", new Object[]{url, devSn, le});
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)"Query HyperCDP failed, url: %s, devSn: %s", new Object[]{url, devSn, e});
            throw new LegoCheckedException("query HyperCDP failed.", (Throwable)e);
        }
    }

    public List<HyperCDP> queryHyperCDPByCgId(String devSn, String consistentGroupId) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, consistentGroupId});
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/cdp?filter=CONSISTENCYGROUPID::" + consistentGroupId;
        try {
            ArrayList<HyperCDP> hyperCDPs = new ArrayList<HyperCDP>();
            logger.debug((Object)"Start queryHyperCDPList, url: %s, devsn: %s", new Object[]{url, devSn});
            List results = connection.getBatch(url, null);
            logger.debug((Object)"End queryHyperCDPList, url: %s, devsn: %s", new Object[]{url, devSn});
            for (Map result : results) {
                hyperCDPs.add(this.transitionHyperCDP(devSn, result));
            }
            return hyperCDPs;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)"Query HyperCDPs error, url: %s, devSn: %s", new Object[]{url, devSn, le});
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)"Query HyperCDPs failed, url: %s, devSn:%s", new Object[]{url, devSn, e});
            throw new LegoCheckedException("query HyperCDPs failed.", (Throwable)e);
        }
    }

    public HyperCDP createCdpSecureSnapshot(String devSn, String parentId, SecureSnapParam secureSnapParam) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("NAME", "RD-SECURE-" + parentId + "-" + System.currentTimeMillis());
        map.put("PARENTID", parentId);
        map.put("SECURESNAPENABLED", "1");
        map.put("PROTECTPERIOD", String.valueOf(secureSnapParam.getProtectPeriod()));
        map.put("PROTECTPERIODUNIT", String.valueOf(secureSnapParam.getUnitType().getType()));
        map.put("AUTODELETEENABLED", secureSnapParam.isAutoDeleteEnabled() ? "1" : "0");
        try {
            RestConnection connection = this.getConnection(devSn);
            String url = "/rest/${deviceID}/cdp";
            logger.debug((Object)"Start createCdpSecureSnapshot, url: %s, devsn: %s, params: %s", new Object[]{url, devSn, map});
            Map result = connection.post(url, map);
            return this.transitionHyperCDP(result);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Exec createCdpSecureSnapshot error, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"Exec createCdpSecureSnapshot failed, errorMsg: %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException("create secure hyperCDP snapshot failed.", (Throwable)e);
        }
    }

    private HyperCDP transitionHyperCDP(Map<String, String> result) {
        if (VerifyUtil.isEmpty(result)) {
            logger.error((Object)"Parameter error.");
            throw new LegoCheckedException(1073947393L);
        }
        HyperCDP hyperCDP = new HyperCDP();
        hyperCDP.setId(result.get("ID"));
        hyperCDP.setSnapshotName(result.get("NAME"));
        hyperCDP.setRunningState(result.get("RUNNINGSTATUS"));
        hyperCDP.setTimeStamp(result.get("TIMESTAMP"));
        hyperCDP.setSrcResourceId(NumberUtil.convertToInteger((Object)result.get("PARENTID")));
        return hyperCDP;
    }

    public void restoreSnapshot(String devSn, String id, String restoreSpeed) {
        VerifyUtil.checkStrs((String[])new String[]{devSn, id});
        RestConnection connection = this.getConnection(devSn);
        if (VerifyUtil.isEmpty((String)restoreSpeed)) {
            restoreSpeed = String.valueOf(DmEnumDefine.SPEED_LEVEL_E.SPEED_LEVEL_MIDDLE.getValue());
        }
        String url = "/rest/${deviceID}/cdp/rollback";
        try {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("ID", id);
            map.put("RESTORESPEED", restoreSpeed);
            logger.debug((Object)"Start restore hyperCDP snapshot, url: %s, devSn: %s, params: %s", new Object[]{url, devSn, map});
            connection.put(url, map);
            logger.debug((Object)"End restore hyperCDP, url: %s, devSn: %s", new Object[]{url, devSn});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Restore HyperCDP error, url: %s, errorMsg: %s", new Object[]{url, ExceptionUtil.getErrorMessage((Throwable)e)});
            throw e;
        }
        catch (Exception e) {
            logger.error((Object)"Restore HyperCDP failed, url: %s, errorMsg: %s", new Object[]{url, ExceptionUtil.getErrorMessage((Throwable)e)});
            throw new LegoCheckedException("Restore HyperCDP failed.", (Throwable)e);
        }
    }
}

