/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl;

import com.huawei.ism.base.sdk.model.StorageUnit;
import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.drm.storage.handler.IStorageLicenseHandler;
import com.huawei.ism.drm.storage.hvs.handler.impl.StorageLunConsistencyGroupHandlerImpl;
import com.huawei.ism.drm.storage.manager.proxy.StorageSnapshotScheduleManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotScheduleManager;
import com.huawei.ism.drm.storage.sdk.model.LicenseFunctionItem;
import com.huawei.ism.drm.storage.sdk.model.LicenseUsageInfo;
import com.huawei.ism.drm.storage.sdk.model.SnapshotSchedule;
import com.huawei.ism.drm.storage.sdk.model.StorageLicense;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StorageLicenseHandlerImpl
implements IStorageLicenseHandler {
    private static final Log logger = LogFactory.getInstance(StorageLunConsistencyGroupHandlerImpl.class);
    private static final Pattern PATTERN = Pattern.compile("OceanStor Dorado (\\d+) V(\\d+)");

    protected RestConnection getConnection(String devSn) {
        RestConnectionManager connMgr = RestConnectionManager.getInstance();
        RestConnection connection = connMgr.getConnection(devSn);
        if (null == connection) {
            logger.error((Object)("The connection does not exist. sn=" + devSn));
            throw new LegoCheckedException(1073947649L);
        }
        return connection;
    }

    public StorageLicense getArrayLisence(String devSn) {
        VerifyUtil.checkStrs((String[])new String[]{devSn});
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/license/activelicense";
        try {
            logger.debug((Object)"get storage license.url=%s", new Object[]{url});
            Map map = connection.get("/rest/${deviceID}/license/activelicense", null);
            StorageLicense license = new StorageLicense();
            license.setCreatedTime((String)map.get("CreatedTime"));
            license.setFileExist((String)map.get("FileExist"));
            license.setLibVer((String)map.get("LibVer"));
            license.setLicenseType((String)map.get("licenseType"));
            license.setLicenseSerialNo((String)map.get("LicenseSerialNo"));
            JSONArray jsonArray = JSONArray.fromObject(map.get("LicenseFunction"));
            license.setFunctionItemList(JSONArray.toCollection((JSONArray)jsonArray, LicenseFunctionItem.class));
            JSONArray jsonArray1 = JSONArray.fromObject(map.get("LicenseUsageInfo"));
            license.setUsageInfoList(JSONArray.toCollection((JSONArray)jsonArray1, LicenseUsageInfo.class));
            HashMap<String, String> props = new HashMap<String, String>();
            props.put("devSn", devSn);
            List storageUnits = CommonDAOLocator.getMoDao().findMoBy(StorageUnit.class, props);
            if (null != storageUnits) {
                StorageUnit storageUnit = (StorageUnit)storageUnits.get(0);
                String productModel = storageUnit.getProductModel();
                if (null != productModel && productModel.contains("Dorado")) {
                    boolean isSupportSnapshot = license.isSupportFeature("2");
                    if (isSupportSnapshot) {
                        license.addFeature("10000", null);
                    }
                    try {
                        String str;
                        Matcher matcher = PATTERN.matcher(productModel);
                        if (matcher.find() && Integer.parseInt(str = matcher.group(2)) >= 6) {
                            license.addFeature("10003", null);
                        }
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Match product model got error. %s", new Object[]{ExceptionUtil.getErrorMessage((Throwable)e)});
                    }
                    license.disableFeature("3");
                }
                this.setTimingSnapLicenseFeature(devSn, license);
            }
            return license;
        }
        catch (LegoCheckedException le) {
            logger.error((Object)"query Lisence error.", (Throwable)le);
            throw le;
        }
        catch (Exception e) {
            logger.error((Object)"query Lisence failed.", (Throwable)e);
            throw new LegoCheckedException("query Lisence failed.", (Throwable)e);
        }
    }

    private void setTimingSnapLicenseFeature(String devSn, StorageLicense license) {
        block2: {
            StorageSnapshotScheduleManagerProxy proxy = StorageSnapshotScheduleManagerProxy.getInstance();
            IStorageSnapshotScheduleManager manager = proxy.getStorageSnapshotMgrByDevId(devSn, SnapshotSchedule.SCHEDULE_TYPE.SNAPSHOT.getValue());
            try {
                manager.count(devSn, SnapshotSchedule.SCHEDULE_TYPE.SNAPSHOT.getValue());
            }
            catch (LegoCheckedException le) {
                if (le.getErrorCode() != 404L && le.getErrorCode() != 1077949112L) break block2;
                logger.error((Object)"The storageUnit(devsn:%s) is not support timing snapshot", new Object[]{devSn});
                return;
            }
        }
        license.addFeature("10001", null);
    }
}

