/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.array.sdk.model.XveLun;
import com.huawei.ism.array.sdk.model.XveLunGroup;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefine;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.storage.handler.IStorageLunHandler;
import com.huawei.ism.drm.storage.hvs.handler.impl.AbstractRestStorageHandler;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.ubase.adaptor.hvs.discovery.util.HVSRestTransition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StorageLunHandlerRestImpl
extends AbstractRestStorageHandler
implements IStorageLunHandler {
    private static final String PARAM_LUN_NAME = "NAME";
    private static final String PARAM_LUN_CAPACITY = "CAPACITY";
    private static final String PARAM_LUN_PARENTID = "PARENTID";
    private static final String DEFAULT_VALUE = "0";

    public Lun queryStorageLun(String deviceSN, String lunId) {
        RestConnection connection = this.getConnection(deviceSN);
        String url = "/rest/${deviceID}/lun/" + lunId;
        logger.debug((Object)"start to query lun. url=%s,devSn=%s", new Object[]{url, deviceSN});
        Map record = connection.get(url, null);
        if (record.isEmpty()) {
            return null;
        }
        XveLun lun = HVSRestTransition.transitionXveLun((String)deviceSN, (Map)record);
        return lun;
    }

    public List<Lun> queryAllLunBySn(String deviceSN) {
        ArrayList<Lun> lunList = new ArrayList<Lun>();
        RestConnection connection = this.getConnection(deviceSN);
        List resultMapList = connection.getBatch("/rest/${deviceID}/lun?range=[0-65536]", null);
        if (VerifyUtil.isEmpty((Collection)resultMapList)) {
            logger.warn((Object)"result Map List si empty!");
            return Collections.emptyList();
        }
        for (int i = 0; i < resultMapList.size(); ++i) {
            if (((Map)resultMapList.get(i)).isEmpty()) continue;
            XveLun lun = HVSRestTransition.transitionXveLun((String)deviceSN, (Map)((Map)resultMapList.get(i)));
            lunList.add((Lun)lun);
        }
        return lunList;
    }

    public Lun createLun(Lun lun) {
        String deviceSN = lun.getDevSn();
        String name = lun.getName();
        Long capacity = lun.getCapacity();
        if (VerifyUtil.isEmpty((String)deviceSN)) {
            logger.error((Object)"devSn is null");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)name)) {
            logger.error((Object)"name is null");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((Object)capacity)) {
            logger.error((Object)"capacity is null");
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection connection = this.getConnection(deviceSN);
        String url = "/rest/${deviceID}/lun";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put(PARAM_LUN_NAME, name);
        paramMap.put(PARAM_LUN_CAPACITY, String.valueOf(capacity));
        paramMap.put(PARAM_LUN_PARENTID, lun.getParentId() == null ? DEFAULT_VALUE : String.valueOf(lun.getParentId()));
        logger.debug((Object)"start to create lun. url=%s,devSn=%s,param=%s", new Object[]{url, deviceSN, paramMap});
        Map res = connection.post(url, paramMap);
        return HVSRestTransition.transitionXveLun((String)deviceSN, (Map)res);
    }

    public void deleteLun(String deviceSN, String lunId) {
        RestConnection connection = this.getConnection(deviceSN);
        String url = "/rest/${deviceID}/lun/" + lunId;
        logger.debug((Object)"start to delete lun. url=%s,devSn=%s", new Object[]{url, deviceSN});
        connection.delete(url, null);
    }

    public List<Lun> queryLuns(String devSn, XveMOType associateObjType, String associateObjId) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            throw new LegoCheckedException(1073947393L);
        }
        if (null == associateObjType) {
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)associateObjId)) {
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection connection = this.getConnection(devSn);
        StringBuilder url = new StringBuilder("/rest/${deviceID}/lun/associate");
        url.append("?TYPE=").append(XveMOType.LUN.getValue());
        url.append("&ASSOCIATEOBJTYPE=").append(associateObjType.getValue());
        url.append("&ASSOCIATEOBJID=").append(associateObjId);
        url.append("&range=[0-65536]");
        ArrayList<Lun> luns = new ArrayList<Lun>();
        logger.debug((Object)"start to query lun batch. url=%s,devSn=%s", new Object[]{url.toString(), devSn});
        List records = connection.getBatch(url.toString(), null);
        if (!VerifyUtil.isEmpty((Collection)records)) {
            for (Map record : records) {
                XveLun lun = HVSRestTransition.transitionXveLun((String)devSn, (Map)record);
                luns.add((Lun)lun);
            }
        }
        return luns;
    }

    public XveLunGroup createLunGroup(String devSn, String name) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"Input parameter devSn is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)name)) {
            logger.error((Object)"Input parameter name is null.");
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection connection = this.getConnection(devSn);
        String url = "/rest/${deviceID}/LUNGroup";
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("APPTYPE", Integer.toString(XveEnumDefine.APP_TYPE_E.OTHER.getValue()));
        params.put("GROUPTYPE", DEFAULT_VALUE);
        params.put(PARAM_LUN_NAME, name);
        logger.debug((Object)"start to create lun group. url=%s,devSn=%s,param=%s", new Object[]{url, devSn, params});
        Map record = connection.post(url, params);
        XveLunGroup lunGroup = HVSRestTransition.transitionXveLunGroup((String)connection.getDeviceId(), (Map)record);
        return lunGroup;
    }

    public List<XveLunGroup> queryLunGroups(String devSn, XveMOType associateObjType, String associateObjId) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"Input parameter devSn is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (null == associateObjType) {
            logger.error((Object)"Input parameter associateObjType is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)associateObjId)) {
            logger.error((Object)"Input parameter associateObjId is null.");
            throw new LegoCheckedException(1073947393L);
        }
        RestConnection connection = this.getConnection(devSn);
        StringBuilder url = new StringBuilder("/rest/${deviceID}/lungroup/associate");
        url.append("?TYPE=").append(XveMOType.LUNGROUP.getValue());
        url.append("&ASSOCIATEOBJTYPE=").append(associateObjType.getValue());
        url.append("&ASSOCIATEOBJID=").append(associateObjId);
        url.append("&range=[0-65536]");
        logger.debug((Object)"start to query lun groups. url=%s,devSn=%s", new Object[]{url, devSn});
        List records = connection.getBatch(url.toString(), null);
        ArrayList<XveLunGroup> lunGroups = new ArrayList<XveLunGroup>();
        for (Map record : records) {
            XveLunGroup xveLunGroup = HVSRestTransition.transitionXveLunGroup((String)devSn, (Map)record);
            lunGroups.add(xveLunGroup);
        }
        return lunGroups;
    }
}

