/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.handler.impl;

import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefinePParent;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.base.util.AlarmReporter;
import com.huawei.ism.drm.constant.LinkTypeEnum;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.framework.util.RecoveryTaskUtil;
import com.huawei.ism.drm.site.resource.sdk.service.IResourceService;
import com.huawei.ism.drm.site.sdk.model.DrResource;
import com.huawei.ism.drm.storage.handler.IStoragePortLinksHandler;
import com.huawei.ism.drm.storage.hvs.discovery.util.HVSRestTransitionExtend;
import com.huawei.ism.drm.storage.manager.proxy.StoragePortLinksManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStoragePortLinksManager;
import com.huawei.ism.drm.storage.sdk.model.RemoteLinkDevice;
import com.huawei.ism.drm.storage.sdk.model.StorageLinkPort;
import com.huawei.ism.drm.util.CommUtil;
import com.huawei.ism.unistor.sdk.model.VstoreReplicationPair;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.nem.fault.sdk.model.FaultEnum;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;

public class StoragePortLinksHandlerImpl
implements IStoragePortLinksHandler {
    private static final Log LOGGER = LogFactory.getInstance(StoragePortLinksHandlerImpl.class);
    private static final String LINK_ENABLE_STATUS = "1";
    private final RestConnectionManager connMgr = RestConnectionManager.getInstance();

    protected RestConnection getConnection(String devSn) {
        RestConnection connection = this.connMgr.getConnection(devSn);
        if (connection == null) {
            LOGGER.error((Object)"The connection does not exist. sn = %s", new Object[]{devSn});
            throw new LegoCheckedException(1073947649L);
        }
        return connection;
    }

    public List<StorageLinkPort> getStorageLinkPorts(String devSn) {
        return this.getStorageLinkPortsByRemoteSn(devSn, null);
    }

    public List<StorageLinkPort> getStorageLinkPortsByRemoteSn(String devSn, String remoteDevSn) {
        List<Map<String, String>> resultMapList = this.getRemoteDeviceMaps(devSn, remoteDevSn);
        if (VerifyUtil.isEmpty(resultMapList)) {
            LOGGER.info((Object)"Not find remote device. without replication link.");
            return Collections.emptyList();
        }
        HashSet<StorageLinkPort> ports = new HashSet<StorageLinkPort>();
        block4: for (Map<String, String> resultMap : resultMapList) {
            RemoteLinkDevice linkDevice = HVSRestTransitionExtend.genRemoteDevice(devSn, resultMap);
            switch (linkDevice.getLinkTypeEnum()) {
                case FC: {
                    this.getFcLinkPorts(linkDevice, devSn, ports);
                    continue block4;
                }
                case LIF: {
                    this.getLifPorts(linkDevice, devSn, ports);
                    continue block4;
                }
            }
            LOGGER.debug((Object)"Not fc or lif type! type: %s", new Object[]{linkDevice.getLinkTypeEnum().getType()});
        }
        return new ArrayList<StorageLinkPort>(ports);
    }

    public List<RemoteLinkDevice> getStorageRemoteDevice(String devSn) {
        return this.getStorageRemoteDeviceByRemoteSn(devSn, null);
    }

    public List<RemoteLinkDevice> getStorageRemoteDeviceByRemoteSn(String devSn, String remoteDevSn) {
        List<Map<String, String>> resultMapList = this.getRemoteDeviceMaps(devSn, remoteDevSn);
        if (CollectionUtils.isEmpty(resultMapList)) {
            LOGGER.info((Object)"Not find remote device. without replication link.");
            return Collections.emptyList();
        }
        ArrayList<RemoteLinkDevice> resList = new ArrayList<RemoteLinkDevice>();
        for (Map<String, String> resultMap : resultMapList) {
            RemoteLinkDevice linkDevice = HVSRestTransitionExtend.genRemoteDevice(devSn, resultMap);
            HashSet<StorageLinkPort> ports = new HashSet<StorageLinkPort>();
            switch (linkDevice.getLinkTypeEnum()) {
                case FC: {
                    this.getFcLinkPorts(linkDevice, devSn, ports);
                    break;
                }
                case LIF: {
                    this.getLifPorts(linkDevice, devSn, ports);
                    break;
                }
                default: {
                    LOGGER.info((Object)"Not fc or lif type! type: %s, esn: %s", new Object[]{linkDevice.getLinkTypeEnum().getType(), linkDevice.getEsn()});
                }
            }
            linkDevice.setLinkPorts(new ArrayList<StorageLinkPort>(ports));
            resList.add(linkDevice);
        }
        return resList;
    }

    public StorageLinkPort getStoragePortByPortIdAndType(String devSn, String inputPortId, LinkTypeEnum typeEnum) {
        String portId = inputPortId.substring(inputPortId.indexOf(":") + 1);
        Optional<StorageLinkPort> opt = this.getPortByIdAndType(devSn, portId, typeEnum);
        return opt.orElse(null);
    }

    private List<Map<String, String>> getRemoteDeviceMaps(String devSn, String remoteDevSn) {
        List resultMapList;
        String url = "/rest/${deviceID}/REMOTE_DEVICE?filter=ARRAYTYPE::" + XveEnumDefinePParent.EPL_ARRAY_TYPE_E.EPL_ARRAY_PRIVATE.getValue();
        try {
            resultMapList = this.getConnection(devSn).getBatch(url, null);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Query remote device failed, errorMsg: %s", new Object[]{e.getMessage()});
            throw new LegoCheckedException(1073948474L);
        }
        if (VerifyUtil.isEmpty((String)remoteDevSn)) {
            return resultMapList;
        }
        ArrayList<Map<String, String>> newResMapList = new ArrayList<Map<String, String>>();
        for (Map record : resultMapList) {
            String sn = (String)record.get("SN");
            if (!remoteDevSn.equalsIgnoreCase(sn)) continue;
            newResMapList.add(record);
        }
        return newResMapList;
    }

    private void getLifPorts(RemoteLinkDevice linkDevice, String devSn, Set<StorageLinkPort> ports) {
        try {
            List<Map<String, String>> records = this.getIpLinkMaps(linkDevice.getDeviceId(), devSn);
            if (records.size() == 0) {
                LOGGER.error((Object)"not find any ipLinks. devId: %s", new Object[]{linkDevice.getDeviceId()});
                return;
            }
            HashSet<String> localPortNameSet = new HashSet<String>();
            for (Map<String, String> record : records) {
                String localPortName = record.get("LOCALPORTNAME");
                localPortNameSet.add(localPortName);
            }
            Set<StorageLinkPort> linkPortSet = this.getLinkPortsByPortName(linkDevice, devSn, localPortNameSet);
            ports.addAll(linkPortSet);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Query lif link port failed, errorMsg: %s", new Object[]{e.getMessage()});
            throw new LegoCheckedException(1073948475L);
        }
    }

    private void getFcLinkPorts(RemoteLinkDevice linkDevice, String devSn, Set<StorageLinkPort> ports) {
        try {
            List<Map<String, String>> records = this.getFcLinkMaps(linkDevice.getDeviceId(), devSn);
            if (records.size() == 0) {
                LOGGER.error((Object)"Not find any Fc Links by deviceId: %s", new Object[]{linkDevice.getDeviceId()});
                return;
            }
            HashSet<String> fcPortLocationSet = new HashSet<String>();
            for (Map<String, String> record : records) {
                String portLocation = record.get("localPortLocation");
                fcPortLocationSet.add(portLocation);
            }
            Set<StorageLinkPort> resList = this.getFcPortsByPortLocation(linkDevice, devSn, fcPortLocationSet);
            ports.addAll(resList);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Query FC link port failed, errorMsg: %s", new Object[]{e.getMessage()});
            throw new LegoCheckedException(1073948475L);
        }
    }

    private Set<StorageLinkPort> getLinkPortsByPortName(RemoteLinkDevice linkDevice, String devSn, Set<String> portNameSet) {
        List resultMapList = this.getConnection(devSn).getBatch("/rest/${deviceID}/LIF?range=[0-65536]", null);
        if (VerifyUtil.isEmpty((Collection)resultMapList)) {
            LOGGER.error((Object)"Not find any lif port of devSn: %s", new Object[]{devSn});
            return Collections.emptySet();
        }
        HashSet<StorageLinkPort> linkPorts = new HashSet<StorageLinkPort>();
        for (Map record : resultMapList) {
            String portName = (String)record.get("NAME");
            if (!portNameSet.contains(portName)) continue;
            StorageLinkPort linkPort = HVSRestTransitionExtend.genStorageLifLinkPort(devSn, record);
            boolean enable = LINK_ENABLE_STATUS.equals(linkDevice.getHealthStatus());
            linkPort.setEnable(Boolean.valueOf(enable));
            linkPorts.add(linkPort);
        }
        return linkPorts;
    }

    private Optional<StorageLinkPort> getPortByIdAndType(String devSn, String portId, LinkTypeEnum typeEnum) {
        List resultMapList;
        if (typeEnum == LinkTypeEnum.FC) {
            resultMapList = this.getConnection(devSn).getBatch("/rest/${deviceID}/fc_port?range=[0-100]", null);
        } else if (typeEnum == LinkTypeEnum.LIF) {
            resultMapList = this.getConnection(devSn).getBatch("/rest/${deviceID}/LIF?range=[0-65536]", null);
        } else {
            return Optional.empty();
        }
        if (VerifyUtil.isEmpty((Collection)resultMapList)) {
            return Optional.empty();
        }
        for (Map record : resultMapList) {
            if (!((String)record.get("ID")).equals(portId)) continue;
            StorageLinkPort linkPort = typeEnum == LinkTypeEnum.FC ? HVSRestTransitionExtend.genStorageFcLinkPort(devSn, record) : HVSRestTransitionExtend.genStorageLifLinkPort(devSn, record);
            LOGGER.info((Object)"Get port: %s by id: %s", new Object[]{linkPort.toString(), portId});
            return Optional.of(linkPort);
        }
        return Optional.empty();
    }

    private Set<StorageLinkPort> getFcPortsByPortLocation(RemoteLinkDevice linkDevice, String devSn, Set<String> portLocationSet) {
        List fcResultMapList = this.getConnection(devSn).getBatch("/rest/${deviceID}/fc_port?range=[0-100]", null);
        if (VerifyUtil.isEmpty((Collection)fcResultMapList)) {
            return Collections.emptySet();
        }
        LOGGER.info((Object)"Get local FC port location: %s", new Object[]{portLocationSet.toString()});
        HashSet<StorageLinkPort> fcPorts = new HashSet<StorageLinkPort>();
        for (Map record : fcResultMapList) {
            String portLocation = (String)record.get("LOCATION");
            if (!portLocationSet.contains(portLocation)) continue;
            StorageLinkPort linkPort = HVSRestTransitionExtend.genStorageFcLinkPort(devSn, record);
            boolean enable = LINK_ENABLE_STATUS.equals(linkDevice.getHealthStatus());
            linkPort.setEnable(Boolean.valueOf(enable));
            fcPorts.add(linkPort);
        }
        return fcPorts;
    }

    private List<Map<String, String>> getFcLinkMaps(String deviceId, String devSn) {
        StringBuilder url = new StringBuilder("/rest/${deviceID}/fc_link?");
        if (!VerifyUtil.isEmpty((String)deviceId)) {
            url.append("DEVICEID=").append(deviceId).append("&");
        }
        url.append("LINKUSAGE=true").append("&range=[0-100]");
        return this.getConnection(devSn).getBatch(url.toString(), null);
    }

    private List<Map<String, String>> getIpLinkMaps(String deviceId, String devSn) {
        StringBuilder url = new StringBuilder("/rest/${deviceID}/iplink?");
        if (!VerifyUtil.isEmpty((String)deviceId)) {
            url.append("DEVICEID=").append(deviceId).append("&");
        }
        url.append("LINKUSAGE=true").append("&range=[0-65536]");
        return this.getConnection(devSn).getBatch(url.toString(), null);
    }

    public void disableStoragePort(String devSn, StorageLinkPort linkPort) {
        if (VerifyUtil.isEmpty((Object)linkPort)) {
            LOGGER.error((Object)"LinkPort is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (linkPort.getLinkTypeEnum() == LinkTypeEnum.LIF) {
            this.handleLifPort(devSn, linkPort.getPortName(), false);
        } else if (linkPort.getLinkTypeEnum() == LinkTypeEnum.FC) {
            this.handleFcPort(devSn, linkPort.getPortId(), false);
        } else {
            LOGGER.error((Object)"Not find the right port type, check storage remote devices, portName: %s", new Object[]{linkPort.getPortName()});
            throw new LegoCheckedException(2117645L);
        }
    }

    private void handleLifPort(String deviceSN, String portName, boolean operationalStatus) {
        LOGGER.info((Object)"enter handleLifPort operate type: %s, devSn: %s, portName: %s", new Object[]{operationalStatus, deviceSN, portName});
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("OPERATIONALSTATUS", operationalStatus ? LINK_ENABLE_STATUS : "0");
        long startTime = System.currentTimeMillis();
        try {
            this.getConnection(deviceSN).put("/rest/${deviceID}/lif?NAME=" + portName, paramMap);
            long endTime = System.currentTimeMillis();
            LOGGER.info((Object)"Operate logic port. devSn=%s, portName=%s. time=%s", new Object[]{deviceSN, portName, endTime - startTime});
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Operate kf port failed. DevSN: %s, portName: %s", new Object[]{deviceSN, portName, e});
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Operate logic port failed. DevSN:" + deviceSN + ",portName:" + portName), (long)1073948770L, (String[])new String[0], (Log)LOGGER);
        }
    }

    private synchronized void handleFcPort(String deviceSN, String inputPortId, boolean operationalStatus) {
        LOGGER.info((Object)"enter handleFcPort operate type: %s, devSn: %s, portId: %s", new Object[]{operationalStatus, deviceSN, inputPortId});
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("PORTSWITCH", operationalStatus ? LINK_ENABLE_STATUS : "0");
        String portId = inputPortId.substring(inputPortId.indexOf(":") + 1);
        long startTime = System.currentTimeMillis();
        try {
            this.getConnection(deviceSN).put("/rest/${deviceID}/fc_port/" + portId, paramMap);
            long endTime = System.currentTimeMillis();
            LOGGER.info((Object)"Operate FC port. devSn=%s, portId=%s. time=%s", new Object[]{deviceSN, portId, endTime - startTime});
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Operate FC port failed. DevSN: %s, portId: %s", new Object[]{deviceSN, portId, e});
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Operate FC port failed. DevSN:" + deviceSN + ", portId:" + portId), (long)1073948770L, (String[])new String[0], (Log)LOGGER);
        }
    }

    public void enableStoragePort(String devSn, StorageLinkPort linkPort) {
        if (VerifyUtil.isEmpty((Object)linkPort) || VerifyUtil.isEmpty((String)devSn)) {
            LOGGER.error((Object)"LinkPort is null or devSn is null.");
            throw new LegoCheckedException(1073947393L);
        }
        if (linkPort.getLinkTypeEnum() == LinkTypeEnum.LIF) {
            LOGGER.info((Object)"Begin to enable lif portName: %s", new Object[]{linkPort.getPortName()});
            this.handleLifPort(devSn, linkPort.getPortName(), true);
        } else if (linkPort.getLinkTypeEnum() == LinkTypeEnum.FC) {
            LOGGER.info((Object)"Begin to enable FC portId: %s.", new Object[]{linkPort.getPortId()});
            this.handleFcPort(devSn, linkPort.getPortId(), true);
        } else {
            LOGGER.error((Object)"Not find the right port type, check storage remote devices, portName: %s", new Object[]{linkPort.getPortName()});
            throw new LegoCheckedException(2117645L);
        }
        LOGGER.info((Object)"Enable portName: %s success!", new Object[]{linkPort.getPortName()});
    }

    public void isolateAlarm(String localDevSn, RemoteLinkDevice remoteLinkDevice) {
        Map resultMap = this.getConnection(localDevSn).get("/rest/${deviceID}/system/201", null);
        String localWwn = (String)resultMap.get("wwn");
        remoteLinkDevice.setLocalWwn(localWwn);
        this.isolateByLocal(localDevSn, remoteLinkDevice);
        if (LINK_ENABLE_STATUS.equals(remoteLinkDevice.getHealthStatus())) {
            this.isolateByExecRemoteDevice(localDevSn, remoteLinkDevice);
        } else {
            String remoteDevSn = remoteLinkDevice.getEsn();
            DrResource resource = ((IResourceService)ServiceLocator.getInstance().getService(IResourceService.class)).getDrResourceBySn(localDevSn);
            this.sendAlarmWhenNotIsolate(remoteDevSn, remoteLinkDevice.getRemoteName(), resource.getName());
        }
    }

    private void sendAlarmWhenNotIsolate(String localDevSn, String localName, String remoteName) {
        LOGGER.error((Object)"The isolate cannot be exec because the link of the remote device is abnormal.");
        String[] params = new String[]{localDevSn, localName, remoteName};
        FaultEnum.AlarmSeverity severity = FaultEnum.AlarmSeverity.getSeverity((int)3);
        AlarmReporter.sendAlarm((String)"0x3230068", (String)"", (String)"", (FaultEnum.AlarmSeverity)severity, (String[])params);
        LOGGER.info((Object)"Local devSn: %s send remote name: %s isolate alarm success.", new Object[]{localDevSn, remoteName});
    }

    public OperationResult changeLogicalPortWorkStatus(String devSn, VstoreReplicationPair pair, int type) {
        String remoteDeviceSn;
        String srcDevSN = pair.getSrcDevSN();
        String airGapDeviceSn = RecoveryTaskUtil.getAirGapQueryArrayId((String)srcDevSN, (String)(remoteDeviceSn = pair.getRemoteDeviceSn()));
        if (VerifyUtil.isEmpty((String)airGapDeviceSn) || airGapDeviceSn.equals(devSn)) {
            return this.changeLocalLogicalPortWorkStatus(devSn, pair, type);
        }
        return this.changeRemoteLogicalPortWorkStatus(airGapDeviceSn, devSn, pair, type);
    }

    public OperationResult changeLocalLogicalPortWorkStatus(String devSn, VstoreReplicationPair pair, int type) {
        OperationResult operationResult = new OperationResult("ism.business.replication.changeLogicalPortWorkStatus", true, true, new String[]{devSn});
        String url = "/rest/${deviceID}/VSTORE_PAIR/change_local_logical_port_work_status";
        try {
            RestConnection conn = this.getConnection(devSn);
            JSONObject params = new JSONObject();
            params.put((Object)"ID", (Object)pair.getVstorePairId());
            params.put((Object)"portStatus", (Object)type);
            conn.putForObject(url, (Object)params);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Change local logical port work status error, devSn:%s, pairId:%s", (Throwable)e, new Object[]{devSn, pair.getVstorePairId()});
            return new OperationResult("ism.business.replication.changeLogicalPortWorkStatus", true, false, String.valueOf(e.getErrorCode()), new String[]{devSn});
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Change local logical port work status failed.", (long)1073948481L, (String[])new String[0], (Log)LOGGER);
        }
        LOGGER.info((Object)"Change local logical port work status successfully, devSn:%s, pairId:%s", new Object[]{devSn, pair.getVstorePairId()});
        return operationResult;
    }

    public OperationResult changeRemoteLogicalPortWorkStatus(String airGapDeviceSn, String devSn, VstoreReplicationPair pair, int type) {
        OperationResult operationResult = new OperationResult("ism.business.replication.changeLogicalPortWorkStatus", true, false, new String[]{devSn});
        Optional<RemoteLinkDevice> optional = this.getSpecificRemoteLinkDevice(airGapDeviceSn, devSn);
        if (!optional.isPresent()) {
            LOGGER.error((Object)"This remote device{%s} is not queried on the current device{%s}", new Object[]{devSn, airGapDeviceSn});
            return operationResult;
        }
        RemoteLinkDevice remoteLinkDevice = optional.get();
        String execUrl = "/deviceManager/rest/xxx/VSTORE_PAIR/change_local_logical_port_work_status";
        JSONObject execParams = new JSONObject();
        execParams.put((Object)"ID", (Object)pair.getVstorePairId());
        execParams.put((Object)"portStatus", (Object)type);
        try {
            this.executeCommandsOnRemoteDevice(remoteLinkDevice, execUrl, "PUT", execParams);
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Change remote logical port work status error, devSn:%s, pairId:%s", (Throwable)e, new Object[]{devSn, pair.getVstorePairId()});
            operationResult.setErrorCode(String.valueOf(e.getErrorCode()));
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Change remote logical port work status failed.", (long)1073948481L, (String[])new String[0], (Log)LOGGER);
        }
        operationResult = new OperationResult("ism.business.replication.changeLogicalPortWorkStatus", true, true, new String[]{devSn});
        LOGGER.info((Object)"Change remote logical port work status successfully, devSn:%s, pairId:%s", new Object[]{devSn, pair.getVstorePairId()});
        return operationResult;
    }

    private void isolateByLocal(String localDevSn, RemoteLinkDevice remoteLinkDevice) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("NET_ISOLATION", String.valueOf(remoteLinkDevice.getNetIsolation()));
        long startTime = System.currentTimeMillis();
        try {
            String url = "/rest/${deviceID}/remote_device/" + remoteLinkDevice.getDeviceId();
            this.getConnection(localDevSn).put(url, paramMap);
            long endTime = System.currentTimeMillis();
            LOGGER.info((Object)"Isolate alarm by local success, isolation value: %s, localDevSn=%s, use time=%s", new Object[]{remoteLinkDevice.getNetIsolation(), localDevSn, endTime - startTime});
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Isolate alarm by local failed. localDevSn: %s", new Object[]{localDevSn, e});
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)("Isolate alarm by local failed. localDevSn:" + localDevSn), (long)1073948770L, (String[])new String[0], (Log)LOGGER);
        }
    }

    private void isolateByExecRemoteDevice(String devSn, RemoteLinkDevice remoteLinkDevice) {
        List<Map<String, String>> results = this.getDeviceInfosByRemote(devSn, remoteLinkDevice);
        if (CollectionUtils.isEmpty(results)) {
            LOGGER.error((Object)"Not find infos by exec remote url, remote esn: %s, check!!!", new Object[]{remoteLinkDevice.getEsn()});
            return;
        }
        String deviceId = "";
        String localWwn = remoteLinkDevice.getLocalWwn();
        for (Map<String, String> record : results) {
            String remoteWWN = record.get("WWN");
            if (!localWwn.equals(remoteWWN)) continue;
            deviceId = record.get("ID");
            break;
        }
        if (VerifyUtil.isEmpty((String)deviceId)) {
            LOGGER.error((Object)"Error to find device ID on remote.");
            throw new LegoCheckedException(1073947394L);
        }
        LOGGER.info((Object)"Get remote ID: %s on remote device.", new Object[]{deviceId});
        this.doIsolateOnRemote(devSn, remoteLinkDevice, deviceId);
    }

    private void doIsolateOnRemote(String localDevSn, RemoteLinkDevice remoteLinkDevice, String remoteDeviceId) {
        remoteLinkDevice.setLocalDevSn(localDevSn);
        String execUrl = "/deviceManager/rest/xxx/remote_device/" + remoteDeviceId;
        JSONObject execParams = new JSONObject();
        execParams.put((Object)"NET_ISOLATION", (Object)remoteLinkDevice.getNetIsolation());
        long startTime = System.currentTimeMillis();
        try {
            this.executeCommandsOnRemoteDevice(remoteLinkDevice, execUrl, "PUT", execParams);
            long endTime = System.currentTimeMillis();
            LOGGER.info((Object)"Succeeded in exec isolation alarm on the remote device. use time=%s, isolation flag: %s", new Object[]{String.valueOf(endTime - startTime), remoteLinkDevice.getNetIsolation()});
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Exec isolation alarm on remote execute failed.", (Throwable)e);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Exec isolation alarm on remote execute failed.", (long)1073948770L, (String[])new String[0], (Log)LOGGER);
        }
    }

    public boolean checkRemoteLunMappedByIds(String localDevSn, String remoteDeviceId, List<String> lunIds) {
        for (String lunId : lunIds) {
            if (this.checkRemoteLunMapped(localDevSn, remoteDeviceId, lunId)) {
                return true;
            }
            CommUtil.pauseThread((long)2000L);
        }
        return false;
    }

    private boolean checkRemoteLunMapped(String localDevSn, String remoteDeviceId, String lunId) {
        String execUrl = "/deviceManager/rest/xxx/lun/" + lunId;
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("device_id", remoteDeviceId);
        paramMap.put("url", execUrl);
        paramMap.put("method", "GET");
        paramMap.put("body", (String)new JSONObject());
        List resultMapList = new ArrayList();
        long startTime = System.currentTimeMillis();
        try {
            resultMapList = this.getConnection(localDevSn).getBatchByPipeQuery("/api/v2/remote_execute", paramMap);
            long endTime = System.currentTimeMillis();
            LOGGER.info((Object)"Succeeded in get lun from the remote device. use time=%s, size: %s", new Object[]{String.valueOf(endTime - startTime), resultMapList.size()});
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Get info by remote execute failed.", (Throwable)e);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Get info by remote execute failed.", (long)1073948770L, (String[])new String[0], (Log)LOGGER);
        }
        for (Map record : resultMapList) {
            String mapped = (String)record.get("mapped");
            if (!Objects.equals(mapped, "true")) continue;
            return true;
        }
        return false;
    }

    private List<Map<String, String>> getDeviceInfosByRemote(String devSn, RemoteLinkDevice remoteLinkDevice) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String execUrl = "/deviceManager/rest/xxx/remote_device";
        paramMap.put("device_id", remoteLinkDevice.getDeviceId());
        paramMap.put("url", execUrl);
        paramMap.put("method", "GET");
        paramMap.put("body", (String)new JSONObject());
        ArrayList<Map<String, String>> resultMapList = new ArrayList();
        long startTime = System.currentTimeMillis();
        try {
            resultMapList = this.getConnection(devSn).getBatchByPipeQuery("/api/v2/remote_execute", paramMap);
            long endTime = System.currentTimeMillis();
            LOGGER.info((Object)"Succeeded in obtaining device information from the remote device. use time=%s", new Object[]{String.valueOf(endTime - startTime)});
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Get info by remote execute failed.", (Throwable)e);
            throw new LegoCheckedException(e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            ExceptionUtil.rethrowException((Throwable)e, (String)"Get info by remote execute failed.", (long)1073948770L, (String[])new String[0], (Log)LOGGER);
        }
        return resultMapList;
    }

    private Optional<RemoteLinkDevice> getSpecificRemoteLinkDevice(String devSn, String remoteDevSn) {
        IStoragePortLinksManager mgr = StoragePortLinksManagerProxy.getInstance().getStoragePortLinksMgrByDevId(devSn);
        List remoteDevices = mgr.getStorageRemoteDeviceByRemoteSn(devSn, remoteDevSn);
        if (VerifyUtil.isEmpty((Collection)remoteDevices)) {
            return Optional.empty();
        }
        for (RemoteLinkDevice remoteDevice : remoteDevices) {
            if (!remoteDevSn.equals(remoteDevice.getEsn())) continue;
            return Optional.of(remoteDevice);
        }
        return Optional.empty();
    }

    private Map<String, String> executeCommandsOnRemoteDevice(RemoteLinkDevice remoteLinkDevice, String execUrl, String execMethod, JSONObject execParams) {
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("device_id", remoteLinkDevice.getDeviceId());
        paramMap.put("url", execUrl);
        paramMap.put("method", execMethod);
        paramMap.put("body", (String)execParams);
        long startTime = System.currentTimeMillis();
        Map result = this.getConnection(remoteLinkDevice.getLocalDevSn()).postByPipe("/api/v2/remote_execute", paramMap, true);
        long endTime = System.currentTimeMillis();
        LOGGER.info((Object)"Execute commands{%s} on remote device{%s} successfully! use time=%s", new Object[]{execUrl, remoteLinkDevice.getEsn(), String.valueOf(endTime - startTime)});
        return result;
    }
}

