/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.ArrayHost;
import com.huawei.ism.array.sdk.model.ArrayHostGroup;
import com.huawei.ism.array.sdk.model.Mapping;
import com.huawei.ism.array.sdk.model.MappingView;
import com.huawei.ism.array.sdk.model.XveLunGroup;
import com.huawei.ism.base.sdk.model.Initiator;
import com.huawei.ism.cbb.proxy.xve.XveEnumDefinePParent;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.recovery.sdk.model.HostGroupVO;
import com.huawei.ism.drm.recovery.sdk.model.HostVO;
import com.huawei.ism.drm.storage.handler.IStorageHostHandler;
import com.huawei.ism.drm.storage.handler.IStorageInitiatorHandler;
import com.huawei.ism.drm.storage.handler.IStorageLunHandler;
import com.huawei.ism.drm.storage.handler.IStorageMappingHandler;
import com.huawei.ism.drm.storage.hvs.manager.RestStorageHandlerManager;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

abstract class BaseHvsStorageManager {
    private static Log logger = LogFactory.getInstance(BaseHvsStorageManager.class);
    private static final int MAPPING_STATE_NO = 1;
    private static final int MAPPING_STATE_PARTIAL = 2;
    private static final int MAPPING_STATE_UNAVAILABLE = 4;
    private static final int MAPPING_STATE_ALL = 8;

    BaseHvsStorageManager() {
    }

    private List<Initiator> queryInitiators(String devSn, HostVO hostVo) {
        List initsFromAgent = hostVo.getInitiators();
        if (null == initsFromAgent || initsFromAgent.isEmpty()) {
            logger.error((Object)("There is no initiator info from agent: " + hostVo.getIpAddress()));
            throw new LegoCheckedException(1073947443L, new String[]{hostVo.getIpAddress()});
        }
        StringBuilder sb = new StringBuilder();
        sb.append("Initiators from agent[").append(hostVo.getName()).append("]: ");
        for (Initiator initiator : initsFromAgent) {
            sb.append(initiator.getHbaType()).append("=").append(initiator.getIdentity()).append("; ");
        }
        logger.info((Object)sb.toString());
        ArrayList<Initiator> initsRealTime = new ArrayList<Initiator>();
        boolean available = false;
        IStorageInitiatorHandler initiatorHandler = RestStorageHandlerManager.getInstance().getInitiatorHandler();
        if (null == initiatorHandler) {
            logger.error((Object)("queryInitiators faild, getInitiatorHandler is null, devSn:" + devSn));
            throw new LegoCheckedException(1073947395L);
        }
        for (Initiator initiator : initsFromAgent) {
            String type = initiator.getHbaType();
            String identity = initiator.getIdentity();
            try {
                logger.info((Object)("Query initiator ifo, type=" + type + ", id=" + identity));
                Initiator realInfo = initiatorHandler.queryInitiator(devSn, initiator);
                logger.info((Object)("RealInfo=" + realInfo));
                if (null == realInfo) continue;
                initsRealTime.add(realInfo);
                if (realInfo.getRunningStatus() != 0) continue;
                available = true;
            }
            catch (Exception e) {
                logger.error((Object)("Query realtime initiator info failed. " + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
        if (initsRealTime.isEmpty()) {
            logger.error((Object)("No initiator found from storage device, check whether initiators on the host are connected. " + hostVo.getName()));
            throw new LegoCheckedException(1073948684L);
        }
        if (!available) {
            logger.error((Object)("No online initiator on the storage device from the host. " + hostVo.getName()));
            throw new LegoCheckedException(1073947444L);
        }
        return initsRealTime;
    }

    protected List<ArrayHost> prepareHosts(String devSn, HostVO hostVo, boolean strict) {
        List<Initiator> inits = this.queryInitiators(devSn, hostVo);
        HashMap<String, ArrayHost> hosts = new HashMap<String, ArrayHost>();
        ArrayList<Initiator> initsFree = new ArrayList<Initiator>();
        ArrayHost commonHost = null;
        IStorageHostHandler hostHandler = this.getHandlerMgr().getHostHandler();
        if (null == hostHandler) {
            logger.error((Object)("prepareHosts failed, gethostHandler is null, devSn:" + devSn));
            throw new LegoCheckedException(1073947395L);
        }
        for (Initiator init : inits) {
            if (init.getIsFree().booleanValue()) {
                initsFree.add(init);
                continue;
            }
            ArrayHost host = hostHandler.queryHost(devSn, init);
            if (null == host) {
                logger.error((Object)("The initiator is abnormal. " + init));
                initsFree.add(init);
                continue;
            }
            hosts.put(host.getHostId(), host);
            commonHost = host;
        }
        if (strict && hosts.size() > 1) {
            logger.error((Object)("In strict mode, but more than one host, " + hosts));
            throw new LegoCheckedException(1073947446L);
        }
        if (null == commonHost) {
            String hostName = "RD_Host_" + System.currentTimeMillis();
            String desc = hostVo.getName();
            String ip = hostVo.getIpAddress();
            int osType = hostVo.getOsType();
            osType = XveEnumDefinePParent.OS_TYPE_E.valueOf((int)osType) == null ? XveEnumDefinePParent.OS_TYPE_E.Linux.getValue() : osType;
            logger.info((Object)("Create Host, name=" + hostName + ", os=" + osType + ", ip=" + ip));
            commonHost = hostHandler.createHost(devSn, hostName, osType, desc, ip);
            hosts.put(commonHost.getHostId(), commonHost);
        }
        logger.info((Object)("Hit Host, id=" + commonHost.getHostId() + ", name=" + commonHost.getName()));
        IStorageInitiatorHandler initiatorHandler = RestStorageHandlerManager.getInstance().getInitiatorHandler();
        if (null == initiatorHandler) {
            logger.error((Object)("prepareHosts failed, getInitiatorHandler is null, devSn:" + devSn));
            throw new LegoCheckedException(1073947395L);
        }
        for (Initiator init : initsFree) {
            XveMOType initiatorType = XveMOType.FC_INITIATOR;
            if ("ISCSI".equals(init.getHbaType())) {
                initiatorType = XveMOType.ISCSI_INITIATOR;
            }
            initiatorHandler.addInitiatorToHost(devSn, commonHost.getHostId(), initiatorType, init.getIdentity());
            logger.info((Object)("add init [" + init + "] to host [" + commonHost + "]"));
        }
        return Arrays.asList(hosts.values().toArray(new ArrayHost[hosts.size()]));
    }

    protected ArrayHostGroup prepareHostGroup(String devSn, List<ArrayHost> hosts) {
        HashMap<String, ArrayHostGroup> hgs = new HashMap<String, ArrayHostGroup>();
        IStorageHostHandler hostHandler = this.getHandlerMgr().getHostHandler();
        if (null == hostHandler) {
            logger.error((Object)"hostHandler  is null.");
            throw new LegoCheckedException(1073947395L);
        }
        for (ArrayHost host : hosts) {
            List realHostGroups = hostHandler.queryHostGroups(devSn, XveMOType.HOST, host.getHostId());
            Iterator iterator = realHostGroups.iterator();
            while (iterator.hasNext()) {
                ArrayHostGroup realHostGroup = (ArrayHostGroup)iterator.next();
                hgs.put(realHostGroup.getHostGroupId(), realHostGroup);
            }
        }
        ArrayHostGroup hitHg = null;
        int tempLevel = -1;
        for (ArrayHostGroup hostGroup : hgs.values()) {
            int level = this.getCandidateLevel(devSn, hostGroup, hosts);
            if (level > tempLevel) {
                tempLevel = level;
                hitHg = hostGroup;
            }
            if (2 != tempLevel) continue;
            break;
        }
        if (null == hitHg) {
            String hgName = "RD_HG_" + System.currentTimeMillis();
            logger.info((Object)("Create HG, name=" + hgName), 90160758784000L);
            hitHg = hostHandler.createHostGroup(devSn, hgName, "");
        }
        if (2 != tempLevel) {
            for (ArrayHost host : hosts) {
                logger.info((Object)("Add Host to HG, hostId=" + host.getHostId() + ", hgId=" + hitHg.getHostGroupId()), 90160758784000L);
                hostHandler.addHostToHostGroup(devSn, hitHg.getHostGroupId(), host.getHostId());
            }
        }
        logger.info((Object)("Hit HG, id=" + hitHg.getHostGroupId() + ", name=" + hitHg.getName()), 90160758784000L);
        return hitHg;
    }

    private int getCandidateLevel(String devSn, ArrayHostGroup hg, List<ArrayHost> hosts) {
        IStorageHostHandler hostHandler = this.getHandlerMgr().getHostHandler();
        if (null == hostHandler) {
            logger.error((Object)("getCandidateLevel failed, get host handler is null, devSn: " + devSn));
            throw new LegoCheckedException(1073947395L);
        }
        List realHosts = hostHandler.queryHostsByHostGroup(devSn, hg.getHostGroupId());
        if (VerifyUtil.isEmpty((Collection)realHosts)) {
            return 0;
        }
        if (realHosts.size() > hosts.size()) {
            return -1;
        }
        for (ArrayHost arrayHost : realHosts) {
            boolean find = false;
            for (ArrayHost host : hosts) {
                if (!arrayHost.getHostId().equals(host.getHostId())) continue;
                find = true;
                break;
            }
            if (find) continue;
            return -1;
        }
        if (realHosts.size() == hosts.size()) {
            return 2;
        }
        return 1;
    }

    private MappingView intersectionMappingView(List<MappingView> hgMvs, List<MappingView> resMvs) {
        MappingView mv = null;
        logger.info((Object)("MV associated with HG, size=" + hgMvs.size()), 90160758784000L);
        logger.info((Object)("MV associated with Resource, size=" + resMvs.size()), 90160758784000L);
        if (VerifyUtil.isEmpty(hgMvs)) {
            logger.info((Object)"hgMvs is empty, return null", 90160758784000L);
            return null;
        }
        if (VerifyUtil.isEmpty(resMvs)) {
            logger.info((Object)"resMvs is empty, select the first one from hgMvs", 90160758784000L);
            return hgMvs.get(0);
        }
        for (MappingView hgMv : hgMvs) {
            for (MappingView resMv : resMvs) {
                if (!hgMv.getMappingViewId().equals(resMv.getMappingViewId())) continue;
                mv = hgMv;
                break;
            }
            if (null == mv) continue;
            logger.info((Object)("Intersect a MV, id=" + mv.getMappingViewId() + ", name=" + mv.getName()), 90160758784000L);
            break;
        }
        if (null == mv) {
            mv = hgMvs.get(0);
            logger.info((Object)("Intersect a MV, id=" + mv.getMappingViewId() + ", name=" + mv.getName()), 90160758784000L);
        }
        return mv;
    }

    protected MappingView prepareMappingView(String devSn, String hostGroupId, XveMOType resourceType, String resourceId) {
        List lunMvs;
        IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
        List hgMvs = mappingHandler.queryMappingView(devSn, XveMOType.HOSTGROUP, hostGroupId);
        MappingView mv = this.intersectionMappingView(hgMvs, lunMvs = mappingHandler.queryMappingView(devSn, resourceType, resourceId));
        if (null == mv) {
            mv = this.prepareMappingViewByHg(devSn, hostGroupId);
        }
        logger.info((Object)("Hit MV, id=" + mv.getMappingViewId() + ", name=" + mv.getName()));
        return mv;
    }

    protected MappingView prepareMappingViewByHg(String devSn, String hostGroupId) {
        IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
        List hgMvs = mappingHandler.queryMappingView(devSn, XveMOType.HOSTGROUP, hostGroupId);
        MappingView mv = null;
        if (!VerifyUtil.isEmpty((Collection)hgMvs)) {
            IStorageLunHandler lunHandler = this.getHandlerMgr().getLunHandler();
            if (null == lunHandler) {
                logger.error((Object)("getLunHandler is empty, devSn=" + devSn));
                throw new LegoCheckedException(1073947395L);
            }
            for (MappingView mappingView : hgMvs) {
                String mvId = mappingView.getMappingViewId();
                List lunGroups = lunHandler.queryLunGroups(devSn, XveMOType.MAPPINGVIEW, mvId);
                if (VerifyUtil.isEmpty((Collection)lunGroups)) continue;
                mv = mappingView;
                break;
            }
            if (null == mv) {
                mv = (MappingView)hgMvs.get(0);
            }
        }
        if (null == mv) {
            String mvName = "RD_MV_" + System.currentTimeMillis();
            logger.info((Object)("Create MV, name=" + mvName), 90160758784000L);
            mv = mappingHandler.createMappingView(devSn, mvName, null);
            logger.info((Object)("Add HG to MV, hgId=" + hostGroupId + ", mvId=" + mv.getMappingViewId()), 90160758784000L);
            mappingHandler.addObjectToMappingView(devSn, mv.getMappingViewId(), XveMOType.HOSTGROUP, hostGroupId);
        }
        logger.info((Object)("Hit MV, id=" + mv.getMappingViewId() + ", name=" + mv.getName()));
        return mv;
    }

    protected XveLunGroup prepareLunGroup(String devSn, MappingView mv) {
        XveLunGroup lg;
        String mvId = mv.getMappingViewId();
        IStorageLunHandler lunHandler = this.getHandlerMgr().getLunHandler();
        if (null == lunHandler) {
            logger.error((Object)("getLunHandler is empty, devSn=" + devSn));
            throw new LegoCheckedException(1073947395L);
        }
        List lunGroups = lunHandler.queryLunGroups(devSn, XveMOType.MAPPINGVIEW, mvId);
        logger.info((Object)("LunGroup associated with MappingView, mvId=" + mvId + ", lgSize=" + lunGroups.size()), 90160758784000L);
        if (VerifyUtil.isEmpty((Collection)lunGroups)) {
            String lgName = "RD_LG_" + System.currentTimeMillis();
            logger.info((Object)("Create LG, name=" + lgName), 90160758784000L);
            lg = lunHandler.createLunGroup(devSn, lgName);
            logger.info((Object)("Associate LunGroup to MappingView, lgId=" + lg.getLunGroupId() + ", mvId=" + mvId), 90160758784000L);
            this.getHandlerMgr().getMappingHandler().addObjectToMappingView(devSn, mvId, XveMOType.LUNGROUP, lg.getLunGroupId());
        } else {
            lg = (XveLunGroup)lunGroups.get(0);
        }
        logger.info((Object)("Hit LG, id=" + lg.getLunGroupId() + ", name=" + lg.getName()), 90160758784000L);
        return lg;
    }

    protected OperationResult generateOperationResult(LegoCheckedException e, String operationName, String[] successParameters) {
        OperationResult operationResult = 1077951827L != e.getErrorCode() ? new OperationResult(operationName, true, false, String.valueOf(e.getErrorCode()), e.getParameters()) : new OperationResult(operationName, true, true, successParameters);
        return operationResult;
    }

    public boolean isMapping(String devSn, XveMOType resourceType, String resourceId, List<HostVO> hostVos) {
        if (!this.isResourceMapped(devSn, resourceId)) {
            return false;
        }
        HashMap<String, List<Initiator>> drHost2RealTimeInitsMap = new HashMap<String, List<Initiator>>();
        for (HostVO hostVo : hostVos) {
            List<Initiator> temp = this.queryInitiators(devSn, hostVo);
            drHost2RealTimeInitsMap.put(hostVo.getId(), temp);
        }
        IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
        List lunMvs = mappingHandler.queryMappingView(devSn, resourceType, resourceId);
        if (VerifyUtil.isEmpty((Collection)lunMvs)) {
            logger.debug((Object)"MappingView queried through resource is empty.");
            return false;
        }
        ArrayList hgsRealtime = new ArrayList();
        IStorageHostHandler hostHandler = this.getHandlerMgr().getHostHandler();
        if (null == hostHandler) {
            logger.error((Object)("hostHandler is null!devSn: " + devSn + ",type: " + resourceType + ",srouceid: " + resourceId));
            throw new LegoCheckedException(1073947395L);
        }
        for (Object lunMv : lunMvs) {
            List hgsByMvRealTime = hostHandler.queryHostGroups(devSn, XveMOType.MAPPINGVIEW, lunMv.getMappingViewId());
            hgsRealtime.addAll(hgsByMvRealTime);
        }
        ArrayList<ArrayHost> hosts = new ArrayList<ArrayHost>();
        for (ArrayHostGroup hg : hgsRealtime) {
            hosts.addAll(hostHandler.queryHostsByHostGroup(devSn, hg.getHostGroupId()));
        }
        this.addLunMappedHost(devSn, resourceType, resourceId, hosts);
        if (hosts.isEmpty()) {
            logger.debug((Object)"HostGroup queried through resource is empty.");
            return false;
        }
        ArrayList<Initiator> initsRealTime = new ArrayList<Initiator>(this.queryHostVoInitiators(devSn, hosts));
        if (initsRealTime.isEmpty()) {
            logger.debug((Object)"Initiator queried through resource is empty.");
            return false;
        }
        int mappingState = this.calcMappingState(initsRealTime, drHost2RealTimeInitsMap);
        return this.parseMappingState(mappingState);
    }

    private void addLunMappedHost(String devSn, XveMOType resourceType, String resourceId, List<ArrayHost> hosts) {
        try {
            IStorageMappingHandler mappingHandler = this.getHandlerMgr().getMappingHandler();
            List mappings = mappingHandler.getMapping(devSn, resourceType, resourceId);
            IStorageHostHandler hostHandler = this.getHandlerMgr().getHostHandler();
            for (Mapping mapping : mappings) {
                ArrayHost host;
                String hostId = mapping.getHostId();
                if (VerifyUtil.isEmpty((String)hostId) || VerifyUtil.isEmpty((Object)(host = hostHandler.queryHost(devSn, hostId))) || hosts.contains(host)) continue;
                hosts.add(host);
            }
        }
        catch (Exception e) {
            logger.warn((Object)"this api only support on dorado v6, plz check it. devSn:%s", new Object[]{devSn});
        }
    }

    private List<Initiator> queryHostVoInitiators(String devSn, List<ArrayHost> hosts) {
        IStorageInitiatorHandler initiatorHandler = RestStorageHandlerManager.getInstance().getInitiatorHandler();
        if (null == initiatorHandler) {
            logger.error((Object)("initiatorHandler is null!devSn: " + devSn));
            throw new LegoCheckedException(1073947395L);
        }
        ArrayList<Initiator> initsRealTime = new ArrayList<Initiator>();
        for (ArrayHost host : hosts) {
            List temp = initiatorHandler.queryInitiatorsByHost(devSn, host.getHostId());
            initsRealTime.addAll(temp);
        }
        return initsRealTime;
    }

    private int calcMappingState(List<Initiator> initsRealTime, Map<String, List<Initiator>> drHost2RealTimeInitsMap) {
        int mappingState = 0;
        Set<Map.Entry<String, List<Initiator>>> entrySet = drHost2RealTimeInitsMap.entrySet();
        for (Map.Entry<String, List<Initiator>> entry : entrySet) {
            String hostSn = entry.getKey();
            logger.info((Object)("check drHost=" + hostSn));
            List<Initiator> drHostInits = entry.getValue();
            if (initsRealTime.containsAll(drHostInits)) {
                logger.info((Object)"Contain all.");
                mappingState |= 8;
                continue;
            }
            boolean isContain = false;
            boolean isAvailable = false;
            for (Initiator init : drHostInits) {
                if (!initsRealTime.contains(init)) continue;
                isContain = true;
                if (init.getRunningStatus() != 0) continue;
                isAvailable = true;
            }
            if (isContain) {
                if (isAvailable) {
                    logger.info((Object)"Contain partial.");
                    mappingState |= 2;
                    continue;
                }
                logger.info((Object)"Contain, but unavailable.");
                mappingState |= 4;
                continue;
            }
            logger.info((Object)"Contain no.");
            mappingState |= 1;
        }
        logger.info((Object)("Contain resut=" + mappingState));
        return mappingState;
    }

    public boolean parseMappingState(int mappingState) {
        if ((4 & mappingState) > 0) {
            logger.error((Object)("the mapping is available. " + mappingState));
            throw new LegoCheckedException(1073947445L);
        }
        if (1 == mappingState) {
            return false;
        }
        if (8 == mappingState || 2 == mappingState) {
            return true;
        }
        if ((1 & mappingState) > 0) {
            logger.error((Object)("There is part mapping, " + mappingState));
            throw new LegoCheckedException(1073947442L);
        }
        return true;
    }

    public String prepareMapping(String devSn, HostVO hostVo) {
        logger.info((Object)("Enter prepareMapping, sn=" + devSn));
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (null == hostVo) {
            logger.error((Object)"hostVo is null.");
            throw new LegoCheckedException(1073947393L);
        }
        List<ArrayHost> hosts = this.prepareHosts(devSn, hostVo, false);
        ArrayHostGroup hg = this.prepareHostGroup(devSn, hosts);
        MappingView mv = this.prepareMappingViewByHg(devSn, hg.getHostGroupId());
        XveLunGroup lunGroup = this.prepareLunGroup(devSn, mv);
        if (VerifyUtil.isEmpty((Object)lunGroup)) {
            logger.error((Object)"lunGroup is empty!");
            return null;
        }
        logger.info((Object)("End prepareMapping, sn=" + devSn));
        return lunGroup.getLunGroupId();
    }

    public String prepareMapping(String devSn, HostGroupVO hostGroupVo) {
        logger.info((Object)("Enter prepareMapping, HostGroup, sn=" + devSn));
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (null == hostGroupVo) {
            logger.error((Object)"hostGroupVo is null.");
            throw new LegoCheckedException(1073947393L);
        }
        ArrayList<ArrayHost> hosts = new ArrayList<ArrayHost>();
        for (HostVO hostVo : hostGroupVo.getHostVOs()) {
            List<ArrayHost> temp = this.prepareHosts(devSn, hostVo, false);
            hosts.addAll(temp);
        }
        ArrayHostGroup hg = this.prepareHostGroup(devSn, hosts);
        MappingView mv = this.prepareMappingViewByHg(devSn, hg.getHostGroupId());
        XveLunGroup lunGroup = this.prepareLunGroup(devSn, mv);
        if (VerifyUtil.isEmpty((Object)lunGroup)) {
            logger.error((Object)"lunGroup is empty!");
            return null;
        }
        logger.info((Object)("End prepareMapping, HostGroup, sn=" + devSn));
        return lunGroup.getLunGroupId();
    }

    protected RestStorageHandlerManager getHandlerMgr() {
        return RestStorageHandlerManager.getInstance();
    }

    protected abstract boolean isResourceMapped(String var1, String var2);
}

