/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.storage.handler.IStorageSnapshotScheduleHandler;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageSnapshotScheduleManager;
import com.huawei.ism.drm.storage.sdk.model.SnapshotSchedule;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class BaseHvsStorageSnapshotScheduleManager
implements IStorageSnapshotScheduleManager {
    private static Log logger = LogFactory.getInstance(BaseHvsStorageSnapshotScheduleManager.class);
    private IStorageSnapshotScheduleHandler snapshotScheduleHandler;

    public void enable(String devSn, String scheduleId, boolean enable) {
        SnapshotSchedule schedule = this.snapshotScheduleHandler.query(devSn, scheduleId);
        if (null == schedule) {
            logger.error((Object)"addLun to snapshotSchedule error, schedule not exists.");
            throw new LegoCheckedException(1073947393L);
        }
        if (schedule.getEnableSchedule() != enable) {
            this.snapshotScheduleHandler.enable(schedule.getDevSn(), schedule.getId(), schedule.getScheduleType(), enable);
        }
    }

    public SnapshotSchedule query(String devSn, String scheduleId) {
        return this.snapshotScheduleHandler.query(devSn, scheduleId);
    }

    public Integer count(String devSn, int type) {
        return this.snapshotScheduleHandler.count(devSn, type);
    }

    public Set<String> getProtectGroupSnapshotIds(ProtectGroup protectGroup, String devSn, Schedule schedule) {
        return null;
    }

    public String getStorageType() {
        return HvsUnit.class.getName();
    }

    public void setSnapshotScheduleHandler(IStorageSnapshotScheduleHandler handler) {
        this.snapshotScheduleHandler = handler;
    }

    protected void transformTimeStamp(List<ProtectGroupReplica> list) {
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(list)) {
            logger.error((Object)"protectgroupReplica list is empty.");
            return;
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        for (ProtectGroupReplica replica : list) {
            try {
                String devSn = replica.getStorageDeviceId();
                Long offset = (Long)map.get(devSn);
                if (null == offset) {
                    offset = this.getSystemTimeZoneInfo(devSn);
                    map.put(devSn, offset);
                }
                long timeStamp = Long.parseLong(replica.getTimeStamp());
                timeStamp = timeStamp * 1000L - offset;
                logger.debug((Object)("devSn:" + devSn + ", offset:" + offset));
                replica.setTimeStamp(String.valueOf(timeStamp));
            }
            catch (Exception e) {
                logger.error((Object)("setTimeStamp error." + ExceptionUtil.getErrorMessage((Throwable)e)));
            }
        }
    }

    private long getSystemTimeZoneInfo(String devSn) {
        long offset = 0L;
        String url = "/rest/${deviceID}/system_timezone";
        try {
            RestConnection connection = this.getConnection(devSn);
            logger.debug((Object)"Get systemTimeZone: url = %s", new Object[]{url});
            Map resultMap = connection.get(url, null);
            if (!VerifyUtil.isEmpty((Map)resultMap)) {
                logger.debug((Object)"Get url = %s, resultMap = %s", new Object[]{url, resultMap});
                String timeZone = (String)resultMap.get("CMO_SYS_TIME_ZONE");
                if (VerifyUtil.isEmpty((String)timeZone)) {
                    logger.warn((Object)"timeZoneName is empty!");
                    return offset;
                }
                String hourStr = timeZone.split(":")[0];
                long hour = Long.parseLong(hourStr);
                return 3600000L * hour;
            }
        }
        catch (Exception e) {
            logger.error((Object)"getSystemTimeZoneInfo error. url = %s, error msg = %s", new Object[]{url, ExceptionUtil.getErrorMessage((Throwable)e)});
        }
        return offset;
    }

    protected RestConnection getConnection(String devSn) {
        RestConnection connection = RestConnectionManager.getInstance().getConnection(devSn);
        if (null == connection) {
            logger.error((Object)("The connection does not exist. sn=" + devSn));
            throw new LegoCheckedException(1073947649L);
        }
        return connection;
    }
}

