/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.storage.handler.IStorageHyperCDPHandler;
import com.huawei.ism.drm.storage.hvs.manager.BaseHvsStorageManager;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperCDPManager;
import com.huawei.ism.drm.storage.sdk.model.HyperCDP;
import com.huawei.ism.drm.storage.sdk.model.SecureSnapParam;
import com.huawei.ism.drm.storage.sdk.model.Snapshot;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.exception.LegoUnsupportedOperationException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.List;

public class HvsStorageHyperCDPManager
extends BaseHvsStorageManager
implements IStorageHyperCDPManager {
    private static final Log LOGGER = LogFactory.getInstance(HvsStorageHyperCDPManager.class);
    private IStorageHyperCDPHandler hyperCDPHandler;

    public IStorageHyperCDPHandler getHyperCDPHandler() {
        return this.hyperCDPHandler;
    }

    public void setHyperCDPHandler(IStorageHyperCDPHandler hyperCDPHandler) {
        this.hyperCDPHandler = hyperCDPHandler;
    }

    @Override
    protected boolean isResourceMapped(String devSn, String resourceId) {
        LOGGER.warn((Object)("not supported!devSn:" + devSn));
        throw new LegoUnsupportedOperationException("not supported.");
    }

    public String getStorageType() {
        return HvsUnit.class.getName();
    }

    public HyperCDP getHyperCDPById(String devSn, String hyperCDPId) {
        return this.hyperCDPHandler.query(devSn, hyperCDPId);
    }

    public List<HyperCDP> getHyperCDPByCGId(String devSn, String cgId) {
        return this.hyperCDPHandler.queryHyperCDPByCgId(devSn, cgId);
    }

    public HyperCDP createCdpSecureSnapshot(String devSn, String parentId, SecureSnapParam secureSnapParam) {
        return this.hyperCDPHandler.createCdpSecureSnapshot(devSn, parentId, secureSnapParam);
    }

    public OperationResult restoreSnapshot(String deviceSN, Snapshot snapshot, String restoreSpeed) {
        OperationResult operationResult;
        try {
            this.hyperCDPHandler.restoreSnapshot(deviceSN, String.valueOf(snapshot.getSnapshotId()), restoreSpeed);
            operationResult = new OperationResult("ism.drm.restore.snapshot.operation", true, true, new String[]{snapshot.getSnapshotName()});
        }
        catch (LegoCheckedException e) {
            LOGGER.error((Object)"Restore snapshot failed. SnapshotId: %s, SnapshotName: %s, errorMsg: %s", new Object[]{snapshot.getSnapshotId(), snapshot.getSnapshotName(), ExceptionUtil.getErrorMessage((Throwable)e)});
            operationResult = new OperationResult("ism.drm.restore.snapshot.operation", true, false, String.valueOf(e.getErrorCode()), e.getParameters());
        }
        return operationResult;
    }
}

