/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.cbb.proxy.xve.XveMOType;
import com.huawei.ism.cbb.util.VerifyUtil;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.constant.ReplicaMountStatus;
import com.huawei.ism.drm.drp.sdk.service.IRecoveryResourceService;
import com.huawei.ism.drm.protection.framework.service.replica.realtime.service.ExecuteReplicaManager;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.group.sdk.service.IProtectGroupService;
import com.huawei.ism.drm.protection.replica.sdk.model.LocalStorageReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.schedule.sdk.model.RetentionPolicy;
import com.huawei.ism.drm.protection.schedule.sdk.model.Schedule;
import com.huawei.ism.drm.storage.handler.IStorageLunConsistencyGroupHandler;
import com.huawei.ism.drm.storage.handler.IStorageLunHandler;
import com.huawei.ism.drm.storage.handler.IStorageSnapshotScheduleHandler;
import com.huawei.ism.drm.storage.hvs.manager.BaseHvsStorageSnapshotScheduleManager;
import com.huawei.ism.drm.storage.manager.proxy.StorageHyperCDPGroupManagerProxy;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageHyperCDPGroupManager;
import com.huawei.ism.drm.storage.sdk.model.HyperCDPConsistencyGroup;
import com.huawei.ism.drm.storage.sdk.model.LunConsistencyGroup;
import com.huawei.ism.drm.storage.sdk.model.SnapshotSchedule;
import com.huawei.ism.drm.storage.util.SnapshotScheduleUtil;
import com.huawei.lego.core.sdk.common.ServiceLocator;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.NumberUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HvsStorageHyperCDPScheduleManager
extends BaseHvsStorageSnapshotScheduleManager {
    private static Log logger = LogFactory.getInstance(HvsStorageHyperCDPScheduleManager.class);
    private IStorageLunConsistencyGroupHandler lunConsistencyGroupHandler;
    private IStorageSnapshotScheduleHandler hyperCDPScheduleHandler;
    private IStorageLunHandler lunHandler;

    public SnapshotSchedule create(ProtectGroup protectGroup, Schedule schedule, String devSn, List<String> lunIds) {
        SnapshotSchedule newSnapshotSchedule = SnapshotScheduleUtil.constructNewHyperCDPSchedule((ProtectGroup)protectGroup, (String)devSn, (Schedule)schedule);
        SnapshotSchedule snapshotSchedule = null;
        boolean isNeedCreateLunCg = false;
        LunConsistencyGroup cg = null;
        try {
            snapshotSchedule = this.hyperCDPScheduleHandler.create(newSnapshotSchedule);
            snapshotSchedule.setScheduleType(SnapshotSchedule.SCHEDULE_TYPE.HYPERCDP.getValue());
            String cgName = "RD_CG_" + System.currentTimeMillis();
            LunConsistencyGroupResult result = this.createLunConsistencyGroup(protectGroup, devSn, cgName, newSnapshotSchedule.getDescription(), lunIds);
            cg = result.group;
            isNeedCreateLunCg = result.isCreate;
            if (null == cg) {
                logger.error((Object)"can not reuse lunCg, devSn:%s, lunIds:%s", new Object[]{devSn, lunIds.toString()});
                throw new LegoCheckedException(result.errorCode);
            }
            protectGroup.getProps().put("PROP_KEY_LUN_CG_KEY:" + devSn, cg.getId());
            this.hyperCDPScheduleHandler.addLunConsistencyGroupToHyperCDPSchedule(devSn, snapshotSchedule.getId(), cg.getId());
            if (!snapshotSchedule.getEnableSchedule().booleanValue()) {
                this.hyperCDPScheduleHandler.enable(devSn, snapshotSchedule.getId(), newSnapshotSchedule.getScheduleType(), true);
                snapshotSchedule.setEnableSchedule(Boolean.valueOf(true));
            }
            snapshotSchedule.setGroup(cg);
            return snapshotSchedule;
        }
        catch (LegoCheckedException e) {
            if (null == snapshotSchedule) {
                throw e;
            }
            if (null != cg) {
                this.removeLunCgFromHyperCDPSchedule(devSn, snapshotSchedule.getId(), cg.getId());
                if (isNeedCreateLunCg) {
                    this.delteLunConsistencyGroup(devSn, cg.getId());
                    protectGroup.getProps().remove("PROP_KEY_LUN_CG_KEY:" + devSn);
                }
            }
            this.hyperCDPScheduleHandler.delete(devSn, snapshotSchedule.getId(), snapshotSchedule.getScheduleType());
            throw e;
        }
    }

    private LunConsistencyGroupResult createLunConsistencyGroup(ProtectGroup pg, String devSn, String name, String desc, List<String> lunIds) {
        LunConsistencyGroupResult result = new LunConsistencyGroupResult();
        LunConsistencyGroup cg = null;
        try {
            String lunConsistencyGroupId = (String)pg.getProps().get("PROP_KEY_LUN_CG_KEY:" + devSn);
            if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)lunConsistencyGroupId)) {
                cg = this.lunConsistencyGroupHandler.queryConsistencyGroup(devSn, lunConsistencyGroupId);
                result.setGroup(cg);
                result.setCreate(false);
                return result;
            }
            IRecoveryResourceService recoveryService = (IRecoveryResourceService)ServiceLocator.getInstance().getService(IRecoveryResourceService.class);
            Lun lun = recoveryService.getTargetLunById(devSn, lunIds.get(0));
            String vstoreId = com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)lun.getVstoreId()) ? null : lun.getVstoreId();
            cg = this.lunConsistencyGroupHandler.createLunConsistencyGroup(devSn, name, desc, vstoreId);
            if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(lunIds)) {
                for (String lunId : lunIds) {
                    this.lunConsistencyGroupHandler.addLun(devSn, cg.getId(), lunId, vstoreId);
                    cg.getSrcLuns().add(lunId);
                }
            }
            result.setCreate(true);
        }
        catch (LegoCheckedException e) {
            if (e.getErrorCode() == 1073748827L) {
                String lunCgId;
                result.setCreate(false);
                if (cg != null) {
                    this.delteLunConsistencyGroup(devSn, cg.getId());
                    cg = null;
                }
                if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((String)(lunCgId = this.getLunConsistencyGroup(pg, devSn, lunIds)))) {
                    cg = this.lunConsistencyGroupHandler.queryConsistencyGroup(devSn, lunCgId);
                } else {
                    result.setErrorCode(e.getErrorCode());
                }
            }
            throw e;
        }
        result.setGroup(cg);
        return result;
    }

    private void delteLunConsistencyGroup(String devSn, String lunCgId) {
        List luns = this.lunHandler.queryLuns(devSn, XveMOType.LUN_CONSISTENCY_GROUP, lunCgId);
        luns.forEach(lun -> this.lunConsistencyGroupHandler.removeLun(devSn, lunCgId, lun.getLunId(), false));
        this.lunConsistencyGroupHandler.deleteConsistencyGroup(devSn, lunCgId);
    }

    public void addLun(String devSn, String lunCgId, List<String> lunIds) {
        Set<String> existLuns = this.getExistLunsByConsistencyGroupId(devSn, lunCgId);
        ArrayList<String> addSuccessedLuns = new ArrayList<String>();
        try {
            for (String lunId : lunIds) {
                if (existLuns.contains(devSn + ":" + lunId)) continue;
                this.lunConsistencyGroupHandler.addLun(devSn, lunCgId, lunId, null);
                addSuccessedLuns.add(lunId);
            }
        }
        catch (LegoCheckedException e) {
            if (!addSuccessedLuns.isEmpty()) {
                this.removeLun(devSn, lunCgId, addSuccessedLuns);
            }
            throw e;
        }
    }

    private Set<String> getExistLunsByConsistencyGroupId(String devSn, String consistencyGroupId) {
        List luns = this.lunHandler.queryLuns(devSn, XveMOType.LUN_CONSISTENCY_GROUP, consistencyGroupId);
        HashSet<String> existLuns = new HashSet<String>();
        if (null == luns) {
            return existLuns;
        }
        for (Lun lun : luns) {
            existLuns.add(lun.getDevSn() + ":" + lun.getLunId());
        }
        return existLuns;
    }

    public void removeLun(String devSn, String lunCgId, List<String> lunIds) {
        Set<String> existLuns = this.getExistLunsByConsistencyGroupId(devSn, lunCgId);
        for (String lunId : lunIds) {
            if (!existLuns.contains(devSn + ":" + lunId)) continue;
            this.lunConsistencyGroupHandler.removeLun(devSn, lunCgId, lunId, false);
        }
    }

    public void delete(String devSn, String scheduleId, String lunConsistencyGroupId) {
        LunConsistencyGroup lunCg;
        SnapshotSchedule schedule = this.hyperCDPScheduleHandler.query(devSn, scheduleId);
        if (null == schedule) {
            logger.error((Object)("snapshotSchedule is not exists. scheduleId:" + scheduleId));
            return;
        }
        if (schedule.getEnableSchedule().booleanValue()) {
            this.hyperCDPScheduleHandler.enable(devSn, scheduleId, schedule.getScheduleType(), false);
        }
        if ((lunCg = this.lunConsistencyGroupHandler.queryConsistencyGroup(devSn, lunConsistencyGroupId)) != null && !lunCg.getSnapshotScheduleId().equals("0")) {
            this.hyperCDPScheduleHandler.removeLunCgFromHyperCDPSchedule(devSn, scheduleId, lunConsistencyGroupId);
        }
        this.hyperCDPScheduleHandler.delete(devSn, scheduleId, schedule.getScheduleType());
    }

    public void modify(ProtectGroup protectGroup, SnapshotSchedule snapshotSchedule, Schedule modifySchedule) {
        com.huawei.lego.core.sdk.util.VerifyUtil.checkObject((Object)snapshotSchedule);
        com.huawei.lego.core.sdk.util.VerifyUtil.checkObject((Object)protectGroup);
        com.huawei.lego.core.sdk.util.VerifyUtil.checkStrs((String[])new String[]{snapshotSchedule.getDevSn(), snapshotSchedule.getId()});
        SnapshotScheduleUtil.putReplicaRetentionToHyperCDPSchedule((SnapshotSchedule)snapshotSchedule, (RetentionPolicy)modifySchedule.getRetentionPolicy());
        int snapshotNum = SnapshotScheduleUtil.getSnapshotNum((Schedule)modifySchedule);
        snapshotSchedule.setSnapshotMaxNum(Integer.valueOf(snapshotNum));
        snapshotSchedule.setFrequencyValue(Long.valueOf(modifySchedule.getPeriodInterval()));
        snapshotSchedule.setScheduleType(SnapshotSchedule.SCHEDULE_TYPE.HYPERCDP.getValue());
        if (snapshotSchedule.getEnableSchedule().booleanValue()) {
            this.hyperCDPScheduleHandler.enable(snapshotSchedule.getDevSn(), snapshotSchedule.getId(), snapshotSchedule.getScheduleType(), false);
        }
        this.hyperCDPScheduleHandler.modify(snapshotSchedule);
        this.hyperCDPScheduleHandler.enable(snapshotSchedule.getDevSn(), snapshotSchedule.getId(), snapshotSchedule.getScheduleType(), true);
    }

    public List<ProtectGroupReplica> getProtectGroupReplica(ProtectGroup protectGroup, String devSn, Schedule schedule, Map<String, String> conditions) {
        HashMap<String, String> filterConditions = new HashMap<String, String>();
        String lunConsistentGroupId = (String)protectGroup.getProps().get("PROP_KEY_LUN_CG_KEY:" + devSn);
        filterConditions.put("PARENTID", lunConsistentGroupId);
        IStorageHyperCDPGroupManager mgr = StorageHyperCDPGroupManagerProxy.getInstance().getStorageHyperCDPGroupMgrByDevId(devSn);
        if (mgr == null) {
            logger.error((Object)("IStorageHyperCDPGroupManager is null!storageSn:" + devSn));
            throw new LegoCheckedException(1073947394L);
        }
        int startIndex = (NumberUtil.convertToInteger((Object)conditions.get("pageNum")) - 1) * NumberUtil.convertToInteger((Object)conditions.get("pageSize"));
        int endIndex = startIndex + NumberUtil.convertToInteger((Object)conditions.get("pageSize"));
        String range = "[" + startIndex + "-" + endIndex + "]";
        if (!conditions.get("startTime").equals("null") && !conditions.get("endTime").equals("null")) {
            String timeStamp = "[" + NumberUtil.convertToLong((Object)conditions.get("startTime")) / 1000L + "," + NumberUtil.convertToLong((Object)conditions.get("endTime")) / 1000L + "]";
            filterConditions.put("TIMESTAMP", timeStamp);
        }
        List list = mgr.query(devSn, range, filterConditions);
        return this.generateProtectGroupReplica(protectGroup, list, schedule.getProtectLocation());
    }

    private List<ProtectGroupReplica> generateProtectGroupReplica(ProtectGroup protectGroup, List<HyperCDPConsistencyGroup> list, int location) {
        if (VerifyUtil.isEmpty(list)) {
            return new ArrayList<ProtectGroupReplica>();
        }
        ArrayList<ProtectGroupReplica> replicas = new ArrayList<ProtectGroupReplica>();
        for (HyperCDPConsistencyGroup hyperCDPCG : list) {
            ProtectGroupReplica protectGroupReplica = ExecuteReplicaManager.getInstance().buildRealTimeReplica(protectGroup, location);
            if (VerifyUtil.isEmpty((Object)protectGroupReplica)) {
                logger.error((Object)("there is no ProtectGroupReplica for " + protectGroup));
                throw new LegoCheckedException(1073947394L);
            }
            protectGroupReplica.setTimeStamp(hyperCDPCG.getTimeStamp() + "000");
            protectGroupReplica.setStatus(DrmEnumDefine.REPLICA_STATUS.ACTIVE_STATUS.getValue());
            protectGroupReplica.setMountStatus(Integer.valueOf(ReplicaMountStatus.UMOUNTED.getStatus()));
            protectGroupReplica.setGeneration(Integer.valueOf(1));
            protectGroupReplica.getReplicas().stream().forEach(replica -> replica.getStorageInfos().stream().forEach(storageInfo -> ((LocalStorageReplica)storageInfo).setConsistentGroupId(hyperCDPCG.getId())));
            protectGroupReplica.addProperty("StorageIds", hyperCDPCG.getId());
            replicas.add(protectGroupReplica);
        }
        return replicas;
    }

    public Integer getProtectGroupReplicaCount(ProtectGroup protectGroup, String devSn, Map<String, String> conditions) {
        IStorageHyperCDPGroupManager mgr = StorageHyperCDPGroupManagerProxy.getInstance().getStorageHyperCDPGroupMgrByDevId(devSn);
        if (mgr == null) {
            logger.error((Object)("IStorageHyperCDPGroupManager is null!storageSn:" + devSn));
            throw new LegoCheckedException(1073947394L);
        }
        String lunConsistentGroupId = (String)protectGroup.getProps().get("PROP_KEY_LUN_CG_KEY:" + devSn);
        HashMap<String, String> filterConditions = new HashMap<String, String>();
        if (!conditions.get("startTime").equals("null") && !conditions.get("endTime").equals("null")) {
            String timeStamp = "[" + NumberUtil.convertToLong((Object)conditions.get("startTime")) / 1000L + "," + NumberUtil.convertToLong((Object)conditions.get("endTime")) / 1000L + "]";
            filterConditions.put("TIMESTAMP", timeStamp);
        }
        Integer totalConut = mgr.count(devSn, lunConsistentGroupId, filterConditions);
        return totalConut;
    }

    public int getSnapshotType() {
        return SnapshotSchedule.SCHEDULE_TYPE.HYPERCDP.getValue();
    }

    public void setLunConsistencyGroupHandler(IStorageLunConsistencyGroupHandler lunConsistencyGroupHandler) {
        this.lunConsistencyGroupHandler = lunConsistencyGroupHandler;
    }

    public void setHyperCDPScheduleHandler(IStorageSnapshotScheduleHandler hyperCDPScheduleHandler) {
        this.hyperCDPScheduleHandler = hyperCDPScheduleHandler;
        super.setSnapshotScheduleHandler(hyperCDPScheduleHandler);
    }

    public void setLunHandler(IStorageLunHandler lunHandler) {
        this.lunHandler = lunHandler;
    }

    private String getLunConsistencyGroup(ProtectGroup protectGroup, String devSn, List<String> lunIds) {
        String lunConsistencyGroupId = null;
        for (String lunId : lunIds) {
            Lun lun = this.lunHandler.queryStorageLun(devSn, lunId);
            if (null == lun) {
                throw new LegoCheckedException(1073947394L);
            }
            if (Integer.parseInt(lun.getLunCgId()) <= 0) continue;
            lunConsistencyGroupId = lun.getLunCgId();
            break;
        }
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(lunConsistencyGroupId)) {
            List luns = this.lunHandler.queryLuns(devSn, XveMOType.LUN_CONSISTENCY_GROUP, lunConsistencyGroupId);
            if (luns.size() != lunIds.size()) {
                return null;
            }
            for (Lun lun : luns) {
                if (lunIds.contains(lun.getResourceId())) continue;
                return null;
            }
            lunConsistencyGroupId = this.filterLunCGId(devSn, lunConsistencyGroupId);
        }
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty(lunConsistencyGroupId)) {
            protectGroup.getProps().put("PROP_KEY_LUN_CG_KEY:" + devSn, lunConsistencyGroupId);
        }
        return lunConsistencyGroupId;
    }

    private void removeLunCgFromHyperCDPSchedule(String devSn, String scheduleId, String lunCgId) {
        List list = this.lunConsistencyGroupHandler.queryConsistencyGroups(devSn, XveMOType.SNAPSHOTSCHEDULE, scheduleId);
        if (!com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)list)) {
            for (LunConsistencyGroup group : list) {
                if (!group.getId().equals(lunCgId)) continue;
                this.hyperCDPScheduleHandler.removeLunCgFromHyperCDPSchedule(devSn, scheduleId, lunCgId);
            }
        }
    }

    public Set<String> getExistLunsByScheduleId(String devSn, String snapshotScheduleId) {
        List luns = this.lunHandler.queryLuns(devSn, XveMOType.LUN_CONSISTENCY_GROUP, snapshotScheduleId);
        HashSet<String> existLuns = new HashSet<String>();
        if (null == luns) {
            return existLuns;
        }
        for (Lun lun : luns) {
            existLuns.add(lun.getDevSn() + ":" + lun.getLunId());
        }
        return existLuns;
    }

    private String filterLunCGId(String devSn, String lunConsistencyGroupId) {
        List pgs = ((IProtectGroupService)ServiceLocator.getInstance().getService(IProtectGroupService.class)).getAllProtectGroupBasicInfo(Long.valueOf(1L), false, true, false);
        if (com.huawei.lego.core.sdk.util.VerifyUtil.isEmpty((Collection)pgs)) {
            return lunConsistencyGroupId;
        }
        for (ProtectGroup protectGroup : pgs) {
            for (Map.Entry entry : protectGroup.getProps().entrySet()) {
                String key = (String)entry.getKey();
                if (null == key || !key.startsWith("PROP_KEY_LUN_CG_KEY:") && !key.startsWith("PROP_KEY_LUN_LOG_CG_KEY:")) continue;
                String consistencyGroupId = (String)entry.getValue();
                String sn = key.split(":")[1];
                if (!sn.equals(devSn) || !consistencyGroupId.equals(lunConsistencyGroupId)) continue;
                logger.error((Object)("lunConsistencyGroupId is exists:" + lunConsistencyGroupId));
                return null;
            }
        }
        return lunConsistencyGroupId;
    }

    public static class LunConsistencyGroupResult {
        private LunConsistencyGroup group;
        private boolean isCreate;
        private long errorCode;

        public LunConsistencyGroup getGroup() {
            return this.group;
        }

        public void setGroup(LunConsistencyGroup group) {
            this.group = group;
        }

        public boolean isCreate() {
            return this.isCreate;
        }

        public void setCreate(boolean create) {
            this.isCreate = create;
        }

        public long getErrorCode() {
            return this.errorCode;
        }

        public void setErrorCode(long errorCode) {
            this.errorCode = errorCode;
        }
    }
}

