/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.manager;

import com.huawei.ism.array.sdk.model.HvsUnit;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnection;
import com.huawei.ism.cbb.proxy.protocol.rest.connection.RestConnectionManager;
import com.huawei.ism.cbb.proxy.xve.XveEuumDefineParent;
import com.huawei.ism.drm.operation.sdk.model.OperationResult;
import com.huawei.ism.drm.storage.hvs.discovery.util.HVSRestTransitionExtend;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageVstoreReplicationPairChecker;
import com.huawei.ism.drm.storage.manager.sdk.service.IStorageVstoreReplicationPairManager;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.ism.unistor.sdk.model.VstoreReplicationPair;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.CommonUtil;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HvsStorageVstoreReplicationPairManager
implements IStorageVstoreReplicationPairManager {
    private static final long[] STATUS_QUERY_SLEEP_QUEUE = new long[]{3000L, 5000L, 8000L, 12000L, 17000L, 17000L, 12000L, 8000L, 5000L, 3000L};
    private static final Log logger = LogFactory.getInstance(HvsStorageVstoreReplicationPairManager.class);
    private static final String ROLE_PRIMARY = "0";

    public OperationResult swap(String devSn, String pairId) {
        IStorageVstoreReplicationPairChecker checker;
        logger.debug((Object)"Enter swapVstoreReplicationPair, sn=%s, pairId=%s", new Object[]{devSn, pairId});
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)pairId)) {
            logger.error((Object)"pairId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        VstoreReplicationPair pair = this.queryVstorePairById(devSn, pairId);
        boolean isPrimary = this.getIsPrimary(pair.getRole());
        HashMap<String, String> paras = new HashMap<String, String>();
        paras.put("ID", pairId);
        String url = this.getSwitchUrl();
        logger.debug((Object)"swapVstoreReplicationPair url = %s, params = %s", new Object[]{url, paras});
        OperationResult result = this.processCommand(devSn, "ism.business.replication.switchReplicationVstorePair", url, paras);
        if (result.isSuccess() && !this.checkReplicationPair(devSn, pairId, checker = targetLun -> {
            if (targetLun.getIsPrimary() == null) {
                return false;
            }
            return !(isPrimary && targetLun.getIsPrimary() != false || !isPrimary && targetLun.getIsPrimary() == false);
        }, true)) {
            logger.error((Object)("swap vstorePair error!" + pairId));
            result = new OperationResult("ism.business.replication.switchReplicationVstorePair", false, false, String.valueOf(-1L), new String[]{pairId});
        }
        return result;
    }

    protected boolean getIsPrimary(String role) {
        return ROLE_PRIMARY.equals(role);
    }

    protected String getSwitchUrl() {
        String url = "/rest/${deviceID}/REPLICATION_VSTOREPAIR/switch";
        return url;
    }

    protected String getSplitUrl() {
        String url = "/rest/${deviceID}/REPLICATION_VSTOREPAIR/split";
        return url;
    }

    protected String getReplicationVstorePairUrl() {
        return "/rest/${deviceID}/REPLICATION_VSTOREPAIR/";
    }

    protected String getSyncUrl() {
        String url = "/rest/${deviceID}/REPLICATION_VSTOREPAIR/sync";
        return url;
    }

    public OperationResult split(String devSn, String pairId) {
        IStorageVstoreReplicationPairChecker checker;
        logger.debug((Object)"Enter splitVstoreReplicationPair, sn=%s, pairId=%s", new Object[]{devSn, pairId});
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)pairId)) {
            logger.error((Object)"pairId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, String> paras = new HashMap<String, String>();
        paras.put("ID", pairId);
        String url = this.getSplitUrl();
        logger.debug((Object)"splitVstoreReplicationPair url = %s, params = %s", new Object[]{url, paras});
        OperationResult result = this.processCommand(devSn, "ism.business.replication.splitReplicationVstorePair", url, paras);
        if (result.isSuccess() && !this.checkReplicationPair(devSn, pairId, checker = targetLun -> XveEuumDefineParent.RUNNING_STATUS_E.SPLIT.getValue() == targetLun.getPairStatus().intValue(), true)) {
            logger.error((Object)("split vstorePair error!" + pairId));
            result = new OperationResult("ism.business.replication.setSecondaryVstorePair", false, false, String.valueOf(-1L), new String[]{pairId});
        }
        return result;
    }

    public OperationResult sync(String devSn, String pairId) {
        logger.debug((Object)"Enter syncVstoreReplicationPair, sn=%s, pairId=%s", new Object[]{devSn, pairId});
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)pairId)) {
            logger.error((Object)"pairId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, String> paras = new HashMap<String, String>();
        paras.put("ID", pairId);
        String url = this.getSyncUrl();
        logger.debug((Object)"syncVstoreReplicationPair url = %s, params = %s", new Object[]{url, paras});
        return this.processCommand(devSn, "ism.business.replication.syncReplicationVstorePair", url, paras);
    }

    public OperationResult setSecondaryPairReadWrite(String devSn, String pairId, String secVstoreAccess) {
        IStorageVstoreReplicationPairChecker checker;
        logger.debug((Object)"Enter setVstoreReplicationPairAccess, sn=%s, pairId=%s", new Object[]{devSn, pairId});
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)pairId) || VerifyUtil.isEmpty((String)secVstoreAccess)) {
            logger.error((Object)"pairId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        HashMap<String, String> paras = new HashMap<String, String>();
        String url = this.getSecondaryPairReadWrite(paras, pairId, secVstoreAccess);
        OperationResult result = this.processCommand(devSn, "ism.business.replication.setSecondaryVstorePair", url, paras);
        if (result.isSuccess() && !this.checkReplicationPair(devSn, pairId, checker = targetLun -> secVstoreAccess.equals(targetLun.getSecresAccess()), true)) {
            logger.error((Object)"setReadWrite vstorePair error! pairId=%s, devSn=%s", new Object[]{pairId, devSn});
            result = new OperationResult("ism.business.replication.setSecondaryVstorePair", false, false, String.valueOf(-1L), new String[]{pairId});
        }
        return result;
    }

    protected String getSecondaryPairReadWrite(Map<String, String> paras, String pairId, String secVstoreAccess) {
        paras.put("ID", pairId);
        paras.put("SECVSTOREACCESS", secVstoreAccess);
        String url = "/rest/${deviceID}/replication_vstorepair";
        logger.debug((Object)"setVstoreReplicationPairAccess url = %s, params = %s", new Object[]{url, paras});
        return url;
    }

    protected String getQuerySyncStatusUrl(String devSn, String pairId) {
        String url = "/rest/${deviceID}/replicationpair/associate?ASSOCIATEOBJTYPE=2000&ASSOCIATEOBJID=" + pairId + "&range=[0-65536]";
        return url;
    }

    public String getStorageType() {
        return HvsUnit.class.getName();
    }

    protected RestConnection getConn(String devSn) {
        RestConnection conn = RestConnectionManager.getInstance().getConnection(devSn);
        if (null == conn) {
            throw new LegoCheckedException(1073947649L);
        }
        return conn;
    }

    public List<ReplicationTargetLun> querySyncStatusByVstorePair(String devSn, String pairId, boolean queryOnly) {
        String url = this.getQuerySyncStatusUrl(devSn, pairId);
        ArrayList<ReplicationTargetLun> tgtLunList = new ArrayList<ReplicationTargetLun>();
        RestConnection conn = this.getConn(devSn);
        logger.debug((Object)"Get syncStatusByVstorePair: url = %s", new Object[]{url});
        List records = conn.getBatch(url, null);
        if (!VerifyUtil.isEmpty((Collection)records)) {
            for (Map repResult : records) {
                if (queryOnly && !pairId.equals(repResult.get("VSTOREPAIRID"))) continue;
                ReplicationTargetLun tgtLun = HVSRestTransitionExtend.transitionReplicationTargetLun(repResult, devSn);
                tgtLunList.add(tgtLun);
            }
        }
        return tgtLunList;
    }

    public VstoreReplicationPair queryVstorePairById(String devSn, String pairId) {
        if (VerifyUtil.isEmpty((String)devSn)) {
            logger.error((Object)"devSn is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        if (VerifyUtil.isEmpty((String)pairId)) {
            logger.error((Object)"pairId is empty.");
            throw new LegoCheckedException(1073947393L);
        }
        String url = this.getReplicationVstorePairUrl() + pairId;
        logger.debug((Object)"Get queryVstorePair url = %s", new Object[]{url});
        RestConnection conn = this.getConn(devSn);
        Map record = conn.get(url, null);
        return HVSRestTransitionExtend.transitionVstoreReplicationPair(devSn, record);
    }

    protected OperationResult processCommand(String deviceId, String operationName, String url, Map<String, String> paramMap) {
        OperationResult operationResult;
        RestConnection connection = this.getConn(deviceId);
        try {
            connection.put(url, paramMap);
            operationResult = new OperationResult(operationName, true, true, new String[]{deviceId});
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"Processing command failed. url:%s,Params:%s, CmdDevId:%s, ERROR:%s, Message:%s", new Object[]{url, paramMap.toString(), deviceId, ExceptionUtil.getErrorMessage((Throwable)e), 90160758784001L});
            operationResult = new OperationResult(operationName, true, false, String.valueOf(e.getErrorCode()), new String[]{deviceId});
        }
        catch (Exception e) {
            logger.error((Object)"Processing command failed. url:%s,Params:%s, CmdDevId:%s, ERROR:%s, Message:%s", new Object[]{url, paramMap.toString(), deviceId, ExceptionUtil.getErrorMessage((Throwable)e), 90160758784001L});
            operationResult = new OperationResult(operationName, true, false, String.valueOf(-1L), new String[]{deviceId});
        }
        return operationResult;
    }

    protected boolean checkReplicationPair(String devSn, String vstorePairId, IStorageVstoreReplicationPairChecker checker, boolean checkOnly) {
        for (long sleepTime : STATUS_QUERY_SLEEP_QUEUE) {
            CommonUtil.sleep((long)sleepTime);
            boolean checkResult = true;
            List<ReplicationTargetLun> targetLuns = this.querySyncStatusByVstorePair(devSn, vstorePairId, checkOnly);
            if (VerifyUtil.isEmpty(targetLuns)) {
                return true;
            }
            for (ReplicationTargetLun targetLun : targetLuns) {
                if (checker.checkResult(targetLun)) continue;
                checkResult = false;
            }
            if (!checkResult) continue;
            return true;
        }
        return false;
    }

    public OperationResult modifyActiveStatus(String devSn, VstoreReplicationPair pair, int type) {
        OperationResult operationResult = new OperationResult("ism.business.replication.setVstorePairActiveStatus", true, true, new String[]{devSn});
        if (pair == null || !"1".equals(pair.getIdentityPerserve())) {
            logger.info((Object)"not need active vstorePair.");
            return operationResult;
        }
        String pairId = pair.getVstorePairId();
        VerifyUtil.checkStrs((String[])new String[]{devSn, pairId});
        String url = "/rest/${deviceID}/REPLICATION_VSTOREPAIR/inOrActive";
        try {
            RestConnection conn = this.getConn(devSn);
            JSONObject params = new JSONObject();
            params.put((Object)"ID", (Object)pairId);
            params.put((Object)"FORCIBLYDEACTIVATELOGICALPORT", (Object)type);
            conn.putForObject(url, (Object)params);
        }
        catch (LegoCheckedException e) {
            logger.error((Object)"modifyActiveStatus error, devSn:%s, pairId:%s", new Object[]{devSn, pairId, e});
            operationResult = new OperationResult("ism.business.replication.setVstorePairActiveStatus", true, false, String.valueOf(e.getErrorCode()), new String[]{devSn});
        }
        return operationResult;
    }
}

