/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.protection.replica.calculator;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.drm.constant.PolicyTemplateType;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RemoteStorageReplica;
import com.huawei.ism.drm.storage.hvs.protection.replica.calculator.HyperDRRingReplicaCalculator;
import com.huawei.ism.drm.storage.hvs.protection.util.CommonUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.DRRingUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.IReplicationPairQuery;
import com.huawei.ism.drm.storage.hvs.protection.util.ReplicationUtil;
import com.huawei.ism.drm.storage.protection.template.filter.ArrayAsyncReplicationFilter;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.model.ReplicationTargetLun;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HyperMetroRingReplicaCalculator
extends HyperDRRingReplicaCalculator
implements IReplicationPairQuery {
    private static final Log logger = LogFactory.getInstance(HyperMetroRingReplicaCalculator.class);
    private static final Set<PolicyTemplateType.POLICY_TEMPLATE_E> SUPPORTED_TEMPLATES = Collections.unmodifiableSet(new HashSet<PolicyTemplateType.POLICY_TEMPLATE_E>(Arrays.asList(PolicyTemplateType.POLICY_TEMPLATE_E.ARRAY_HYPER_METRO_ASYNC_RING, PolicyTemplateType.POLICY_TEMPLATE_E.ARRAY_ASYNC_HYPER_METRO_RING)));
    private ArrayAsyncReplicationFilter asyncReplicationFilter;

    public ArrayAsyncReplicationFilter getAsyncReplicationFilter() {
        return this.asyncReplicationFilter;
    }

    public void setAsyncReplicationFilter(ArrayAsyncReplicationFilter asyncReplicationFilter) {
        this.asyncReplicationFilter = asyncReplicationFilter;
    }

    @Override
    protected int getProtectGroupReplicaLimits() {
        return 1;
    }

    @Override
    protected void updateReplica(ProtectGroupReplica replica) {
        Collection<ProtectObjectReplica> protectObjectReplicas = CommonUtil.defaults(replica.getReplicas());
        HashMap<String, StringBuilder> messages = new HashMap<String, StringBuilder>();
        for (ProtectObjectReplica protectObjectReplica : protectObjectReplicas) {
            Collection<RemoteStorageReplica> remoteStorageReplicas = CommonUtil.getItemsByClassType(protectObjectReplica.getStorageInfos(), RemoteStorageReplica.class);
            Map<String, Collection<RemoteStorageReplica>> replicaGroups = CommonUtil.classify(remoteStorageReplicas, "drRingId", String.class);
            StringBuilder message = this.updateReplicaStorageInfoInRealtime(replicaGroups);
            if (message.length() <= 0) continue;
            messages.put(protectObjectReplica.getPoId(), message);
        }
        if (!messages.isEmpty()) {
            logger.error((Object)CommonUtil.join("({0})", messages));
            throw new LegoCheckedException(1073948257L);
        }
    }

    private StringBuilder updateReplicaStorageInfoInRealtime(Map<String, Collection<RemoteStorageReplica>> replicaGroups) {
        HashMap<String, StringBuilder> messages = new HashMap<String, StringBuilder>();
        for (Map.Entry<String, Collection<RemoteStorageReplica>> replicaGroup : replicaGroups.entrySet()) {
            Collection<RemoteStorageReplica> remoteStorageReplicas = replicaGroup.getValue();
            StringBuilder message = this.updateReplicaStorageInfoInRealtime(remoteStorageReplicas);
            if (message.length() <= 0) continue;
            messages.put("HyperDR/Ring:" + replicaGroup.getKey(), message);
        }
        return CommonUtil.join("({0})", messages);
    }

    private StringBuilder updateReplicaStorageInfoInRealtime(Collection<RemoteStorageReplica> replicas) {
        ArrayList<Collection<ReplicationPair>> bothSidePairs = new ArrayList<Collection<ReplicationPair>>();
        StringBuilder errors = this.classifyReplicationPairByHyperMetroSide(replicas, bothSidePairs);
        if (errors.length() > 0) {
            return errors;
        }
        Collection<ReplicationPair> currentSidePairs = DRRingUtil.getWhichMatchAllRemoteStorageReplicas(bothSidePairs, replicas);
        if (currentSidePairs == null || currentSidePairs.isEmpty()) {
            return new StringBuilder("not find replication pairs for the current side");
        }
        Collection<ReplicationPair> anotherSidePairs = DRRingUtil.getWhichNotContains(bothSidePairs, currentSidePairs);
        if (anotherSidePairs == null || anotherSidePairs.isEmpty()) {
            return new StringBuilder("not find replication pairs for the another side");
        }
        return this.checkReplicationPair(replicas, bothSidePairs, currentSidePairs, anotherSidePairs);
    }

    private StringBuilder checkReplicationPair(Collection<RemoteStorageReplica> replicas, Collection<Collection<ReplicationPair>> bothSidePairs, Collection<ReplicationPair> currentSidePairs, Collection<ReplicationPair> anotherSidePairs) {
        if (DRRingUtil.checkIntersection(currentSidePairs, anotherSidePairs)) {
            return new StringBuilder("running status of replication pairs is messy,").append(" replication pair can not contained by both side");
        }
        if (!DRRingUtil.isAnyMatchedStandby(currentSidePairs)) {
            return new StringBuilder();
        }
        Collection<ReplicationPair> allRelatedPairs = DRRingUtil.spread(bothSidePairs);
        return this.updateReplicasInRealtimeUseAnotherSide(replicas, allRelatedPairs, anotherSidePairs);
    }

    private StringBuilder classifyReplicationPairByHyperMetroSide(Collection<RemoteStorageReplica> replicas, Collection<Collection<ReplicationPair>> bothSidePairs) {
        Map<String, Collection<Object>> pairMap = DRRingUtil.getRelatedReplicationPairs(replicas, this);
        StringBuilder errors = DRRingUtil.checkValueCountNotMatched(pairMap, 2);
        if (errors.length() > 0) {
            return new StringBuilder("replication pair number of each replica should be two. ").append((CharSequence)errors);
        }
        Collection<ReplicationPair> allRelatedPairs = DRRingUtil.spread(pairMap.values());
        StringBuilder message = this.checkDRRingRunningStatus(replicas, allRelatedPairs);
        if (message.length() > 0) {
            return message;
        }
        pairMap = ReplicationUtil.classifyReplicationPairByHyperMetroSide(allRelatedPairs);
        if (pairMap == null) {
            return new StringBuilder("Possible device configuration is damaged.").append(" there should have hyper metro side have two storage");
        }
        bothSidePairs.addAll(pairMap.values());
        return new StringBuilder();
    }

    private StringBuilder updateReplicasInRealtimeUseAnotherSide(Collection<RemoteStorageReplica> replicas, Collection<ReplicationPair> allRelatedPairs, Collection<ReplicationPair> anotherSidePairs) {
        if (DRRingUtil.isAnyMatchedStandby(anotherSidePairs)) {
            return new StringBuilder("should not contain standby replication pair at both side");
        }
        StringBuilder message = this.updateReplicasInRealtime(replicas, anotherSidePairs);
        if (message.length() != 0) {
            return new StringBuilder("data is inconsistent between db and dev. ").append((CharSequence)message);
        }
        return this.checkDRRingRunningStatus(replicas, allRelatedPairs);
    }

    private StringBuilder updateReplicasInRealtime(Collection<RemoteStorageReplica> replicas, Collection<ReplicationPair> anotherSidePairs) {
        HashMap<String, StringBuilder> messages = new HashMap<String, StringBuilder>();
        for (RemoteStorageReplica replica : replicas) {
            StringBuilder message = this.updateReplicaStorageInfoInRealtime(replica, anotherSidePairs);
            if (message.length() <= 0) continue;
            messages.put(replica.getProtectObjectStorageWwn(), message);
        }
        StringBuilder message = CommonUtil.join("({0})", messages);
        return message;
    }

    private StringBuilder checkDRRingRunningStatus(Collection<RemoteStorageReplica> replicas, Collection<ReplicationPair> allRelatedPairs) {
        Collection<String> drRingIds = DRRingUtil.get(replicas, "drRingId", String.class);
        Map<String, Collection<ReplicationPair>> productStoragePairMap = ReplicationUtil.classifyReplicationPairByProductStorageSn(allRelatedPairs);
        Set<String> productStorageSn = productStoragePairMap.keySet();
        StringBuilder message = DRRingUtil.checkRunningStatusNotMatchedRings(productStorageSn, drRingIds, "1");
        if (message.length() != 0) {
            message = new StringBuilder("running status of dr ring is not enabled. ").append((CharSequence)message);
        }
        return message;
    }

    private StringBuilder updateReplicaStorageInfoInRealtime(RemoteStorageReplica replica, Collection<ReplicationPair> pairs) {
        String wwn = replica.getProtectObjectStorageWwn();
        ReplicationPair pair = ReplicationUtil.getReplicationPairByWwn(pairs, wwn);
        StringBuilder message = new StringBuilder();
        if (pair == null) {
            return message.append("not find replication pair for remote storage replica");
        }
        if (!CommonUtil.equal(replica.getDrRingId(), pair.getDrRingId())) {
            return message.append("dr ring id(db, dev): ").append(replica.getDrRingId()).append(',').append(pair.getDrRingId());
        }
        List targets = pair.getRepTgtLuns();
        if (targets == null || targets.size() != 1) {
            return message.append("number of target lun is not match 1");
        }
        ReplicationTargetLun target = (ReplicationTargetLun)targets.get(0);
        if (target == null) {
            return message.append("target lun is null");
        }
        replica.setSrcStorageId(pair.getSrcLunId());
        replica.setSrcStorageProviderSN(pair.getSrcDevSN());
        replica.setStorageId(target.getTgtLunId());
        replica.setStorageProviderSN(target.getTgtDevSN());
        replica.setReplicationPairId(pair.getReplicationId());
        replica.setConsistentGroupId(pair.getConsistentGroupId());
        return message;
    }

    @Override
    public Collection<ReplicationPair> getReplicationPairsByLun(Collection<Lun> luns) {
        return this.asyncReplicationFilter.getPairsByLun(luns);
    }

    @Override
    public Collection<ReplicationPair> getReplicationPairsByLun(String devSn, Collection<String> luns) {
        throw new UnsupportedOperationException();
    }

    public Set<PolicyTemplateType.POLICY_TEMPLATE_E> getSupportPolicyTemplate() {
        return SUPPORTED_TEMPLATES;
    }
}

