/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.protection.util;

import com.huawei.ism.cbb.base.util.CommonDAOLocator;
import com.huawei.ism.drm.base.util.DBOperationUtil;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObject;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectObjectStorageInfo;
import com.huawei.ism.drm.storage.hvs.protection.util.DRRingUtil;
import com.huawei.ism.drm.storage.protection.util.DRRingCommUtil;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import com.huawei.lego.core.sdk.util.JSONObject;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.hibernate.Session;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate5.HibernateTemplate;

public class CommonUtil {
    private static Log logger = LogFactory.getInstance(CommonUtil.class);

    protected CommonUtil() {
    }

    public static <T> Collection<T> defaults(Collection<T> c) {
        if (c == null) {
            c = Collections.emptyList();
        }
        return c;
    }

    public static <K, V> Map<K, V> defaults(Map<K, V> map) {
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    public static StringBuilder join(Map<?, ?> map) {
        return CommonUtil.join(map, ':');
    }

    public static StringBuilder join(String pattern, Map<?, ?> map) {
        return CommonUtil.join(map, ":", ",", pattern);
    }

    public static StringBuilder join(Collection<?> items, char delim) {
        StringBuilder sb = new StringBuilder();
        if (items == null) {
            return sb;
        }
        for (Object item : items) {
            if (sb.length() > 0) {
                sb.append(delim);
            }
            sb.append(item);
        }
        return sb;
    }

    public static StringBuilder join(Map<?, ?> map, String delim, char delim2) {
        return CommonUtil.join(map, delim, String.valueOf(delim2));
    }

    public static StringBuilder join(Map<?, ?> map, String delim) {
        return CommonUtil.join(map, delim, ',');
    }

    public static StringBuilder join(Map<?, ?> map, char delim) {
        return CommonUtil.join(map, String.valueOf(delim));
    }

    public static StringBuilder join(Map<?, ?> map, String delim, String delim2) {
        return CommonUtil.join(map, delim, delim2, null);
    }

    public static StringBuilder join(Map<?, ?> map, String delim, String delim2, String pattern) {
        delim = delim != null ? delim : String.valueOf(':');
        delim2 = delim2 != null ? delim2 : String.valueOf(',');
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (sb.length() > 0) {
                sb.append(delim2);
            }
            sb.append(entry.getKey()).append(delim);
            String value = String.valueOf(entry.getValue());
            if (pattern != null) {
                value = CommonUtil.format(pattern, value);
            }
            sb.append(value);
        }
        return sb;
    }

    public static String format(String template, String ... params) {
        if (template == null || params == null) {
            return template;
        }
        for (int i = 0; i < params.length; ++i) {
            template = template.replaceAll("\\{" + i + "\\}", params[i]);
        }
        return template;
    }

    public static <T> StringBuilder checkValueCountNotMatched(Map<String, Collection<T>> map, int count) {
        map = CommonUtil.defaults(map);
        HashMap<String, Integer> results = new HashMap<String, Integer>();
        for (Map.Entry<String, Collection<T>> entry : map.entrySet()) {
            Collection<T> items = CommonUtil.defaults(entry.getValue());
            if (items.size() == count) continue;
            results.put(entry.getKey(), items.size());
        }
        return CommonUtil.join(results);
    }

    public static <T> boolean checkCongruent(Collection<T> a, Collection<T> b) {
        a = CommonUtil.defaults(a);
        b = CommonUtil.defaults(b);
        if (a.size() != b.size()) {
            return false;
        }
        return a.containsAll(b);
    }

    public static <T> boolean checkIntersection(Collection<T> a, Collection<T> b) {
        a = CommonUtil.defaults(a);
        b = CommonUtil.defaults(b);
        for (T e : a) {
            if (!b.contains(e)) continue;
            return true;
        }
        return false;
    }

    public static List<?> find(String queryString, String paramName, Collection<?> values) {
        if (values == null || values.isEmpty()) {
            return Collections.emptyList();
        }
        return CommonUtil.find(queryString, new String[]{paramName}, new Object[]{values});
    }

    public static List<?> find(String queryString, String[] paramNames, Object[] values) {
        List results;
        paramNames = paramNames != null ? paramNames : new String[]{};
        values = values != null ? values : new Object[]{};
        HibernateTemplate hibernate = CommonDAOLocator.getBaseDao().getHibernateTemplate();
        try {
            results = hibernate.findByNamedParam(queryString, paramNames, values);
        }
        catch (DataAccessException e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            results = null;
        }
        if (results == null) {
            return Collections.emptyList();
        }
        return results;
    }

    public static List<?> find(String queryString, Collection<String> paramNames, Collection<? extends Object> values) {
        paramNames = CommonUtil.defaults(paramNames);
        values = CommonUtil.defaults(values);
        if (paramNames.isEmpty() || values.isEmpty() || paramNames.size() != values.size()) {
            return Collections.emptyList();
        }
        int size = paramNames.size();
        return CommonUtil.find(queryString, paramNames.toArray(new String[size]), values.toArray(new Object[size]));
    }

    public static <E> Collection<E> find(String queryString, String paramName, Collection<?> values, Class<E> type) {
        return CommonUtil.getItemsByClassType(CommonUtil.find(queryString, paramName, values), type);
    }

    public static <E> Collection<E> find(String queryString, String[] paramNames, Object[] values, Class<E> type) {
        return CommonUtil.getItemsByClassType(CommonUtil.find(queryString, paramNames, values), type);
    }

    public static <E> Collection<E> find(String queryString, Collection<String> paramNames, Collection<? extends Object> values, Class<E> type) {
        return CommonUtil.getItemsByClassType(CommonUtil.find(queryString, paramNames, values), type);
    }

    public static <T> Collection<T> getWhichAllContains(Collection<Collection<T>> candidates, Collection<T> items) {
        if (candidates == null) {
            return null;
        }
        for (Collection<T> candidate : candidates) {
            if (!candidate.containsAll(items)) continue;
            return candidate;
        }
        return null;
    }

    public static <T> Collection<T> getWhichNotContains(Collection<Collection<T>> candidates, Collection<T> items) {
        if (candidates == null) {
            return null;
        }
        for (Collection<T> candidate : candidates) {
            if (CommonUtil.checkIntersection(candidate, items)) continue;
            return candidate;
        }
        return null;
    }

    public static <V> Collection<V> spread(Collection<? extends Collection<V>> outter) {
        if (outter == null) {
            return Collections.emptyList();
        }
        HashSet<V> items = new HashSet<V>();
        for (Collection<V> inner : outter) {
            if (inner == null) continue;
            items.addAll(inner);
        }
        return items;
    }

    public static boolean equal(Object a, Object b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.equals(b);
    }

    public static <A, B extends A, C extends A> Collection<C> getItemsByClassType(Collection<B> items, Class<C> type) {
        items = CommonUtil.defaults(items);
        HashSet<C> results = new HashSet<C>();
        for (B item : items) {
            if (!type.isInstance(item)) continue;
            results.add(type.cast(item));
        }
        return results;
    }

    public static <B, C extends B> B getOrNew(Map<String, B> map, String key, Class<C> type) {
        Object value = map.get(key);
        if (value == null) {
            try {
                value = type.newInstance();
            }
            catch (InstantiationException e) {
                logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
                return null;
            }
            catch (IllegalAccessException e) {
                logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
                return null;
            }
            map.put(key, value);
        }
        return value;
    }

    public static <K, V> Map<K, V> getOrNewMap(Map<String, Map<K, V>> map, String key) {
        return CommonUtil.defaults(CommonUtil.getOrNew(map, key, HashMap.class));
    }

    public static <E> Collection<E> getOrNewSet(Map<String, Collection<E>> map, String key) {
        return CommonUtil.defaults(CommonUtil.getOrNew(map, key, HashSet.class));
    }

    public static String json(Map<?, ?> data) {
        String json;
        if (data == null) {
            return null;
        }
        try {
            JSONObject object = new JSONObject();
            object.putAll(data);
            json = object.toString();
        }
        catch (LegoCheckedException e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            json = null;
        }
        return json;
    }

    public static <K, V> Map<K, Collection<V>> classify(Collection<V> items, String field, Class<K> itemType) {
        items = CommonUtil.defaults(items);
        HashMap<K, HashSet<V>> map = new HashMap<K, HashSet<V>>();
        for (V item : items) {
            Object value = CommonUtil.get(item, field);
            if (value != null && !itemType.isInstance(value)) continue;
            K key = itemType.cast(value);
            HashSet<V> collection = (HashSet<V>)map.get(value);
            if (collection == null) {
                collection = new HashSet<V>();
                map.put(key, collection);
            }
            collection.add(item);
        }
        return map;
    }

    public static <E, C extends E> Collection<E> get(Collection<?> items, String field, Class<C> itemType) {
        return CommonUtil.get(items, field, itemType, null);
    }

    public static <E, C extends E> Collection<E> get(Collection<?> items, String field, Class<C> itemType, Class<? extends Collection> collectionType) {
        Collection collection;
        if (field == null || itemType == null) {
            return Collections.emptyList();
        }
        if (collectionType == null) {
            collectionType = HashSet.class;
        }
        items = CommonUtil.defaults(items);
        try {
            collection = collectionType.newInstance();
        }
        catch (InstantiationException e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            return Collections.emptyList();
        }
        catch (IllegalAccessException e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            return Collections.emptyList();
        }
        for (Object item : items) {
            Object value = CommonUtil.get(item, field);
            if (value != null && !itemType.isInstance(value)) continue;
            collection.add(value);
        }
        return collection;
    }

    public static Object get(Object object, String name) {
        if (object == null) {
            return null;
        }
        Class<?> clazz = object.getClass();
        Field field = CommonUtil.getFieldByName(clazz, name);
        Method getter = field != null ? CommonUtil.getFieldGetter(field, clazz) : CommonUtil.getFieldGetter(name, clazz, null);
        Object value = getter == null ? CommonUtil.get(object, field) : CommonUtil.get(object, getter);
        return value;
    }

    private static Object get(Object object, Field field) {
        Object value;
        if (object == null || field == null) {
            return null;
        }
        try {
            value = field.get(object);
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            value = null;
        }
        catch (IllegalAccessException e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            value = null;
        }
        return value;
    }

    private static Object get(Object object, Method getter) {
        Object value;
        if (object == null || getter == null) {
            return null;
        }
        try {
            value = getter.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            value = null;
        }
        catch (IllegalArgumentException e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            value = null;
        }
        catch (InvocationTargetException e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            value = null;
        }
        return value;
    }

    private static Field getFieldByName(Class<?> clazz, String name) {
        Field field;
        if (clazz == null || name == null) {
            return null;
        }
        try {
            field = clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            field = null;
        }
        catch (SecurityException e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            field = null;
        }
        if (field != null) {
            return field;
        }
        if (Object.class.equals(clazz)) {
            return null;
        }
        if (Object.class.equals(clazz = clazz.getSuperclass())) {
            return null;
        }
        return CommonUtil.getFieldByName(clazz, name);
    }

    private static Method getFieldGetter(String field, Class<?> clazz, Class<?> base) {
        Method getter;
        if (field == null || clazz == null) {
            return null;
        }
        Class<Object> clazz2 = base = base != null ? base : Object.class;
        if (!base.isAssignableFrom(clazz)) {
            return null;
        }
        String name = CommonUtil.getter(field);
        try {
            getter = clazz.getDeclaredMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            getter = null;
        }
        catch (SecurityException e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            getter = null;
        }
        if (getter != null) {
            return getter;
        }
        if (clazz.equals(base)) {
            return null;
        }
        return CommonUtil.getFieldGetter(field, clazz.getSuperclass(), base);
    }

    private static Method getFieldGetter(Field field, Class<?> clazz) {
        if (clazz == null || field == null) {
            return null;
        }
        return CommonUtil.getFieldGetter(field.getName(), clazz, field.getDeclaringClass());
    }

    private static String getter(String name) {
        return "get" + name.substring(0, 1).toUpperCase(Locale.US) + name.substring(1);
    }

    public static boolean checkReplicationPairConsistentBySrcWwn(Collection<ReplicationPair> replicationPairs, Collection<String> wwnList) {
        replicationPairs = CommonUtil.defaults(replicationPairs);
        wwnList = CommonUtil.defaults(wwnList);
        Collection srcLunWwnList = CommonUtil.get(replicationPairs, "srcLunWWN", String.class);
        return CommonUtil.checkCongruent(srcLunWwnList, wwnList);
    }

    public static Collection<ReplicationPair> getReplicationPairBySrcWwn(Collection<Collection<ReplicationPair>> group, Collection<String> wwnList) {
        group = CommonUtil.defaults(group);
        for (Collection<ReplicationPair> pairs : group) {
            if (!CommonUtil.checkReplicationPairConsistentBySrcWwn(pairs, wwnList)) continue;
            return pairs;
        }
        return null;
    }

    public static void close(Session session) {
        DBOperationUtil.closeSession((Session)session);
    }

    public static Map<String, List<ReplicationPair>> filterStandbyBySite(String masterSn, String slaveSn, Map<String, List<ReplicationPair>> deviceSnPairMap) {
        if (null == masterSn || null == slaveSn || null == deviceSnPairMap) {
            logger.error((Object)"error param.");
            return Collections.emptyMap();
        }
        HashMap<String, List<ReplicationPair>> correctStandyPair = new HashMap<String, List<ReplicationPair>>();
        for (List<ReplicationPair> pairList : deviceSnPairMap.values()) {
            if (null == pairList || pairList.isEmpty()) continue;
            for (ReplicationPair replicationPair : pairList) {
                if (!DRRingCommUtil.isCorrectStandby((String)masterSn, (String)slaveSn, (ReplicationPair)replicationPair)) continue;
                List pairs = (List)correctStandyPair.get(replicationPair.getSrcLunId());
                if (null != pairs) {
                    pairs.add(replicationPair);
                    continue;
                }
                ArrayList<ReplicationPair> tempPairs = new ArrayList<ReplicationPair>();
                tempPairs.add(replicationPair);
                correctStandyPair.put(replicationPair.getSrcLunId(), tempPairs);
            }
        }
        return correctStandyPair;
    }

    public static boolean matchDRRingLimit(List<ProtectObject> protectObjects, Map<String, List<ReplicationPair>> abPairMap, boolean checkDRRingStatus) {
        boolean isMatch = true;
        for (ProtectObject protectObject : protectObjects) {
            int drRingLimits = DRRingUtil.getDRRingLimits(protectObject);
            if (drRingLimits == 0) {
                logger.error((Object)"May encounter tampering attacks, because drRingLimits should be 1 or 2, not 0");
                return false;
            }
            isMatch = CommonUtil.relatedDRRingIdMatchPo(protectObject, abPairMap, drRingLimits, checkDRRingStatus);
            if (isMatch) continue;
            return false;
        }
        return isMatch;
    }

    private static boolean relatedDRRingIdMatchPo(ProtectObject po, Map<String, List<ReplicationPair>> abPairMap, int drRingLimits, boolean checkDRRingRunning) {
        ArrayList<ReplicationPair> allRelatedPairs = new ArrayList<ReplicationPair>();
        HashSet<String> drRingIds = new HashSet<String>();
        HashSet<String> storageSns = new HashSet<String>();
        for (ProtectObjectStorageInfo poStorageInfo : po.getUsedStorageResourceSet()) {
            List<ReplicationPair> pairs = abPairMap.get(poStorageInfo.getResourceId());
            if (null == pairs || pairs.size() != 1) {
                logger.error((Object)"pair is null or pair size not one");
                return false;
            }
            storageSns.add(poStorageInfo.getResourceProviderSN());
            allRelatedPairs.addAll(pairs);
        }
        for (ReplicationPair pair : allRelatedPairs) {
            drRingIds.add(pair.getDrRingId());
        }
        if (drRingIds.size() != drRingLimits) {
            logger.error((Object)"drring ids not match ring limit");
            return false;
        }
        if (!checkDRRingRunning) {
            logger.debug((Object)"no need check drring running status.");
            return true;
        }
        StringBuilder checkResult = DRRingUtil.checkRunningStatusNotMatchedRings(storageSns, drRingIds, String.valueOf(2));
        if (null != checkResult && checkResult.length() != 0) {
            logger.error((Object)("DRRing status not running." + checkResult.toString()));
            return false;
        }
        return true;
    }
}

