/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.protection.util;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.drm.constant.DrmEnumDefine;
import com.huawei.ism.drm.storage.hvs.protection.util.DRRingUtil;
import com.huawei.ism.drm.storage.hvs.protection.util.IReplicationPairQuery;
import com.huawei.ism.drm.storage.hvs.protection.util.IReplicationPairQueryService;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.sdk.service.IStorageService;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.log.Log;
import com.huawei.lego.core.sdk.log.LogFactory;
import com.huawei.lego.core.sdk.util.ExceptionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ReplicationPairQueryAtMineSideService
implements IReplicationPairQuery,
IReplicationPairQueryService {
    private static Log logger = LogFactory.getInstance(ReplicationPairQueryAtMineSideService.class);
    private static final ReplicationPairQueryAtMineSideService INSTANCE = new ReplicationPairQueryAtMineSideService();
    private ThreadLocal<Boolean> isFromDevice = new ThreadLocal();
    private IStorageService storageService;

    protected ReplicationPairQueryAtMineSideService() {
    }

    public IStorageService getStorageService() {
        return this.storageService;
    }

    public void setStorageService(IStorageService storageService) {
        this.storageService = storageService;
    }

    @Override
    public IReplicationPairQuery fromDevice(boolean flag) {
        this.isFromDevice.set(flag);
        return this;
    }

    public boolean fromDevice() {
        Boolean realtime = this.isFromDevice.get();
        realtime = realtime != null ? realtime : false;
        return realtime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<ReplicationPair> getReplicationPairsByLun(Collection<Lun> lunList) {
        if ((lunList = DRRingUtil.defaults(lunList)).isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, Collection<ReplicationPair>> pairMap = new HashMap<String, Collection<ReplicationPair>>();
        Map<String, Collection<Lun>> lunMap = DRRingUtil.classifyLunByDevSn(lunList);
        try {
            for (Map.Entry<String, Collection<Lun>> entry : lunMap.entrySet()) {
                Collection<String> items = DRRingUtil.convertLunToLunId(entry.getValue());
                if (items.isEmpty()) continue;
                String sn = entry.getKey();
                Collection<ReplicationPair> pairs = this.getReplicationPairsByLun(sn, items);
                pairMap.put(sn, DRRingUtil.defaults(pairs));
            }
        }
        finally {
            this.isFromDevice.remove();
        }
        return DRRingUtil.spread(pairMap.values());
    }

    @Override
    public Collection<ReplicationPair> getReplicationPairsByLun(String devSn, Collection<String> luns) {
        List pairs;
        if ((luns = DRRingUtil.defaults(luns)).isEmpty()) {
            return Collections.emptyList();
        }
        Boolean realtime = this.fromDevice();
        try {
            pairs = this.storageService.queryReplicationPairsByMasterLunId(devSn, new ArrayList<String>(luns), realtime.booleanValue(), Integer.valueOf(DrmEnumDefine.RESOURCE_TYPE_E.LUN.getValue()));
        }
        catch (LegoCheckedException e) {
            logger.error((Object)ExceptionUtil.getErrorMessage((Throwable)e));
            pairs = null;
        }
        return DRRingUtil.defaults(pairs);
    }

    public static ReplicationPairQueryAtMineSideService getInstance() {
        return INSTANCE;
    }
}

