/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.topology;

import com.huawei.ism.array.sdk.model.Lun;
import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectObjectReplica;
import com.huawei.ism.drm.protection.replica.sdk.model.RelicaStorageInfo;
import com.huawei.ism.drm.storage.hvs.protection.util.ReplicationPairQueryAtBothSideService;
import com.huawei.ism.drm.storage.hvs.protection.util.ReplicationPairQueryAtMineSideService;
import com.huawei.ism.drm.storage.hvs.protection.util.RingTopologyUtil;
import com.huawei.ism.drm.storage.sdk.model.ReplicationPair;
import com.huawei.ism.drm.storage.topology.ArrayDoubleActiveTopoBuilder;
import com.huawei.ism.drm.storage.topology.ReplicaRelation;
import com.huawei.ism.drm.topo.sdk.context.TopoContext;
import com.huawei.ism.drm.topo.sdk.twaver.Skin;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import twaver.IData;
import twaver.IElement;
import twaver.Node;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:PolicyTemplate-26")
public class ArrayHyperMetroReplicationRingTopoBuilder
extends ArrayDoubleActiveTopoBuilder {
    private static final double SON_GAP = 20.0;
    private ReplicationPairQueryAtBothSideService bothSideQueryService;

    public ReplicationPairQueryAtMineSideService getBothSideQueryService() {
        return this.bothSideQueryService;
    }

    public void setBothSideQueryService(ReplicationPairQueryAtBothSideService mineSideQueryService) {
        this.bothSideQueryService = mineSideQueryService;
    }

    public void buildTopo(TopoContext context) {
        ProtectGroup pg = context.getProtectGroup();
        HashMap<String, Collection<ReplicationPair>> pairMap = new HashMap<String, Collection<ReplicationPair>>();
        if (pg.hasMultiCg()) {
            HashSet pgReplicaSet = new HashSet();
            Map<String, ProtectGroupReplica> pgReplicaByDevSn = RingTopologyUtil.recreatePgReplicaByDevSn(pg, true);
            for (Map.Entry<String, ProtectGroupReplica> entry : pgReplicaByDevSn.entrySet()) {
                pg.setReplicaList(Collections.singleton(entry.getValue()));
                pairMap.putAll(RingTopologyUtil.prepare(pg, this.getBothSideQueryService()));
                pgReplicaSet.addAll(pg.getReplicaList());
            }
            pg.setReplicaList(pgReplicaSet);
        } else {
            pairMap.putAll(RingTopologyUtil.prepare(context.getProtectGroup(), this.bothSideQueryService));
        }
        super.buildTopo(context);
        this.updateSecondSitePosition(context);
        RingTopologyUtil.updateReplicationPairStatus(context, RingTopologyUtil.spread(pairMap.values()));
    }

    private void updateSecondSitePosition(TopoContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        VerifyUtil.checkObject((Object)protectGroup);
        String ringInfoJsonStr = (String)protectGroup.getProps().get("hyper-dr-ring-used-resources");
        if (VerifyUtil.isEmpty((String)ringInfoJsonStr)) {
            logger.error((Object)"Can't get ring info from pg: %s", new Object[]{protectGroup.getUuid()});
            return;
        }
        JSONObject ringInfoObj = JSONObject.fromObject((Object)ringInfoJsonStr);
        JSONArray jsonSiteArray = JSONArray.fromObject((Object)ringInfoObj.get("recovery.site"));
        String recoverySiteId = jsonSiteArray.filter(String.class).stream().filter(siteId -> !VerifyUtil.isEmpty((String)siteId)).findFirst().orElseThrow(() -> new LegoCheckedException(2117645L));
        IElement recoveryEle = context.getElementByID((Object)(recoverySiteId + "---" + "Style:unvisible"));
        Node node = TopoServiceUtil.createUnVisibleStyleNode((TopoContext)context, (String)("preset-location-" + recoveryEle.getID()));
        recoveryEle.addChild((IData)node, 0);
        recoveryEle.setClient("layout", (Object)"topbottom");
        recoveryEle.setClient("sonsGap", (Object)20.0);
        String productSiteId = protectGroup.getProductSiteId();
        IElement productEle = context.getElementByID((Object)(productSiteId + "---" + "Style:unvisible"));
        IData parent = productEle.getParent();
        IData firstChild = parent.getChildAt(0);
        Node node1 = TopoServiceUtil.createUnVisibleStyleNode((TopoContext)context, (String)("preset-location" + firstChild.getID()));
        firstChild.addChild((IData)node1, 0);
        firstChild.setClient("layout", (Object)"topbottom");
        firstChild.setClient("sonsGap", (Object)20.0);
    }

    protected Node addProductLun(TopoContext context, String siteId, Node storageNode, Lun lun) {
        Node node = super.addProductLun(context, siteId, storageNode, lun);
        Collection<Node> endingNodes = this.getRelatedEndings(context, lun);
        Object target = node.getID();
        for (Node endingNode : endingNodes) {
            String id = "link-" + endingNode.getID() + "-" + target;
            context.linkTo(endingNode, target, (Object)id, new Skin[0]);
        }
        return node;
    }

    private Collection<Node> getRelatedEndings(TopoContext context, Lun lun) {
        HashSet<Node> endingNodes = new HashSet<Node>();
        Map endings = (Map)context.find((Object)"endings");
        if (endings == null) {
            return endingNodes;
        }
        for (Map.Entry ending : endings.entrySet()) {
            String[] key = (String[])ending.getKey();
            String wwn = key[0];
            if (wwn == null || !wwn.equalsIgnoreCase(lun.getWwn())) continue;
            Node endingNode = (Node)ending.getValue();
            endingNodes.add(endingNode);
        }
        return endingNodes;
    }

    protected boolean hasReplication(int templateType) {
        return true;
    }

    protected List<ReplicaRelation> transform(ProtectGroup pg, Set<ProtectGroupReplica> replicas) {
        HashMap repAndPoReplicaMap = new HashMap();
        ArrayList<ReplicaRelation> totalRelations = new ArrayList<ReplicaRelation>();
        for (ProtectGroupReplica pgReplica : replicas) {
            Set poReplicaSet = pgReplica.getReplicas();
            for (ProtectObjectReplica protectObjectReplica : poReplicaSet) {
                Set storageInfoSet = protectObjectReplica.getStorageInfos();
                RelicaStorageInfo storageInfo = (RelicaStorageInfo)storageInfoSet.stream().findFirst().orElseThrow(() -> new LegoCheckedException(2117645L));
                String key = storageInfo.getSrcStorageProviderSN() + ":" + storageInfo.getStorageProviderSN();
                if (!repAndPoReplicaMap.containsKey(key)) {
                    repAndPoReplicaMap.put(key, new HashSet());
                }
                Set poReplicaList = (Set)repAndPoReplicaMap.get(key);
                poReplicaList.add(protectObjectReplica);
            }
            for (Map.Entry entry : repAndPoReplicaMap.entrySet()) {
                ProtectGroupReplica tmpReplica = new ProtectGroupReplica();
                tmpReplica.setRecoverySite(pgReplica.getRecoverySite());
                tmpReplica.setRecoveryArray(pgReplica.getRecoveryArray());
                tmpReplica.setReplicas((Set)entry.getValue());
                tmpReplica.setType(pgReplica.getType());
                totalRelations.addAll(super.transform(pg, Collections.singleton(tmpReplica)));
            }
        }
        return totalRelations;
    }
}

