/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.ism.drm.storage.hvs.topology;

import com.huawei.ism.drm.protection.group.sdk.model.ProtectGroup;
import com.huawei.ism.drm.protection.replica.sdk.model.ProtectGroupReplica;
import com.huawei.ism.drm.storage.hvs.protection.util.ReplicationPairQueryAtBothSideService;
import com.huawei.ism.drm.storage.hvs.protection.util.RingTopologyUtil;
import com.huawei.ism.drm.storage.topology.ArrayReplicationHyperMetroTopoBuilder;
import com.huawei.ism.drm.topo.sdk.context.TopoContext;
import com.huawei.ism.drm.topo.utils.TopoServiceUtil;
import com.huawei.lego.core.sdk.base.annotation.ServiceBoundInfo;
import com.huawei.lego.core.sdk.exception.LegoCheckedException;
import com.huawei.lego.core.sdk.util.JSONArray;
import com.huawei.lego.core.sdk.util.JSONObject;
import com.huawei.lego.core.sdk.util.VerifyUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import twaver.IData;
import twaver.IElement;
import twaver.Node;

@ServiceBoundInfo(methodName="onBind", targetBeanName="topoBuilderManager", properties="type:PolicyTemplate-27")
public class ArrayReplicationHyperMetroRingTopoBuilder
extends ArrayReplicationHyperMetroTopoBuilder {
    private static final double SON_GAP = 50.0;
    private ReplicationPairQueryAtBothSideService bothSideQueryService;

    public void buildTopo(TopoContext context) {
        Map<Object, Object> pairMap = new HashMap();
        ProtectGroup pg = context.getProtectGroup();
        if (pg.hasMultiCg()) {
            HashSet pgReplicaSet = new HashSet();
            Map<String, ProtectGroupReplica> pgReplicaByDevSn = RingTopologyUtil.recreatePgReplicaByDevSn(pg, false);
            for (Map.Entry<String, ProtectGroupReplica> entry : pgReplicaByDevSn.entrySet()) {
                pg.setReplicaList(Collections.singleton(entry.getValue()));
                pairMap.putAll(RingTopologyUtil.prepare(pg, this.getBothSideQueryService()));
                pgReplicaSet.addAll(pg.getReplicaList());
            }
            pg.setReplicaList(pgReplicaSet);
        } else {
            pairMap = RingTopologyUtil.prepare(pg, this.getBothSideQueryService());
        }
        super.buildTopo(context);
        RingTopologyUtil.updateReplicationPairStatus(context, RingTopologyUtil.spread(pairMap.values()));
        this.updateNodeLocation(context);
    }

    private void updateNodeLocation(TopoContext context) {
        ProtectGroup protectGroup = context.getProtectGroup();
        String ringInfoJsonStr = (String)protectGroup.getProps().get("hyper-dr-ring-used-resources");
        if (VerifyUtil.isEmpty((String)ringInfoJsonStr)) {
            logger.error((Object)"Can't get ring info from pg: %s", new Object[]{protectGroup.getUuid()});
            return;
        }
        JSONObject ringInfoObj = JSONObject.fromObject((Object)ringInfoJsonStr);
        JSONArray jsonSiteArray = JSONArray.fromObject((Object)ringInfoObj.get("recovery.site"));
        String secondSiteId = jsonSiteArray.filter(String.class).stream().filter(siteId -> !VerifyUtil.isEmpty((String)siteId)).findFirst().orElseThrow(() -> new LegoCheckedException(2117645L));
        IElement anyHyperMetroNode = context.getElementByID((Object)secondSiteId);
        IData parent = anyHyperMetroNode.getParent();
        parent.setClient("layout", (Object)"leftright");
        IData hyperMetroNodeOne = parent.getChildAt(0);
        IData hyperMetroNodeTwo = parent.getChildAt(1);
        hyperMetroNodeOne.setClient("layout", (Object)"leftright");
        Node unVisibleNodeOne = TopoServiceUtil.createUnVisibleStyleNode((TopoContext)context, (String)("preset-location-" + hyperMetroNodeTwo.getID()));
        hyperMetroNodeTwo.addChild((IData)unVisibleNodeOne, 0);
        hyperMetroNodeTwo.setClient("layout", (Object)"topbottom");
        hyperMetroNodeTwo.setClient("sonsGap", (Object)50.0);
        IElement productNode = context.getElementByID((Object)protectGroup.getProductSiteId());
        Node unVisibleStyleNodeTwo = TopoServiceUtil.createUnVisibleStyleNode((TopoContext)context, (String)("preset-location-" + productNode.getID()));
        productNode.addChild((IData)unVisibleStyleNodeTwo, 0);
        productNode.setClient("layout", (Object)"topbottom");
        productNode.setClient("sonsGap", (Object)50.0);
    }

    public ReplicationPairQueryAtBothSideService getBothSideQueryService() {
        return this.bothSideQueryService;
    }

    public void setBothSideQueryService(ReplicationPairQueryAtBothSideService bothSideQueryService) {
        this.bothSideQueryService = bothSideQueryService;
    }
}

