# -*- coding:utf-8 -*-
import os
import shutil

from utils.business.vm_util import PublicServiceOM

from plugins.eReplication.common.api.pkg_api import API as PKG_API
from plugins.eReplication.common.constant import Pkg
from plugins.eReplication.common.lib.conditions import Condition


class API(object):

    @classmethod
    def create_manage_vm(
            cls, pod_id, server_name, vm_group_name, vcpus, ram, disk,
            ip_list, network_name, sys_disk=40,
            image_file_name=Pkg.SERVER_TEMP_NAME, vm_image_name=Pkg.IMAGE_NAME,
            availability_zone="manage-az", volume_type="manager.fsa.csg"):
        return PublicServiceOM().create_servers_with_group(
            pod_id, server_name, vm_group_name, vcpus, ram, disk, ip_list,
            network_name, sys_disk=sys_disk, image_file_name=image_file_name,
            vm_image_name=vm_image_name, availability_zone=availability_zone,
            volume_type=volume_type)

    @classmethod
    def delete_manage_vm(
            cls, pod_id, server_name, vm_group_name, ip_list, network_name):
        PublicServiceOM().delete_servers_with_group(
            pod_id, server_name, vm_group_name, ip_list, network_name)

    @classmethod
    def extract_os_file(
            cls, project_id, unit, size_limit, file_num_limit, temp_path,
            dest_file_name):
        """
        解压镜像文件
        :return:
        """
        kvmtemplate = Pkg.PKG_RE_X86
        os_re = Pkg.OS_RE_X86
        if Condition(project_id).is_arm:
            kvmtemplate = Pkg.PKG_RE_ARM
            os_re = Pkg.OS_RE_ARM
        pkg_path = PKG_API.get_file_abs_path_by_re(kvmtemplate)
        tmp_path = os.path.join(os.path.dirname(pkg_path), temp_path)
        if not os.path.exists(tmp_path):
            os.mkdir(tmp_path, 0o750)
        # 解压前校验文件大小
        PKG_API.check_compressed_file(
            pkg_path, unit=unit, size_limit=size_limit,
            file_num_limit=file_num_limit)
        PKG_API.extract_file(pkg_path, tmp_path)
        os_path = PKG_API.get_file_abs_path_by_re(os_re, pkg_path=tmp_path)
        shutil.move(
            os_path, os.path.join(os.path.dirname(pkg_path), dest_file_name))
        os.rmdir(tmp_path)
