# -*- coding:utf-8 -*-

import utils.common.log as logger

from plugins.eReplication.common.client.dmk_client import API as DMK_API
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.lib.params import Params

logger.init("ResetDMKFirstLogin")


class ResetDMKFirstLogin(BaseSubJob):
    """
    设置DMK用户为初始登录状态
    """

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        params = Params(self.project_id, self.pod_id)
        DMK_API.login_dmk(
            params.dmk_float_ip, params.dmk_deploy_user,
            params.dmk_user_new_pwd)
        DMK_API.reset_first_login()
