# -*- coding:utf-8 -*-

import utils.common.log as logger

from plugins.eReplication.common.dr_api import API as DR_API
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.lib.params import Nodes
from plugins.eReplication.common.lib.params import Params

logger.init("PresetDMKUser")


class PresetDMKUser(BaseSubJob):
    """
    完成eReplication服务软件的安装部署
    由于容灾软件可能是单独部署的, 此时无法依赖到其它组件参数,因此,其它组件的参数也要配置在自身服务中
    获取参数时如果从其它组件获取失败,则容灾服务自身获取,此时需要用户配置这些参数
    """

    def __init__(self, project_id, pod_id, regionid_list=None):
        super(PresetDMKUser, self).__init__(project_id, pod_id, regionid_list)
        self.nodes = Nodes(self.project_id, self.pod_id)
        self.params = Params(self.project_id, self.pod_id)

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        team_id = DR_API.create_dmk_login_user(
            self.params.dmk_float_ip, self.params.dmk_sys_user,
            self.params.dmk_sys_user_pwd, self.params.dmk_deploy_user,
            self.params.dmk_user_preset_pwd,
            self.params.dmk_user_new_pwd, self.params.dmk_deploy_group)
        DR_API.create_remote_account(
            team_id, self.nodes.hosts, self.params.dmk_deploy_user,
            self.nodes.ssh_user, self.nodes.ssh_pwd, self.nodes.sudo_pwd,
            self.params.dmk_deploy_group)
