# -*- coding:utf-8 -*-
import threading

import utils.common.log as logger

from plugins.eReplication.common.constant import Capacity
from plugins.eReplication.common.constant import VMName
from plugins.eReplication.common.constant import VMScale
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.lib.params import Params
from plugins.eReplication.common.lib.thread import ExcThread
from plugins.eReplication.common.scale_api import API as SCALE_API

logger.init("eReplicationExpansionVM")


class ExpansionVM(BaseSubJob):
    """eReplication管理虚拟机扩容接口"""

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        params = Params(self.project_id, self.pod_id)
        vm_mem = int(params.mem_num)
        vm_cpu = int(params.cpu_num)
        vms_detail = SCALE_API.query_cpu_mem(pod_id, VMName.VM_NAME_PREFIX)

        new_group = VMName.MEW_GROUP_NAME
        # 扩容虚拟机规格
        expand_funcs = list()
        thread_name = threading.current_thread().name
        for vm_info in vms_detail:
            origin_vcpus = int(vm_info.get("vcpus"))
            try:
                origin_ram = int(vm_info.get("ram")) / Capacity.ONE_THOUSAND
            except ZeroDivisionError as e:
                logger.error(
                    f"{Capacity.ONE_THOUSAND} cannot be used as a divisor.")
                raise e
            if (origin_vcpus == VMScale.CPU_4 and
                origin_ram == VMScale.RAM_8) and (
                    vm_cpu == VMScale.CPU_8 and vm_mem == VMScale.RAM_16):
                vm_id = vm_info.get("id")
                expand_func = (
                    SCALE_API.expand_vm_scale, thread_name,
                    (
                        pod_id, vm_id, VMName.SERVICE_NAME, new_group,
                        VMScale.CPU_8, VMScale.RAM_16
                    ), {"disk": VMScale.DISK_0, "sys_disk": VMScale.DISK_0}
                )
                expand_funcs.append(expand_func)
        if expand_funcs:
            ExcThread.exec_func_in_thread(expand_funcs)
