#!/bin/bash
function configWatchDog(){
    local key1=kernel.hung_task_panic
    local key2=kernel.hung_task_timeout_secs
    local sysctlFile=/etc/sysctl.conf
    cat "$sysctlFile" | grep -w "$key1" | grep -v "^#" &>/dev/null
    if [ $? -ne 0 ];then
        echo "${key1}=1" >> "$sysctlFile"
    else
        sed -i "s/${key1}=.*/${key1}=1/g" "$sysctlFile"
    fi

    cat "$sysctlFile" | grep -w "$key2" | grep -v "^#" &>/dev/null
    if [ $? -ne 0 ];then
        echo "${key2}=60" >> "$sysctlFile"
    else
        sed -i "s/${key2}=.*/${key2}=60/g" "${sysctlFile}"
    fi

    local result=`cat /etc/fstab | grep "/opt"`
    if [ ! -z "$result" ];then
        echo "$result" | grep "errors=panic" &>/dev/null
        if [ $? -ne 0 ];then
            local curValue=`cat /etc/fstab | grep "/opt" | awk '{print $4}'`
            sed -i "s/${curValue}/${curValue},errors=panic/g" /etc/fstab
        fi
    fi
    return 0
}
configWatchDog
if [ $? -eq 0 ];then
    echo "config watchdog successfully"
    exit 0
else
    echo "config watchdog failed"
    exit 1
fi
