# -*- coding:utf-8 -*-

import utils.common.log as logger
from utils.common.check_result import CheckResult

from plugins.eReplication.common.dr_api import API as DR_API
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_check_result
from plugins.eReplication.common.lib.params import Nodes
from plugins.eReplication.common.lib.params import Params

logger.init("eReplication")


class PresetDMKUser(BaseSubJob):
    """初始化DMK账户"""

    @handle_task_check_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """标准调用接口：执行安装前预检查&安装&配置

        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        nodes = Nodes(self.project_id, self.pod_id)
        params = Params(self.project_id, self.pod_id)
        dmk_float_ip = params.dmk_float_ip
        dmk_sys_user = params.dmk_sys_user
        dmk_sys_user_pwd = params.dmk_sys_user_pwd
        dmk_deploy_user = params.dmk_deploy_user
        dmk_user_preset_pwd = params.dmk_user_preset_pwd
        dmk_user_new_pwd = params.dmk_user_new_pwd
        dmk_deploy_group = params.dmk_deploy_group
        all_hosts = nodes.all_hosts
        ssh_user = nodes.ssh_user
        ssh_pwd = nodes.ssh_pwd
        sudo_pwd = nodes.sudo_pwd
        team_id = DR_API.create_dmk_login_user(
            dmk_float_ip, dmk_sys_user, dmk_sys_user_pwd, dmk_deploy_user,
            dmk_user_preset_pwd, dmk_user_new_pwd, dmk_deploy_group)
        DR_API.create_remote_account(
            team_id, all_hosts, dmk_deploy_user, ssh_user, ssh_pwd, sudo_pwd,
            dmk_deploy_group)
        check = CheckResult(
            itemname_ch="迁移前初始化DMK帐户",
            itemname_en="Initialize Dmk Account Before Migrate",
            status="success", error_msg_cn="")
        return [check]
