# -*- coding:utf-8 -*-

import utils.common.log as logger

from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.patch_api import API as PATCH_API

logger.init("InstallPatch")


class RollbackPatch(BaseSubJob):
    """
    完成eReplication服务软件的补丁包卸载
    """

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """
        标准调用接口：卸载补丁
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """

        PATCH_API.execute_rollback(project_id, pod_id, is_migrate=True)
