# -*- coding:utf-8 -*-

import utils.common.log as logger
from utils.business.project_util import ProjectApi

from plugins.eReplication.common.constant import Component
from plugins.eReplication.common.lib.base import BaseSubJob
from plugins.eReplication.common.lib.decorator import handle_task_result
from plugins.eReplication.common.upgrade_api import API as UPGRADE_API

logger.init("eReplication")


class SaveVersion(BaseSubJob):

    @handle_task_result
    def execute(self, project_id, pod_id, *args, **kwargs):
        """标准调用接口：执行安装&配置

        :param project_id:
        :param pod_id:
        :return:
        """

        # 获取Server升级前后版本号
        info = UPGRADE_API(
            self.project_id, self.pod_id, self.region_id).get_version_info()
        project = ProjectApi()
        project.save_version_info(project_id, Component.REPLICATION, info)
