import utils.common.log as logger

from plugins.CSBS.common.dpa_connect_karbor import DpaConnectKarbor
from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.scripts.deploy.karborproxy.config.agent_proxy_param import AgentProxyDPAInfos

logger.init("KarborProxy Connection Karbor And DPA")


class DeployDpaConnectKarbor(DpaConnectKarbor):
    def __init__(self, project_id, pod_id):
        super(DeployDpaConnectKarbor, self).__init__(project_id, pod_id)
        self.agent_proxy = AgentProxyDPAInfos(project_id, pod_id)
        karbor_info = KarborUtil(project_id, pod_id)

        self.karbor_version = karbor_info.get_karbor_version().get('short_version')
        karbor_nodes = karbor_info.get_karbor_node_list()[0]
        if len(karbor_nodes) > 0:
            self.karbor_node = karbor_nodes[0]
