# -*- coding:utf-8 -*-
import utils.common.log as logger
from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.params_tool import Params
from plugins.CSBS.scripts.deploy.karbor.api_adapter import API
from utils.business.dmk_util import DmkApi
from utils.common.exception import HCCIException

logger.init("CSBS")


class DmkTool(object):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.role = '2'
        self.db_param_dict = Params(self.project_id, self.pod_id).get_params()
        self.karbor_util = KarborUtil(self.project_id, self.pod_id)
        self.karbor_user_info = self.karbor_util.get_karbor_user_info()
        self.dmk_api = DmkApi()
        self.team_id, self.user_id = None, None
        self.dmk_float_ip = self.db_param_dict['dmk_floatIp']
        self.dmk_user = self.db_param_dict['CBS_dmk_groupadminname']
        self.cbs_dmk_groupname = self.db_param_dict['CBS_dmk_groupname']
        self.cbs_dmk_tmp_pwd = self.db_param_dict['tmp_CBS_dmk_grouppasswd']
        self.user_pwd = self.db_param_dict['CBS_dmk_grouppasswd']
        self.dmk_ui_username = self.db_param_dict['dmk_ui_username']
        self.dmk_ui_password = self.db_param_dict['dmk_ui_password']
        self.dpamanager_username = \
            self.db_param_dict['KarborProxy_dpamanager_username']
        self.dpamanager_pwd = \
            self.db_param_dict['KarborProxy_dpamanager_password']
        self.karbor_proxy_root_username = \
            self.db_param_dict['KarborProxy_root_username']
        self.karbor_proxy_root_pwd = \
            self.db_param_dict['KarborProxy_root_password']

    def create_dmk_user(self):
        # 创建用户，使用dmk管理员账户
        logger.info(f'Login dmk, dmk_floatIp:{self.dmk_float_ip}, '
                    f'dmk_ui_username:{self.dmk_ui_username}.')
        API.login_dmk(self.dmk_float_ip,
                      self.dmk_ui_username,
                      self.dmk_ui_password)
        logger.info(f'Start creating dmk user, username:{self.dmk_user},'
                    f'team_name:{self.cbs_dmk_groupname}.')
        self.team_id, self.user_id = API.createdmkuser(self.dmk_user,
                                                       self.cbs_dmk_tmp_pwd,
                                                       self.role,
                                                       self.cbs_dmk_groupname,
                                                       self.pod_id)

        # 初次修改用户密码
        logger.info('Start modifying user password firstly.')
        API.login_dmk(self.dmk_float_ip, self.dmk_user, self.cbs_dmk_tmp_pwd)
        API.changedmkuserpasswd(self.user_id, self.cbs_dmk_tmp_pwd,
                                self.user_pwd)

    def create_dmk_account(self):
        def _create_dmk_root_account():
            account_root_id = None
            try:
                account_root_id = self.dmk_api.get_dmk_account_id(
                    self.dmk_user, self.karbor_user_info.root_name)
            except HCCIException:
                # 说明没有该account_root_name，那么之后就调用创建账号接口，
                # 否则调用更新接口
                pass
            except Exception as e:
                logger.error(f"Execute error:{str(e)}.")
                raise e
            # 如果Karbor节点的root密码和Proxy节点root密码不同，是扩容Proxy场景，
            # 则使用Proxy节点root密码创建DMK账号
            if self.karbor_user_info.root_pwd == self.karbor_proxy_root_pwd:
                root_pwd = self.karbor_user_info.root_pwd
            else:
                root_pwd = self.karbor_proxy_root_pwd
            if account_root_id:
                self.dmk_api.update_account_to_multi_team(
                    self.dmk_user, self.karbor_user_info.root_name,
                    [self.dmk_user], root_pwd,
                    root_pwd)
            else:
                self.dmk_api.add_account_to_dmk(
                    self.karbor_user_info.root_name, self.team_id,
                    root_pwd, root_pwd)

        cbs_admin_name = "cbs_admin"
        cbs_deploy_name = "cbs_deploy"
        cbs_deploy_pwd = self.db_param_dict['deploy_accountpasswd']
        cbs_admin_pwd = self.db_param_dict['admin_accountpasswd']

        # CBS
        self.dmk_api.login_dmk(self.dmk_float_ip, self.dmk_user, self.user_pwd)

        # 如果账号仓库中已经有djmanager、cbs_admin、cbs_deploy、root,
        # 则删除账号然后重新创建
        # 主要是解决用户在已经装过的环境中修改了这些账号的密码，再重新安装会出现bug
        _create_dmk_root_account()

        account_cbs_deploy_id = None
        try:
            account_cbs_deploy_id = self.dmk_api.get_dmk_account_id(
                self.dmk_user, cbs_deploy_name)
        except HCCIException:
            pass
        except Exception as e:
            logger.error(f"Execute error:{str(e)}.")
            raise e

        if account_cbs_deploy_id:
            self.dmk_api.update_account_to_multi_team(
                self.dmk_user, cbs_deploy_name, [self.dmk_user],
                cbs_deploy_pwd, self.karbor_user_info.root_pwd)
        else:
            self.dmk_api.add_account_to_dmk(cbs_deploy_name, self.team_id,
                                            cbs_deploy_pwd,
                                            self.karbor_user_info.root_pwd)

        account_cbs_admin_id = None
        try:
            account_cbs_admin_id = self.dmk_api.get_dmk_account_id(
                self.dmk_user, cbs_admin_name)
        except HCCIException:
            pass
        except Exception as e:
            logger.error(f"Execute error:{str(e)}.")
            raise e

        if account_cbs_admin_id:
            self.dmk_api.update_account_to_multi_team(
                self.dmk_user, cbs_admin_name, [self.dmk_user],
                cbs_admin_pwd, self.karbor_user_info.root_pwd)
        else:
            self.dmk_api.add_account_to_dmk(
                cbs_admin_name, self.team_id,
                cbs_admin_pwd, self.karbor_user_info.root_pwd)

        account_djmanager_id = None
        try:
            account_djmanager_id = self.dmk_api.get_dmk_account_id(
                self.dmk_user, self.karbor_user_info.user_name)
        except HCCIException:
            pass
        except Exception as e:
            logger.error(f"Execute error:{str(e)}.")
            raise e

        if account_djmanager_id:
            self.dmk_api.update_account_to_multi_team(
                self.dmk_user, self.karbor_user_info.user_name,
                [self.dmk_user],
                self.karbor_user_info.user_pwd,
                self.karbor_user_info.root_pwd)
        else:
            self.dmk_api.add_account_to_dmk(
                self.karbor_user_info.user_name, self.team_id,
                self.karbor_user_info.user_pwd,
                self.karbor_user_info.root_pwd)

        account_dpamanager_id = None
        try:
            account_dpamanager_id = self.dmk_api.get_dmk_account_id(
                self.dmk_user, self.dpamanager_username)
        except HCCIException:
            pass
        except Exception as e:
            logger.error(f"Execute error:{str(e)}.")
            raise e

        if account_dpamanager_id:
            self.dmk_api.update_account_to_multi_team(
                self.dmk_user, self.dpamanager_username,
                [self.dmk_user],
                self.dpamanager_pwd,
                self.karbor_proxy_root_pwd)
        else:
            self.dmk_api.add_account_to_dmk(
                self.dpamanager_username, self.team_id,
                self.dpamanager_pwd,
                self.karbor_proxy_root_pwd)

        team_list = [self.dmk_user, 'OTD']

        self.dmk_api.login_dmk(self.dmk_float_ip, self.dmk_user,
                               self.user_pwd)
        user_id = self.dmk_api.get_dmk_user_id()
        self.dmk_api.login_dmk(self.dmk_float_ip,
                               self.dmk_ui_username,
                               self.dmk_ui_password)
        result_dmk = self.dmk_api.update_user_to_multi_team(user_id,
                                                            self.role,
                                                            team_list)
        if not result_dmk:
            logger.error("Update user to multi_team for CBS failed.")
            raise HCCIException(640004)

    def reset_dmk_first_login(self):
        self.dmk_api.login_dmk(self.dmk_float_ip, self.dmk_user, self.user_pwd)
        self.dmk_api.reset_first_login()
