import utils.common.log as logger

from plugins.CSBS.common.dpa_connect_karbor import DpaConnectKarbor
from plugins.CSBS.common.upgrade.params import ParamsTools

logger.init("KarborProxy Connection Karbor And DPA")


class UpgradeDpaConnectKarbor(DpaConnectKarbor):
    def __init__(self, project_id, pod_id):
        super(UpgradeDpaConnectKarbor, self).__init__(project_id, pod_id)
        self.params_tool = ParamsTools(project_id)
        self.karbor_version = self.params_tool.get_karbor_version().get('short_version')
        karbor_nodes = self.params_tool.get_karbor_node_list()
        if len(karbor_nodes) > 0:
            self.karbor_node = karbor_nodes[0]