from plugins.AcceptanceTest_Upgrade.basic_mo_test.common.login_sc import LoginSC


class ManageOne(object):
    def __init__(self, http_client, is_b2b, context):
        self.http_client = http_client
        self.is_b2b = is_b2b
        self.context = context

    def get_cloud_infras_by_region_name(self, console_host,
                                        region_name="ALL", headers=None):
        region_name_filed = "" if region_name == "ALL" else region_name
        if self.is_b2b:
            url = "https://{host}/moserviceaccesswebsite/goku/rest/" \
                  "serviceaccess/v3.0/regions?" \
                  "name={region}".format(host=console_host,
                                         region=region_name_filed)
        else:
            url = "https://{host}/motenantconsolehomewebsite/goku/rest/" \
                  "serviceaccess/v3.0/regions?" \
                  "name={region}".format(host=console_host,
                                         region=region_name_filed)

        _, body = self.http_client.get(url, verify=False,
                                       allow_redirects=False,
                                       headers=headers)
        records = body.get("records")

        def get_cloud_infra(_cloud_infra):
            cloud_infra_l = list()
            cloud_infra_l.append(_cloud_infra["region_id"])
            cloud_infra_l.append(_cloud_infra["id"])
            cloud_infra_l.append(_cloud_infra["name"])
            return cloud_infra_l

        def _get_cloud_infra_list():
            cloud_infras = region_info["cloud_infras"]
            for cloud_infra in cloud_infras:
                if cloud_infra["type"] == "FUSION_CLOUD":
                    cloud_infra_list.append(get_cloud_infra(cloud_infra))

        cloud_infra_list = []
        for region_info in records:
            if region_name == region_info["name"]:
                _get_cloud_infra_list()
            elif region_name == "ALL":
                _get_cloud_infra_list()
        return cloud_infra_list

    def get_region_name(self):
        return LoginSC(
            self.context.engine_info['project_id'],
            self.context.engine_info['region_id'],
            self.context.engine_info['region_type']
        ).get_region_name_and_az_name()[0]
