import utils.common.log as logger
from utils.common.check_result import CheckResult
from utils.common.exception import HCCIException
from utils.common.message import Message

from plugins.CSBS.common.step_base import UpgradeBaseSubJob
from plugins.CSBS.common.upgrade.karbor import KarborOperation
from plugins.CSBS.common.upgrade.params import ParamsTools

logger.init("CSBS-VBS")


class PreCheckCipherType(UpgradeBaseSubJob):
    def __init__(self, project_id, pod_id, regionid_list):
        super(PreCheckCipherType, self).__init__(project_id, pod_id,
                                                 regionid_list)
        self.karbor_operation = KarborOperation(self.project_id)
        self.param_tool = ParamsTools(project_id)

    def execute(self, project_id, pod_id, regionid_list=None):
        """Plug-in internal interface.

        Perform installation & configuration.
        """
        cipher_type = self.param_tool.get_cipher_type()
        logger.info(f"The current cipher types is {cipher_type.cur_cipher_type}.")
        try:
            karbor_cipher_type = self.karbor_operation.get_cipher_type()
        except Exception as e:
            logger.error(f"Execute error:{e}.")
            return Message(500, HCCIException(645039, str(e)))
        if karbor_cipher_type != cipher_type.cur_cipher_type:
            logger.error("The current cipher type does not match the cipher type of the karbor node.")
            return Message(500, HCCIException(645038, karbor_cipher_type,
                                              cipher_type.cur_cipher_type))
        logger.info("Checking the cipher type succeed.")
        return Message(200, check_results=[CheckResult(status="success")])
