# -*- coding:utf-8 -*-
import os
from utils.business.vm_util import PublicServiceOM
from utils.common.ssh_util import Ssh
from utils.business.dmk_util import DmkApi
from utils.common.fic_base import ToolClient
import utils.common.software_package_util as FileUtil


class API(object):
    SCRIPT_PATH = os.path.dirname(os.path.realpath(__file__)) + "/../../conf/"
    DMK_CLIENT = ToolClient.DMK_CLIENT
    DMK = DmkApi()
    VM_UTIL = PublicServiceOM()
    SSH_UTIL = Ssh()

    @classmethod
    def createdmkuser(cls, username, password, role, team_name, pod_id=None):
        return cls.DMK.create_dmk_user(username, password, role, team_name)

    @classmethod
    def addaccounttodmk(cls, account, team_id, password, sudo_passwd, pod_id=None):
        return cls.DMK.add_account_to_dmk(account, team_id, password, sudo_passwd)

    @classmethod
    def changedmkuserpasswd(cls, user_id, old_password, new_password, pod_id=None):
        return cls.DMK.change_dmk_user_passwd(user_id, old_password, new_password)

    @classmethod
    def get_dmk_info(cls, pod_id):
        return cls.DMK.get_dmk_info(pod_id)

    @classmethod
    def get_service_param_dict(cls, db, pod_id, service_name):
        return db.get_service_cloud_param(pod_id, service_name)

    @classmethod
    def executedmkdeployment(cls, app_name, to_run, app_version, deploy_action, hosts_content,
                             vars_content, account_id, pod_id=None):
        return cls.DMK.excute_dmk_deployment(app_name, to_run, app_version, deploy_action, hosts_content,
                                             vars_content, account_id)

    @classmethod
    def find_file(cls, pkg_pre_name, pkg_post_name, pkg_version=None):
        return FileUtil.find_software_package_by_name(pkg_pre_name, pkg_post_name, pkg_version)

    @classmethod
    def uploadpkgtodmk(cls, dmk_ip, ssh_user, ssh_pwd, file_path, pod_id):
        return cls.DMK.upload_pkg_to_dmk(dmk_ip, ssh_user, ssh_pwd, file_path, pod_id)

    @classmethod
    def create_ssh_client(cls, ip, username, passwd, port=22, timeout=5, pub_key=None, status=True):
        return cls.SSH_UTIL.ssh_create_client(ip, username, passwd, port, timeout, pub_key, status)

    @classmethod
    def exec_ssh_command(cls, ssh_client, cmds, expect, timeout, retry_times=0):
        return cls.SSH_UTIL.ssh_send_command(ssh_client, cmds, expect, timeout, retry_times)

    @classmethod
    def get_package_version(cls, package_name):
        return FileUtil.get_package_version(package_name)

    @classmethod
    def get_dmk_account_id(cls, user_name, account_name, pod_id=None):
        return cls.DMK.get_dmk_account_id(user_name, account_name)

    @classmethod
    def getdmklastdeployconfig(cls, app_name, pod_id=None):
        return cls.DMK.get_dmk_last_deploy_config(app_name, pod_id)

    @classmethod
    def login_dmk(cls, dmk_ip, user_name, password, dmk_port='8443'):
        return cls.DMK.login_dmk(dmk_ip, user_name, password, dmk_port)

    @classmethod
    def create_servers_with_group(cls, pod_id, server_name, vm_group_name, vcpus, ram, disk,
                                  ip_list, network_name, sys_disk=40,
                                  image_file_name="kvm_euler_basetemp",
                                  vm_image_name="image-kvm-euler",
                                  availability_zone="manage-az",
                                  image_template_type=0,
                                  volume_type="manager.fsa.csg", ip_list_ex=None,
                                  network_name_ex=None):
        cls.VM_UTIL.create_servers_with_group(pod_id, server_name, vm_group_name, vcpus, ram, disk,
                                              ip_list, network_name, sys_disk,
                                              image_file_name,
                                              vm_image_name,
                                              availability_zone,
                                              image_template_type,
                                              volume_type, ip_list_ex,
                                              network_name_ex)

    @classmethod
    def delete_servers_with_group(cls, pod_id, server_name, vm_group_name, ip_list, network_name,
                                  ip_list_ex=None, network_name_ex=None):
        cls.VM_UTIL.delete_servers_with_group(pod_id, server_name, vm_group_name, ip_list, network_name,
                                              ip_list_ex, network_name_ex)

    @classmethod
    def get_dmk_public_config(cls, pod_id=None):
        return cls.DMK.get_dmk_public_config()

    @classmethod
    def dmksetpublicconfig(cls, content, config_type="public", pod_id=None):
        return cls.DMK.dmk_set_config(content, config_type)

    @classmethod
    def extract_file(cls, file_path, target_path):
        return FileUtil.extract_software_pkg(file_path, target_path)
