from plugins.CSBS.common import node_installer
from plugins.CSBS.common.karbor import KarborUtil
from plugins.CSBS.common.ssh_client import SshClient


class KarborHealth(node_installer.ThreadInstaller):
    def __init__(self, project_id, pod_id):
        self.karbor_util = KarborUtil(project_id, pod_id)
        nod_list = self.karbor_util.get_karbor_node_list()
        super(KarborHealth, self).__init__(nod_list)
        self.error_service = list()
        self.ssh_client = SshClient()

    def check_karbor(self, ssh_client):
        cmds = "source /opt/huawei/dj/inst/utils.sh;check_karbor_connect | sed 's/ //g'"
        result = self.ssh_client.ssh_exec_command_return(ssh_client, cmds)
        if not self.ssh_client.is_ssh_cmd_executed(result):
            self.error_service.append("check_karbor_connect")
            return False
        if len(result) < 10:
            self.error_service.append("check_karbor_connect")
            return False
        for result in result:
            status = result.split("|")
            if len(status) == 7 and status[3] == "Error":
                self.error_service.append(status[1] + status[2])
                return False
        return True

    def install_thread(self, karbor_node):
        karbor_client = self.ssh_client.get_ssh_client(karbor_node)
        if self.check_karbor(karbor_client):
            self.install_result[karbor_node.ip] = True
        self.ssh_client.ssh_close(karbor_client)

    def check_thread(self, karbor_node):
        self.check_result[karbor_node.ip] = True

    def rollback_thread(self, karbor_node):
        self.rollback_result[karbor_node.ip] = True
